/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class FooterRecord
extends Record {
    public static final short sid = 21;
    private byte field_1_footer_len;
    private byte field_2_reserved;
    private byte field_3_unicode_flag;
    private String field_4_footer;

    public FooterRecord() {
    }

    public FooterRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 21) {
            throw new RecordFormatException("NOT A FooterRECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        if (in.remaining() > 0) {
            this.field_1_footer_len = in.readByte();
            this.field_2_reserved = in.readByte();
            this.field_3_unicode_flag = in.readByte();
            this.field_4_footer = this.isMultibyte() ? in.readUnicodeLEString(LittleEndian.ubyteToInt(this.field_1_footer_len)) : in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_1_footer_len));
        }
    }

    public boolean isMultibyte() {
        return (this.field_3_unicode_flag & 0xFF) == 1;
    }

    public void setFooterLength(byte len) {
        this.field_1_footer_len = len;
    }

    public void setFooter(String footer) {
        this.field_4_footer = footer;
        this.field_3_unicode_flag = (byte)(StringUtil.hasMultibyte(this.field_4_footer) ? 1 : 0);
    }

    public short getFooterLength() {
        return (short)(0xFF & this.field_1_footer_len);
    }

    public String getFooter() {
        return this.field_4_footer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FOOTER]\n");
        buffer.append("    .footerlen      = ").append(Integer.toHexString(this.getFooterLength())).append("\n");
        buffer.append("    .footer         = ").append(this.getFooter()).append("\n");
        buffer.append("[/FOOTER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int len = 4;
        if (this.getFooterLength() > 0) {
            len += 3;
        }
        short bytelen = (short)(this.isMultibyte() ? this.getFooterLength() * 2 : this.getFooterLength());
        LittleEndian.putShort(data, 0 + offset, (short)21);
        LittleEndian.putShort(data, 2 + offset, (short)(len - 4 + bytelen));
        if (this.getFooterLength() > 0) {
            data[4 + offset] = (byte)this.getFooterLength();
            data[6 + offset] = this.field_3_unicode_flag;
            if (this.isMultibyte()) {
                StringUtil.putUnicodeLE(this.getFooter(), data, 7 + offset);
            } else {
                StringUtil.putCompressedUnicode(this.getFooter(), data, 7 + offset);
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.getFooterLength() > 0) {
            retval += 3;
        }
        return this.isMultibyte() ? retval + this.getFooterLength() * 2 : retval + this.getFooterLength();
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        FooterRecord rec = new FooterRecord();
        rec.field_1_footer_len = this.field_1_footer_len;
        rec.field_2_reserved = this.field_2_reserved;
        rec.field_3_unicode_flag = this.field_3_unicode_flag;
        rec.field_4_footer = this.field_4_footer;
        return rec;
    }
}

