/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public final class FileSharingRecord
extends Record {
    public static final short sid = 91;
    private short field_1_readonly;
    private short field_2_password;
    private byte field_3_username_unicode_options;
    private String field_3_username_value;

    public FileSharingRecord() {
    }

    public FileSharingRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 91) {
            throw new RecordFormatException("NOT A FILESHARING RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_readonly = in.readShort();
        this.field_2_password = in.readShort();
        short nameLen = in.readShort();
        if (nameLen > 0) {
            this.field_3_username_unicode_options = in.readByte();
            this.field_3_username_value = in.readCompressedUnicode(nameLen);
        } else {
            this.field_3_username_value = "";
        }
    }

    public static short hashPassword(String password) {
        byte[] passwordCharacters = password.getBytes();
        int hash = 0;
        if (passwordCharacters.length > 0) {
            int charIndex = passwordCharacters.length;
            while (charIndex-- > 0) {
                hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
                hash ^= passwordCharacters[charIndex];
            }
            hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
            hash ^= passwordCharacters.length;
            hash ^= 0xCE4B;
        }
        return (short)hash;
    }

    public void setReadOnly(short readonly) {
        this.field_1_readonly = readonly;
    }

    public short getReadOnly() {
        return this.field_1_readonly;
    }

    public void setPassword(short password) {
        this.field_2_password = password;
    }

    public short getPassword() {
        return this.field_2_password;
    }

    public short getUsernameLength() {
        return (short)this.field_3_username_value.length();
    }

    public String getUsername() {
        return this.field_3_username_value;
    }

    public void setUsername(String username) {
        this.field_3_username_value = username;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FILESHARING]\n");
        buffer.append("    .readonly       = ").append(this.getReadOnly() == 1 ? "true" : "false").append("\n");
        buffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        buffer.append("    .username       = ").append(this.getUsername()).append("\n");
        buffer.append("[/FILESHARING]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)91);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.getReadOnly());
        LittleEndian.putShort(data, 6 + offset, this.getPassword());
        LittleEndian.putShort(data, 8 + offset, this.getUsernameLength());
        if (this.getUsernameLength() > 0) {
            LittleEndian.putByte(data, 10 + offset, this.field_3_username_unicode_options);
            StringUtil.putCompressedUnicode(this.getUsername(), data, 11 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        short nameLen = this.getUsernameLength();
        if (nameLen < 1) {
            return 10;
        }
        return 11 + nameLen;
    }

    public short getSid() {
        return 91;
    }

    public Object clone() {
        FileSharingRecord clone = new FileSharingRecord();
        clone.setReadOnly(this.field_1_readonly);
        clone.setPassword(this.field_2_password);
        clone.setUsername(this.field_3_username_value);
        return clone;
    }
}

