/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.util.PWDUtils;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class FilePassRecord
extends Record {
    public static final short sid = 47;
    private short field_1_key;
    private short field_2_hash;
    private String pwdString = null;

    public FilePassRecord() {
    }

    public FilePassRecord(RecordInputStream recordinputstream) {
        super(recordinputstream);
    }

    protected void validateSid(short word0) {
        if (word0 != 47) {
            throw new RecordFormatException("NOT A FILEPASS RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordinputstream) {
        recordinputstream.readShort();
        this.field_1_key = recordinputstream.readShort();
        this.field_2_hash = recordinputstream.readShort();
    }

    public short getKey() {
        return this.field_1_key;
    }

    public void setKey(short word0) {
        this.field_1_key = word0;
    }

    public short getHash() {
        return this.field_2_hash;
    }

    public void setHash(short word0) {
        this.field_2_hash = word0;
    }

    public void setPassword(String s) {
        this.pwdString = s;
        byte[] abyte0 = s.getBytes();
        this.setKey(PWDUtils.getEncryptionKey(abyte0));
        this.setHash(PWDUtils.getPasswordHash(abyte0));
    }

    public String getPassword() {
        return this.pwdString;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("[FILEPASS]\n");
        stringbuffer.append("    .key            = ").append(Integer.toHexString(this.getKey())).append("\n");
        stringbuffer.append("    .hash           = ").append(Integer.toHexString(this.getHash())).append("\n");
        stringbuffer.append("[/FILEPASS]\n");
        return stringbuffer.toString();
    }

    public int serialize(int i, byte[] abyte0) {
        LittleEndian.putShort(abyte0, 0 + i, (short)47);
        LittleEndian.putShort(abyte0, 2 + i, (short)6);
        LittleEndian.putShort(abyte0, 4 + i, (short)0);
        LittleEndian.putShort(abyte0, 6 + i, this.getKey());
        LittleEndian.putShort(abyte0, 8 + i, this.getHash());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 47;
    }

    public Object clone() {
        return super.clone();
    }
}

