/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class CommonObjectDataSubRecord
extends SubRecord {
    public static final short sid = 21;
    private short field_1_objectType;
    public static final short OBJECT_TYPE_GROUP = 0;
    public static final short OBJECT_TYPE_LINE = 1;
    public static final short OBJECT_TYPE_RECTANGLE = 2;
    public static final short OBJECT_TYPE_OVAL = 3;
    public static final short OBJECT_TYPE_ARC = 4;
    public static final short OBJECT_TYPE_CHART = 5;
    public static final short OBJECT_TYPE_TEXT = 6;
    public static final short OBJECT_TYPE_BUTTON = 7;
    public static final short OBJECT_TYPE_PICTURE = 8;
    public static final short OBJECT_TYPE_POLYGON = 9;
    public static final short OBJECT_TYPE_RESERVED1 = 10;
    public static final short OBJECT_TYPE_CHECKBOX = 11;
    public static final short OBJECT_TYPE_OPTION_BUTTON = 12;
    public static final short OBJECT_TYPE_EDIT_BOX = 13;
    public static final short OBJECT_TYPE_LABEL = 14;
    public static final short OBJECT_TYPE_DIALOG_BOX = 15;
    public static final short OBJECT_TYPE_SPINNER = 16;
    public static final short OBJECT_TYPE_SCROLL_BAR = 17;
    public static final short OBJECT_TYPE_LIST_BOX = 18;
    public static final short OBJECT_TYPE_GROUP_BOX = 19;
    public static final short OBJECT_TYPE_COMBO_BOX = 20;
    public static final short OBJECT_TYPE_RESERVED2 = 21;
    public static final short OBJECT_TYPE_RESERVED3 = 22;
    public static final short OBJECT_TYPE_RESERVED4 = 23;
    public static final short OBJECT_TYPE_RESERVED5 = 24;
    public static final short OBJECT_TYPE_COMMENT = 25;
    public static final short OBJECT_TYPE_RESERVED6 = 26;
    public static final short OBJECT_TYPE_RESERVED7 = 27;
    public static final short OBJECT_TYPE_RESERVED8 = 28;
    public static final short OBJECT_TYPE_RESERVED9 = 29;
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;
    private short field_2_objectId;
    private short field_3_option;
    private BitField locked = BitFieldFactory.getInstance(1);
    private BitField printable = BitFieldFactory.getInstance(16);
    private BitField autofill = BitFieldFactory.getInstance(8192);
    private BitField autoline = BitFieldFactory.getInstance(16384);
    private int field_4_reserved1;
    private int field_5_reserved2;
    private int field_6_reserved3;

    public CommonObjectDataSubRecord() {
    }

    public CommonObjectDataSubRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 21) {
            throw new RecordFormatException("Not a CommonObjectData record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_objectType = in.readShort();
        this.field_2_objectId = in.readShort();
        this.field_3_option = in.readShort();
        this.field_4_reserved1 = in.readInt();
        this.field_5_reserved2 = in.readInt();
        this.field_6_reserved3 = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ftCmo]\n");
        buffer.append("    .objectType           = ").append("0x").append(HexDump.toHex(this.getObjectType())).append(" (").append(this.getObjectType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .objectId             = ").append("0x").append(HexDump.toHex(this.getObjectId())).append(" (").append(this.getObjectId()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .option               = ").append("0x").append(HexDump.toHex(this.getOption())).append(" (").append(this.getOption()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .locked                   = ").append(this.isLocked()).append('\n');
        buffer.append("         .printable                = ").append(this.isPrintable()).append('\n');
        buffer.append("         .autofill                 = ").append(this.isAutofill()).append('\n');
        buffer.append("         .autoline                 = ").append(this.isAutoline()).append('\n');
        buffer.append("    .reserved1            = ").append("0x").append(HexDump.toHex(this.getReserved1())).append(" (").append(this.getReserved1()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved2            = ").append("0x").append(HexDump.toHex(this.getReserved2())).append(" (").append(this.getReserved2()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved3            = ").append("0x").append(HexDump.toHex(this.getReserved3())).append(" (").append(this.getReserved3()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/ftCmo]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)21);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_objectType);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_objectId);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_option);
        LittleEndian.putInt(data, 10 + offset + pos, this.field_4_reserved1);
        LittleEndian.putInt(data, 14 + offset + pos, this.field_5_reserved2);
        LittleEndian.putInt(data, 18 + offset + pos, this.field_6_reserved3);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        CommonObjectDataSubRecord rec = new CommonObjectDataSubRecord();
        rec.field_1_objectType = this.field_1_objectType;
        rec.field_2_objectId = this.field_2_objectId;
        rec.field_3_option = this.field_3_option;
        rec.field_4_reserved1 = this.field_4_reserved1;
        rec.field_5_reserved2 = this.field_5_reserved2;
        rec.field_6_reserved3 = this.field_6_reserved3;
        return rec;
    }

    public short getObjectType() {
        return this.field_1_objectType;
    }

    public void setObjectType(short field_1_objectType) {
        this.field_1_objectType = field_1_objectType;
    }

    public short getObjectId() {
        return this.field_2_objectId;
    }

    public void setObjectId(short field_2_objectId) {
        this.field_2_objectId = field_2_objectId;
    }

    public short getOption() {
        return this.field_3_option;
    }

    public void setOption(short field_3_option) {
        this.field_3_option = field_3_option;
    }

    public int getReserved1() {
        return this.field_4_reserved1;
    }

    public void setReserved1(int field_4_reserved1) {
        this.field_4_reserved1 = field_4_reserved1;
    }

    public int getReserved2() {
        return this.field_5_reserved2;
    }

    public void setReserved2(int field_5_reserved2) {
        this.field_5_reserved2 = field_5_reserved2;
    }

    public int getReserved3() {
        return this.field_6_reserved3;
    }

    public void setReserved3(int field_6_reserved3) {
        this.field_6_reserved3 = field_6_reserved3;
    }

    public void setLocked(boolean value) {
        this.field_3_option = this.locked.setShortBoolean(this.field_3_option, value);
    }

    public boolean isLocked() {
        return this.locked.isSet(this.field_3_option);
    }

    public void setPrintable(boolean value) {
        this.field_3_option = this.printable.setShortBoolean(this.field_3_option, value);
    }

    public boolean isPrintable() {
        return this.printable.isSet(this.field_3_option);
    }

    public void setAutofill(boolean value) {
        this.field_3_option = this.autofill.setShortBoolean(this.field_3_option, value);
    }

    public boolean isAutofill() {
        return this.autofill.isSet(this.field_3_option);
    }

    public void setAutoline(boolean value) {
        this.field_3_option = this.autoline.setShortBoolean(this.field_3_option, value);
    }

    public boolean isAutoline() {
        return this.autoline.isSet(this.field_3_option);
    }
}

