/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.cf.CellRange;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class CFHeaderRecord
extends Record {
    public static final short sid = 432;
    private static final CellRange[] EMPTY_CELL_RANGE_ARRAY = new CellRange[0];
    private int field_1_numcf;
    private int field_2_need_recalculation;
    private CellRange field_3_enclosing_cell_range;
    private CellRange[] field_4_cell_ranges;

    public CFHeaderRecord() {
        this.field_4_cell_ranges = EMPTY_CELL_RANGE_ARRAY;
    }

    public CFHeaderRecord(Region[] regions) {
        CellRange[] unmergedRanges = CellRange.convertRegionsToCellRanges(regions);
        CellRange[] mergeCellRanges = CellRange.mergeCellRanges(unmergedRanges);
        this.setCellRanges(mergeCellRanges);
    }

    public CFHeaderRecord(RecordInputStream in) {
        super(in);
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_numcf = in.readShort();
        this.field_2_need_recalculation = in.readShort();
        this.field_3_enclosing_cell_range = new CellRange(in.readUShort(), in.readUShort(), in.readUShort(), in.readUShort());
        int numCellRanges = in.readShort();
        CellRange[] crs = new CellRange[numCellRanges];
        for (int i = 0; i < numCellRanges; ++i) {
            crs[i] = new CellRange(in.readUShort(), in.readUShort(), in.readUShort(), in.readUShort());
        }
        this.field_4_cell_ranges = crs;
    }

    public int getNumberOfConditionalFormats() {
        return this.field_1_numcf;
    }

    public void setNumberOfConditionalFormats(int n) {
        this.field_1_numcf = n;
    }

    public boolean getNeedRecalculation() {
        return this.field_2_need_recalculation == 1;
    }

    public void setNeedRecalculation(boolean b) {
        this.field_2_need_recalculation = b ? 1 : 0;
    }

    public CellRange getEnclosingCellRange() {
        return this.field_3_enclosing_cell_range;
    }

    public void setEnclosingCellRange(CellRange cr) {
        this.field_3_enclosing_cell_range = cr.cloneCellRange();
    }

    public void setCellRanges(CellRange[] cellRanges) {
        if (cellRanges == null) {
            throw new IllegalArgumentException("cellRanges must not be null");
        }
        this.field_4_cell_ranges = (CellRange[])cellRanges.clone();
        CellRange enclosingRange = null;
        for (int i = 0; i < cellRanges.length; ++i) {
            enclosingRange = cellRanges[i].createEnclosingCellRange(enclosingRange);
        }
        this.field_3_enclosing_cell_range = enclosingRange;
    }

    public CellRange[] getCellRanges() {
        return (CellRange[])this.field_4_cell_ranges.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CFHEADER]\n");
        buffer.append("\t.id\t\t= ").append(Integer.toHexString(432)).append("\n");
        buffer.append("\t.numCF\t\t\t= ").append(this.getNumberOfConditionalFormats()).append("\n");
        buffer.append("\t.needRecalc\t   = ").append(this.getNeedRecalculation()).append("\n");
        buffer.append("\t.enclosingCellRange= ").append(this.getEnclosingCellRange()).append("\n");
        if (this.field_4_cell_ranges.length > 0) {
            buffer.append("\t.cfranges=[");
            for (int i = 0; i < this.field_4_cell_ranges.length; ++i) {
                buffer.append(i == 0 ? "" : ",").append(this.field_4_cell_ranges[i].toString());
            }
            buffer.append("]\n");
        }
        buffer.append("[/CFHEADER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int recordsize = this.getRecordSize();
        LittleEndian.putShort(data, 0 + offset, (short)432);
        LittleEndian.putShort(data, 2 + offset, (short)(recordsize - 4));
        LittleEndian.putShort(data, 4 + offset, (short)this.field_1_numcf);
        LittleEndian.putShort(data, 6 + offset, (short)this.field_2_need_recalculation);
        LittleEndian.putShort(data, 8 + offset, (short)this.field_3_enclosing_cell_range.getFirstRow());
        LittleEndian.putShort(data, 10 + offset, (short)this.field_3_enclosing_cell_range.getLastRow());
        LittleEndian.putShort(data, 12 + offset, (short)this.field_3_enclosing_cell_range.getFirstColumn());
        LittleEndian.putShort(data, 14 + offset, (short)this.field_3_enclosing_cell_range.getLastColumn());
        LittleEndian.putShort(data, 16 + offset, (short)this.field_4_cell_ranges.length);
        for (int i = 0; i != this.field_4_cell_ranges.length; ++i) {
            CellRange cr = this.field_4_cell_ranges[i];
            LittleEndian.putShort(data, 18 + 8 * i + offset, (short)cr.getFirstRow());
            LittleEndian.putShort(data, 20 + 8 * i + offset, (short)cr.getLastRow());
            LittleEndian.putShort(data, 22 + 8 * i + offset, (short)cr.getFirstColumn());
            LittleEndian.putShort(data, 24 + 8 * i + offset, (short)cr.getLastColumn());
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 18 + 8 * this.field_4_cell_ranges.length;
    }

    protected void validateSid(short id) {
        if (id != 432) {
            throw new RecordFormatException("NOT A ConditionalFormattingHeaderRecord RECORD");
        }
    }

    public short getSid() {
        return 432;
    }

    public Object clone() {
        CFHeaderRecord result = new CFHeaderRecord();
        result.field_1_numcf = this.field_1_numcf;
        result.field_2_need_recalculation = this.field_2_need_recalculation;
        result.field_3_enclosing_cell_range = this.field_3_enclosing_cell_range;
        CellRange[] crs = new CellRange[this.field_4_cell_ranges.length];
        for (int i = 0; i < crs.length; ++i) {
            crs[i] = this.field_4_cell_ranges[i].cloneCellRange();
        }
        result.field_4_cell_ranges = crs;
        return result;
    }
}

