/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFListener;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFUserException;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HSSFRequest {
    private HashMap records = new HashMap(50);

    public void addListener(HSSFListener lsnr, short sid) {
        ArrayList<HSSFListener> list = null;
        Object obj = this.records.get(new Short(sid));
        if (obj != null) {
            list = (ArrayList<HSSFListener>)obj;
        } else {
            list = new ArrayList<HSSFListener>(1);
            list.add(lsnr);
            this.records.put(new Short(sid), list);
        }
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes = RecordFactory.getAllKnownRecordSIDs();
        for (int k = 0; k < rectypes.length; ++k) {
            this.addListener(lsnr, rectypes[k]);
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        Object obj = this.records.get(new Short(rec.getSid()));
        short userCode = 0;
        if (obj != null) {
            List listeners = (List)obj;
            for (int k = 0; k < listeners.size(); ++k) {
                HSSFListener listener;
                Object listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode == 0) continue;
                    break;
                }
                listener = (HSSFListener)listenObj;
                listener.processRecord(rec);
            }
        }
        return userCode;
    }
}

