/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.org.apache.poi.hpsf.HPSFRuntimeException;
import com.fr.third.org.apache.poi.hpsf.MarkUnsupportedException;
import com.fr.third.org.apache.poi.hpsf.MutablePropertySet;
import com.fr.third.org.apache.poi.hpsf.MutableSection;
import com.fr.third.org.apache.poi.hpsf.NoPropertySetStreamException;
import com.fr.third.org.apache.poi.hpsf.PropertySet;
import com.fr.third.org.apache.poi.hpsf.SummaryInformation;
import com.fr.third.org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import com.fr.third.org.apache.poi.hpsf.wellknown.SectionIDMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;

public class PropertySetFactory {
    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }
}

