/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.commons.dbcp.datasources;

import com.fr.third.org.apache.commons.dbcp.SQLNestedException;
import com.fr.third.org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import com.fr.third.org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import com.fr.third.org.apache.commons.dbcp.datasources.KeyedCPDSConnectionFactory;
import com.fr.third.org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import com.fr.third.org.apache.commons.dbcp.datasources.PooledConnectionManager;
import com.fr.third.org.apache.commons.dbcp.datasources.SharedPoolDataSourceFactory;
import com.fr.third.org.apache.commons.dbcp.datasources.UserPassKey;
import com.fr.third.org.apache.commons.pool.KeyedObjectPool;
import com.fr.third.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -8132305535403690372L;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private transient KeyedObjectPool pool = null;
    private transient KeyedCPDSConnectionFactory factory = null;

    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.assertInitializationAllowed();
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.maxIdle = maxIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.assertInitializationAllowed();
        this.maxWait = maxWait;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        SharedPoolDataSource sharedPoolDataSource = this;
        synchronized (sharedPoolDataSource) {
            if (this.pool == null) {
                try {
                    this.registerPool(username, password);
                }
                catch (NamingException e) {
                    throw new SQLNestedException("RegisterPool failed", e);
                }
            }
        }
        PooledConnectionAndInfo info = null;
        UserPassKey key = new UserPassKey(username, password);
        try {
            info = (PooledConnectionAndInfo)this.pool.borrowObject(key);
        }
        catch (Exception e) {
            throw new SQLNestedException("Could not retrieve connection info from pool", e);
        }
        return info;
    }

    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.factory;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }

    private void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        GenericKeyedObjectPool tmpPool = new GenericKeyedObjectPool(null);
        tmpPool.setMaxActive(this.getMaxActive());
        tmpPool.setMaxIdle(this.getMaxIdle());
        tmpPool.setMaxWait(this.getMaxWait());
        tmpPool.setWhenExhaustedAction(this.whenExhaustedAction(this.maxActive, this.maxWait));
        tmpPool.setTestOnBorrow(this.getTestOnBorrow());
        tmpPool.setTestOnReturn(this.getTestOnReturn());
        tmpPool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        tmpPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        tmpPool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        tmpPool.setTestWhileIdle(this.getTestWhileIdle());
        this.pool = tmpPool;
        this.factory = new KeyedCPDSConnectionFactory(cpds, this.pool, this.getValidationQuery(), this.isRollbackAfterValidation());
    }

    protected void setupDefaults(Connection con, String username) throws SQLException {
        int defaultTransactionIsolation;
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (con.getAutoCommit() != defaultAutoCommit) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if ((defaultTransactionIsolation = this.getDefaultTransactionIsolation()) != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (con.isReadOnly() != defaultReadOnly) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            SharedPoolDataSource oldDS = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = oldDS.pool;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }
}

