/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.recman;

import com.fr.third.jdbm.helper.Serialization;
import com.fr.third.jdbm.recman.BlockIo;
import com.fr.third.jdbm.recman.RecordFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public final class TransactionManager {
    private RecordFile owner;
    private FileOutputStream fos;
    private DataOutputStream oos;
    static final int DEFAULT_TXNS_IN_LOG = 1;
    private int _maxTxns = 1;
    private ArrayList<BlockIo>[] txns = new ArrayList[1];
    private int curTxn = -1;
    static final String extension = ".t";

    TransactionManager(RecordFile owner) throws IOException {
        this.owner = owner;
        this.recover();
        this.open();
    }

    public void synchronizeLog() throws IOException {
        this.synchronizeLogFromMemory();
    }

    public void setMaximumTransactionsInLog(int maxTxns) throws IOException {
        if (maxTxns <= 0) {
            throw new IllegalArgumentException("Argument 'maxTxns' must be greater than 0.");
        }
        if (this.curTxn != -1) {
            throw new IllegalStateException("Cannot change setting while transactions are pending in the log");
        }
        this._maxTxns = maxTxns;
        this.txns = new ArrayList[maxTxns];
    }

    private String makeLogName() {
        return String.valueOf(this.owner.getFileName()) + extension;
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        TreeSet<BlockIo> blockList = new TreeSet<BlockIo>(new BlockIoComparator());
        int numBlocks = 0;
        int writtenBlocks = 0;
        int i = 0;
        while (i < this._maxTxns) {
            if (this.txns[i] != null) {
                for (BlockIo block : this.txns[i]) {
                    if (blockList.contains(block)) {
                        block.decrementTransactionCount();
                    } else {
                        ++writtenBlocks;
                        boolean bl = blockList.add(block);
                    }
                    ++numBlocks;
                }
                this.txns[i] = null;
            }
            ++i;
        }
        this.synchronizeBlocks(blockList, true);
        this.owner.sync();
        this.open();
    }

    private void open() throws IOException {
        this.fos = new FileOutputStream(this.makeLogName());
        this.oos = new DataOutputStream(new BufferedOutputStream(this.fos));
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    private void recover() throws IOException {
        String logName = this.makeLogName();
        File logFile = new File(logName);
        if (!logFile.exists()) {
            return;
        }
        if (logFile.length() == 0L) {
            logFile.delete();
            return;
        }
        FileInputStream fis = new FileInputStream(logFile);
        DataInputStream ois = new DataInputStream(new BufferedInputStream(fis));
        try {
            if (ois.readShort() != 4960) {
                throw new Error("Bad magic on log file");
            }
        }
        catch (IOException e) {
            logFile.delete();
            return;
        }
        while (true) {
            ArrayList blocks = null;
            try {
                blocks = (ArrayList)Serialization.readObject(ois);
            }
            catch (ClassNotFoundException e) {
                throw new Error("Unexcepted exception: " + e);
            }
            catch (IOException e) {
                break;
            }
            this.synchronizeBlocks(blocks, false);
            ois = new DataInputStream(fis);
        }
        this.owner.sync();
        fis.close();
        logFile.delete();
    }

    private void synchronizeBlocks(Iterable<BlockIo> blocks, boolean fromCore) throws IOException {
        for (BlockIo cur : blocks) {
            this.owner.synch(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, true);
        }
    }

    private void setClean(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.setClean();
        }
    }

    private void discardBlocks(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, false);
        }
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == this._maxTxns) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txns[this.curTxn] = new ArrayList();
    }

    void add(BlockIo block) throws IOException {
        block.incrementTransactionCount();
        this.txns[this.curTxn].add(block);
    }

    void commit() throws IOException {
        Serialization.writeObject(this.oos, this.txns[this.curTxn]);
        this.sync();
        this.setClean(this.txns[this.curTxn]);
        this.oos = new DataOutputStream(new BufferedOutputStream(this.fos));
    }

    private void sync() throws IOException {
        this.oos.flush();
        this.fos.flush();
        this.fos.getFD().sync();
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        int i = 0;
        while (i < this._maxTxns) {
            if (this.txns[i] != null) {
                this.discardBlocks(this.txns[i]);
                this.txns[i] = null;
            }
            ++i;
        }
        this.recover();
        this.open();
    }

    public static class BlockIoComparator
    implements Comparator<BlockIo> {
        @Override
        public int compare(BlockIo block1, BlockIo block2) {
            if (block1.getBlockId() == block2.getBlockId()) {
                return 0;
            }
            if (block1.getBlockId() < block2.getBlockId()) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

