/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.recman;

import com.fr.third.jdbm.recman.BlockIo;
import com.fr.third.jdbm.recman.BlockView;
import com.fr.third.jdbm.recman.Location;
import com.fr.third.jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    static final short FreePhysicalRowId_O_SIZE = 8;
    static final short FreePhysicalRowId_SIZE = 12;
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    final short ELEMS_PER_PAGE;
    public static final transient int wasteMargin = 128;
    public static final transient int wasteMargin2 = 4;
    final int[] sizeCache;

    FreePhysicalRowIdPage(BlockIo block, int blockSize) {
        super(block);
        this.ELEMS_PER_PAGE = (short)((blockSize - 20) / 12);
        this.sizeCache = new int[this.ELEMS_PER_PAGE];
        int i = 0;
        while (i < this.ELEMS_PER_PAGE) {
            this.sizeCache[i] = -1;
            ++i;
        }
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo block, int pageSize) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)view;
        }
        return new FreePhysicalRowIdPage(block, pageSize);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    void free(int slot) {
        short pos = this.slotToOffset(slot);
        this.FreePhysicalRowId_setSize(pos, 0);
        this.setCount((short)(this.getCount() - 1));
    }

    short alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        return this.slotToOffset(slot);
    }

    boolean isAllocated(int slot) {
        short pos = this.slotToOffset(slot);
        return this.FreePhysicalRowId_getSize(pos) != 0;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 12);
    }

    int offsetToSlot(short pos) {
        short pos2 = pos;
        return (pos2 - 20) / 12;
    }

    int getFirstFree() {
        int i = 0;
        while (i < this.ELEMS_PER_PAGE) {
            if (this.isFree(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getFirstLargerThan(int requestedSize) {
        int maxSize = 0;
        int bestSlot = -1;
        int bestSlotWaste = 0;
        int i = 0;
        while (i < this.ELEMS_PER_PAGE) {
            int waste;
            short pos = this.slotToOffset(i);
            int currentRecSize = this.FreePhysicalRowId_getSize(pos);
            if (currentRecSize > maxSize) {
                maxSize = currentRecSize;
            }
            if ((waste = currentRecSize - requestedSize) >= 0) {
                if (waste < 128) {
                    return i;
                }
                if (bestSlotWaste >= waste) {
                    bestSlot = i;
                    bestSlotWaste = waste;
                }
            }
            ++i;
        }
        if (bestSlot != -1 && bestSlotWaste < 4) {
            return bestSlot;
        }
        return -maxSize;
    }

    public long slotToLocation(int slot) {
        short pos = this.slotToOffset(slot);
        return Location.toLong(this.getLocationBlock(pos), this.getLocationOffset(pos));
    }

    int FreePhysicalRowId_getSize(short pos) {
        int slot = this.offsetToSlot(pos);
        if (this.sizeCache[slot] == -1) {
            this.sizeCache[slot] = this.block.readInt(pos + 8);
        }
        return this.sizeCache[slot];
    }

    void FreePhysicalRowId_setSize(short pos, int value) {
        int slot = this.offsetToSlot(pos);
        this.sizeCache[slot] = value;
        this.block.writeInt(pos + 8, value);
    }
}

