/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.recman;

import com.fr.third.jdbm.recman.BlockIo;
import com.fr.third.jdbm.recman.BlockView;
import com.fr.third.jdbm.recman.Location;
import com.fr.third.jdbm.recman.PageHeader;

final class FreeLogicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    final short ELEMS_PER_PAGE;
    private int previousFoundFree = 0;
    private int previousFoundAllocated = 0;

    FreeLogicalRowIdPage(BlockIo block, int blockSize) {
        super(block);
        this.ELEMS_PER_PAGE = (short)((blockSize - 20) / 8);
    }

    static FreeLogicalRowIdPage getFreeLogicalRowIdPageView(BlockIo block, int blockSize) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreeLogicalRowIdPage) {
            return (FreeLogicalRowIdPage)view;
        }
        return new FreeLogicalRowIdPage(block, blockSize);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    void free(int slot) {
        this.setLocationBlock(this.slotToOffset(slot), 0L);
        this.setCount((short)(this.getCount() - 1));
        if (slot < this.previousFoundFree) {
            this.previousFoundFree = slot;
        }
    }

    short alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        short pos = this.slotToOffset(slot);
        this.setLocationBlock(pos, -1L);
        if (slot < this.previousFoundAllocated) {
            this.previousFoundAllocated = slot;
        }
        return pos;
    }

    boolean isAllocated(int slot) {
        return this.getLocationBlock(this.slotToOffset(slot)) > 0L;
    }

    boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 8);
    }

    int getFirstFree() {
        while (this.previousFoundFree < this.ELEMS_PER_PAGE) {
            if (this.isFree(this.previousFoundFree)) {
                return this.previousFoundFree;
            }
            ++this.previousFoundFree;
        }
        return -1;
    }

    int getFirstAllocated() {
        while (this.previousFoundAllocated < this.ELEMS_PER_PAGE) {
            if (this.isAllocated(this.previousFoundAllocated)) {
                return this.previousFoundAllocated;
            }
            ++this.previousFoundAllocated;
        }
        return -1;
    }

    public long slotToLocation(int slot) {
        short pos = this.slotToOffset(slot);
        return Location.toLong(this.getLocationBlock(pos), this.getLocationOffset(pos));
    }
}

