/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.htree;

import com.fr.third.jdbm.RecordManager;
import com.fr.third.jdbm.helper.LongPacker;
import com.fr.third.jdbm.htree.HTree;
import com.fr.third.jdbm.htree.HashBucket;
import com.fr.third.jdbm.htree.HashNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class HashDirectory<K, V>
extends HashNode<K, V> {
    static final long serialVersionUID = 1L;
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[] _children;
    private byte _depth;
    private transient RecordManager _recman;
    private transient long _recid;

    public HashDirectory(HTree<K, V> tree) {
        super(tree);
    }

    HashDirectory(HTree<K, V> tree, byte depth) {
        super(tree);
        this._depth = depth;
        this._children = new long[256];
    }

    void setPersistenceContext(RecordManager recman, long recid) {
        this._recman = recman;
        this._recid = recid;
    }

    long getRecid() {
        return this._recid;
    }

    boolean isEmpty() {
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    V get(K key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.get(key);
        }
        HashBucket bucket = (HashBucket)node;
        return bucket.getValue(key);
    }

    Object put(Object key, Object value) throws IOException {
        if (value == null) {
            return this.remove(key);
        }
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            long b_recid;
            HashBucket<Object, Object> bucket = new HashBucket<Object, Object>(this.tree, this._depth + 1);
            Object existing = bucket.addElement(key, value);
            this._children[hash] = b_recid = this._recman.insert(bucket, this.tree.SERIALIZER);
            this._recman.update(this._recid, this, this.tree.SERIALIZER);
            return existing;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.put(key, value);
        }
        HashBucket bucket = (HashBucket)node;
        if (bucket.hasRoom()) {
            Object existing = bucket.addElement(key, value);
            this._recman.update(child_recid, bucket, this.tree.SERIALIZER);
            return existing;
        }
        if (this._depth == 3) {
            throw new RuntimeException("Cannot create deeper directory. Depth=" + this._depth);
        }
        HashDirectory<K, V> dir = new HashDirectory<K, V>(this.tree, (byte)(this._depth + 1));
        long dir_recid = this._recman.insert(dir, this.tree.SERIALIZER);
        dir.setPersistenceContext(this._recman, dir_recid);
        this._children[hash] = dir_recid;
        this._recman.update(this._recid, this, this.tree.SERIALIZER);
        this._recman.delete(child_recid);
        ArrayList keys = bucket.getKeys();
        ArrayList values = bucket.getValues();
        int entries = keys.size();
        int i = 0;
        while (i < entries) {
            dir.put(keys.get(i), values.get(i));
            ++i;
        }
        return dir.put(key, value);
    }

    Object remove(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid, this.tree.SERIALIZER);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            Object existing = dir.remove(key);
            if (existing != null && dir.isEmpty()) {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this, this.tree.SERIALIZER);
            }
            return existing;
        }
        HashBucket bucket = (HashBucket)node;
        Object existing = bucket.removeElement(key);
        if (existing != null) {
            if (bucket.getElementCount() >= 1) {
                this._recman.update(child_recid, bucket, this.tree.SERIALIZER);
            } else {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this, this.tree.SERIALIZER);
            }
        }
        return existing;
    }

    private int hashCode(Object key) {
        int hashMask = this.hashMask();
        int hash = key.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this._depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this._depth) * 8;
        return hashMask;
    }

    Iterator<K> keys() throws IOException {
        return new HDIterator(true);
    }

    Iterator<V> values() throws IOException {
        return new HDIterator(false);
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeByte(this._depth);
        int zeroStart = 0;
        int i = 0;
        while (i < 256) {
            if (this._children[i] != 0L) {
                zeroStart = i;
                break;
            }
            ++i;
        }
        out.write(zeroStart);
        if (zeroStart == 256) {
            return;
        }
        int zeroEnd = 0;
        int i2 = 255;
        while (i2 >= 0) {
            if (this._children[i2] != 0L) {
                zeroEnd = i2;
                break;
            }
            --i2;
        }
        out.write(zeroEnd);
        i2 = zeroStart;
        while (i2 <= zeroEnd) {
            LongPacker.packLong(out, this._children[i2]);
            ++i2;
        }
    }

    public synchronized void readExternal(DataInputStream in) throws IOException, ClassNotFoundException {
        this._depth = in.readByte();
        this._children = new long[256];
        int zeroStart = in.read();
        int zeroEnd = in.read();
        int i = zeroStart;
        while (i <= zeroEnd) {
            this._children[i] = LongPacker.unpackLong(in);
            ++i;
        }
    }

    public RecordManager getRecordManager() {
        return this._recman;
    }

    public class HDIterator<A>
    implements Iterator<A> {
        private boolean _iterateKeys;
        private ArrayList _dirStack = new ArrayList();
        private ArrayList _childStack = new ArrayList();
        private HashDirectory _dir;
        private int _child;
        private Iterator<A> _iter;
        A next;

        HDIterator(boolean iterateKeys) throws IOException {
            this._dir = HashDirectory.this;
            this._child = -1;
            this._iterateKeys = iterateKeys;
            this.prepareNext();
            this.next = this.next2();
        }

        public A next2() {
            A next = null;
            if (this._iter != null && this._iter.hasNext()) {
                next = this._iter.next();
            } else {
                try {
                    this.prepareNext();
                }
                catch (IOException except) {
                    throw new IOError(except);
                }
                if (this._iter != null && this._iter.hasNext()) {
                    return this.next2();
                }
            }
            return next;
        }

        private void prepareNext() throws IOException {
            long child_recid = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HashDirectory)this._dirStack.remove(this._dirStack.size() - 1);
                    this._child = (Integer)this._childStack.remove(this._childStack.size() - 1);
                    continue;
                }
                child_recid = this._dir._children[this._child];
            } while (child_recid == 0L);
            if (child_recid == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            HashNode node = (HashNode)HashDirectory.this._recman.fetch(child_recid, HashDirectory.this.tree.SERIALIZER);
            if (node instanceof HashDirectory) {
                this._dirStack.add(this._dir);
                this._childStack.add(new Integer(this._child));
                this._dir = (HashDirectory)node;
                this._child = -1;
                this._dir.setPersistenceContext(HashDirectory.this._recman, child_recid);
                this.prepareNext();
            } else {
                HashBucket bucket = (HashBucket)node;
                if (this._iterateKeys) {
                    ArrayList keys2 = (ArrayList)bucket.getKeys().clone();
                    this._iter = keys2.iterator();
                } else {
                    this._iter = bucket.getValues().iterator();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public A next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            A ret = this.next;
            this.next = this.next2();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

