/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.helper;

import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongHashMap<V>
implements Serializable {
    private static final long serialVersionUID = 362499999763181265L;
    protected int elementCount;
    protected Entry<V>[] elementData;
    private final float loadFactor;
    protected int threshold;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;
    transient Entry<V> reuseAfterDelete = null;

    Entry<V>[] newElementArray(int s) {
        return new Entry[s];
    }

    public LongHashMap() {
        this(16);
    }

    public LongHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public LongHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public boolean containsKey(long key) {
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> m = this.findNonNullKeyEntry(key, index, hash);
        return m != null;
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<V> entry = this.elementData[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<V> entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public V get(long key) {
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> m = this.findNonNullKeyEntry(key, index, hash);
        if (m != null) {
            return m.value;
        }
        return null;
    }

    final Entry<V> findNonNullKeyEntry(long key, int index, int keyHash) {
        Entry<V> m = this.elementData[index];
        while (m != null) {
            if (key == m.key) {
                return m;
            }
            m = m.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public V put(long key, V value) {
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> entry = this.findNonNullKeyEntry(key, index, hash);
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = this.createHashedEntry(key, index);
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    Entry<V> createEntry(long key, int index, V value) {
        Entry<V> entry = this.reuseAfterDelete;
        if (entry == null) {
            entry = new Entry<V>(key, value);
        } else {
            this.reuseAfterDelete = null;
            entry.key = key;
            entry.value = value;
        }
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    Entry<V> createHashedEntry(long key, int index) {
        Entry<V> entry = this.reuseAfterDelete;
        if (entry == null) {
            entry = new Entry(key);
        } else {
            this.reuseAfterDelete = null;
            entry.key = key;
            entry.value = null;
        }
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    void rehash(int capacity) {
        int length = capacity == 0 ? 1 : capacity << 1;
        Entry<V>[] newData = this.newElementArray(length);
        int i = 0;
        while (i < this.elementData.length) {
            Entry<V> entry = this.elementData[i];
            while (entry != null) {
                int index = ((int)entry.key & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
            ++i;
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    public V remove(long key) {
        Entry<V> entry = this.removeEntry(key);
        if (entry == null) {
            return null;
        }
        Object ret = entry.value;
        entry.value = null;
        entry.key = Long.MIN_VALUE;
        this.reuseAfterDelete = entry;
        return ret;
    }

    Entry<V> removeEntry(long key) {
        int index = 0;
        Entry<V> last = null;
        int hash = (int)key;
        index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> entry = this.elementData[index];
        while (entry != null && key != entry.key) {
            last = entry;
            entry = entry.next;
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    public int size() {
        return this.elementCount;
    }

    public Iterator<V> valuesIterator() {
        return new HashMapIterator(new EntryType<V, V>(){

            @Override
            public V get(Entry<V> entry) {
                return entry.value;
            }
        }, this);
    }

    static final class Entry<V> {
        Entry<V> next;
        long key;
        V value;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return this.key == entry.key && (this.value == null ? entry.value == null : this.value.equals(entry.value));
            }
            return false;
        }

        public int hashCode() {
            return (int)this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }

        Entry(long theKey) {
            this.key = theKey;
            this.value = null;
        }

        Entry(long theKey, V theValue) {
            this.key = theKey;
            this.value = theValue;
        }
    }

    static interface EntryType<RT, VT> {
        public RT get(Entry<VT> var1);
    }

    static class HashMapIterator<E, VT>
    implements Iterator<E> {
        private int position = 0;
        int expectedModCount;
        final EntryType<E, VT> type;
        boolean canRemove = false;
        Entry<VT> entry;
        Entry<VT> lastEntry;
        final LongHashMap<VT> associatedMap;

        HashMapIterator(EntryType<E, VT> value, LongHashMap<VT> hm) {
            this.associatedMap = hm;
            this.type = value;
            this.expectedModCount = hm.modCount;
        }

        @Override
        public boolean hasNext() {
            int newPosition;
            if (this.entry != null) {
                return true;
            }
            Entry<V>[] elementData = this.associatedMap.elementData;
            int length = elementData.length;
            boolean result = false;
            for (newPosition = this.position; newPosition < length; ++newPosition) {
                if (elementData[newPosition] == null) {
                    continue;
                }
                result = true;
                break;
            }
            this.position = newPosition;
            return result;
        }

        void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public E next() {
            Entry<Object> result;
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<VT> _entry = this.entry;
            if (_entry == null) {
                this.lastEntry = this.associatedMap.elementData[this.position++];
                result = this.lastEntry;
                this.entry = this.lastEntry.next;
            } else {
                if (this.lastEntry.next != _entry) {
                    this.lastEntry = this.lastEntry.next;
                }
                result = _entry;
                this.entry = _entry.next;
            }
            this.canRemove = true;
            return this.type.get(result);
        }

        @Override
        public void remove() {
            this.checkConcurrentMod();
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            ++this.associatedMap.modCount;
            if (this.lastEntry.next == this.entry) {
                while (this.associatedMap.elementData[--this.position] == null) {
                }
                this.associatedMap.elementData[this.position] = this.associatedMap.elementData[this.position].next;
                this.entry = null;
            } else {
                this.lastEntry.next = this.entry;
            }
            if (this.lastEntry != null) {
                Entry<VT> reuse = this.lastEntry;
                this.lastEntry = null;
                reuse.key = Long.MIN_VALUE;
                reuse.value = null;
                this.associatedMap.reuseAfterDelete = reuse;
            }
            --this.associatedMap.elementCount;
            ++this.expectedModCount;
        }
    }
}

