/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.helper;

import java.io.Serializable;
import java.util.Comparator;

public final class ByteArrayComparator
implements Comparator<byte[]>,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public int compare(byte[] obj1, byte[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException("Argument 'obj1' is null");
        }
        if (obj2 == null) {
            throw new IllegalArgumentException("Argument 'obj2' is null");
        }
        return ByteArrayComparator.compareByteArray(obj1, obj2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compareByteArray(byte[] thisKey, byte[] otherKey) {
        int len = Math.min(thisKey.length, otherKey.length);
        int i = 0;
        while (i < len) {
            if (thisKey[i] >= 0) {
                if (otherKey[i] < 0) return -1;
                if (thisKey[i] < otherKey[i]) {
                    return -1;
                }
                if (thisKey[i] > otherKey[i]) {
                    return 1;
                }
            } else {
                if (otherKey[i] >= 0) {
                    return 1;
                }
                if (thisKey[i] < otherKey[i]) {
                    return -1;
                }
                if (thisKey[i] > otherKey[i]) {
                    return 1;
                }
            }
            ++i;
        }
        if (thisKey.length == otherKey.length) {
            return 0;
        }
        if (thisKey.length >= otherKey.length) return 1;
        return -1;
    }
}

