/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.jdbm.btree;

import com.fr.third.jdbm.PrimaryTreeMap;
import com.fr.third.jdbm.RecordListener;
import com.fr.third.jdbm.RecordManager;
import com.fr.third.jdbm.btree.BTree;
import com.fr.third.jdbm.helper.AbstractPrimaryMap;
import com.fr.third.jdbm.helper.Tuple;
import com.fr.third.jdbm.helper.TupleBrowser;
import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class BTreeSortedMap<K, V>
extends AbstractPrimaryMap<K, V>
implements PrimaryTreeMap<K, V> {
    protected final BTree<K, V> tree;
    protected final K fromKey;
    protected final K toKey;
    protected final boolean readonly;

    public BTreeSortedMap(BTree<K, V> tree, boolean readonly) {
        this(tree, readonly, null, null);
    }

    protected BTreeSortedMap(BTree<K, V> tree, boolean readonly, K fromKey, K toKey) {
        this.tree = tree;
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.readonly = readonly;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            protected Map.Entry<K, V> newEntry(K k, V v) {
                return new AbstractMap.SimpleEntry<K, V>(k, v){
                    private static final long serialVersionUID = 978651696969194154L;

                    @Override
                    public V setValue(V arg0) {
                        BTreeSortedMap.this.put(this.getKey(), arg0);
                        return super.setValue(arg0);
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                if (BTreeSortedMap.this.readonly) {
                    throw new UnsupportedOperationException("readonly");
                }
                try {
                    if (e.getKey() == null) {
                        throw new NullPointerException("Can not add null key");
                    }
                    if (!BTreeSortedMap.this.inBounds(e.getKey())) {
                        throw new IllegalArgumentException("key outside of bounds");
                    }
                    return BTreeSortedMap.this.tree.insert(e.getKey(), e.getValue(), true) == null;
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e;
                    block5: {
                        e = (Map.Entry)o;
                        try {
                            if (BTreeSortedMap.this.inBounds(e.getKey())) break block5;
                            return false;
                        }
                        catch (IOException e1) {
                            throw new IOError(e1);
                        }
                    }
                    if (e.getKey() != null && BTreeSortedMap.this.tree.find(e.getKey()) != null) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                try {
                    final TupleBrowser br = BTreeSortedMap.this.fromKey == null ? BTreeSortedMap.this.tree.browse() : BTreeSortedMap.this.tree.browse(BTreeSortedMap.this.fromKey);
                    return new Iterator<Map.Entry<K, V>>(){
                        private Map.Entry<K, V> next;
                        private K lastKey;
                        {
                            this.ensureNext();
                        }

                        void ensureNext() {
                            try {
                                Tuple t = new Tuple();
                                this.next = br.getNext(t) && BTreeSortedMap.this.inBounds(t.getKey()) ? this.newEntry(t.getKey(), t.getValue()) : null;
                            }
                            catch (IOException e1) {
                                throw new IOError(e1);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.next == null) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry ret = this.next;
                            this.lastKey = ret.getKey();
                            this.ensureNext();
                            return ret;
                        }

                        @Override
                        public void remove() {
                            if ((this).BTreeSortedMap.this.readonly) {
                                throw new UnsupportedOperationException("readonly");
                            }
                            if (this.lastKey == null) {
                                throw new IllegalStateException();
                            }
                            BTreeSortedMap.this.remove(this.lastKey);
                            this.lastKey = null;
                        }
                    };
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }

            @Override
            public boolean remove(Object o) {
                if (BTreeSortedMap.this.readonly) {
                    throw new UnsupportedOperationException("readonly");
                }
                if (o instanceof Map.Entry) {
                    Map.Entry e;
                    block8: {
                        block7: {
                            e = (Map.Entry)o;
                            try {
                                if (e.getKey() != null && e.getValue() != null) break block7;
                                return false;
                            }
                            catch (IOException e1) {
                                throw new IOError(e1);
                            }
                        }
                        if (!BTreeSortedMap.this.inBounds(e.getKey())) {
                            throw new IllegalArgumentException("out of bounds");
                        }
                        Object v = BTreeSortedMap.this.get(e.getKey());
                        if (v != null && e.getValue().equals(v)) break block8;
                        return false;
                    }
                    Object v2 = BTreeSortedMap.this.tree.remove(e.getKey());
                    return v2 != null;
                }
                return false;
            }

            @Override
            public int size() {
                if (BTreeSortedMap.this.fromKey == null && BTreeSortedMap.this.toKey == null) {
                    return BTreeSortedMap.this.tree.size();
                }
                int counter = 0;
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    i.next();
                    ++counter;
                }
                return counter;
            }
        };
    }

    public boolean inBounds(K e) {
        if (this.fromKey != null && this.comparator().compare(e, this.fromKey) < 0) {
            return false;
        }
        return this.toKey == null || this.comparator().compare(e, this.toKey) < 0;
    }

    @Override
    public V get(Object key) {
        block6: {
            block5: {
                if (key != null) break block5;
                return null;
            }
            if (this.inBounds(key)) break block6;
            return null;
        }
        try {
            return this.tree.find(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V remove(Object key) {
        block6: {
            if (this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            if (key != null && this.tree.find(key) != null) break block6;
            return null;
        }
        try {
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.remove(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || value == null) {
                throw new NullPointerException("Null key or value");
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.insert(key, value, true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        block5: {
            if (key == null) {
                return false;
            }
            if (this.inBounds(key)) break block5;
            return false;
        }
        try {
            V v = this.tree.find(key);
            return v != null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.tree._comparator;
    }

    @Override
    public K firstKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        try {
            TupleBrowser b = this.fromKey == null ? this.tree.browse() : this.tree.browse(this.fromKey);
            Tuple t = new Tuple();
            b.getNext(t);
            return t.getKey();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public K lastKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        try {
            TupleBrowser b = this.toKey == null ? this.tree.browse(null) : this.tree.browse(this.toKey);
            Tuple t = new Tuple();
            b.getPrevious(t);
            return t.getKey();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new BTreeSortedMap<Object, V>(this.tree, this.readonly, null, toKey);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        if (this.comparator().compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException("fromKey is bigger then toKey");
        }
        return new BTreeSortedMap<K, V>(this.tree, this.readonly, fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new BTreeSortedMap<Object, V>(this.tree, this.readonly, fromKey, null);
    }

    public BTree<K, V> getTree() {
        return this.tree;
    }

    @Override
    public void addRecordListener(RecordListener<K, V> listener) {
        this.tree.addRecordListener(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this.tree.getRecordManager();
    }

    @Override
    public void removeRecordListener(RecordListener<K, V> listener) {
        this.tree.removeRecordListener(listener);
    }

    @Override
    public Integer newIntegerKey() {
        if (this.isEmpty()) {
            return new Integer(0);
        }
        K k = this.lastKey();
        return new Integer((Integer)k + 1);
    }

    @Override
    public Long newLongKey() {
        if (this.isEmpty()) {
            return new Long(0L);
        }
        K k = this.lastKey();
        return new Long((Long)k + 1L);
    }

    @Override
    public void clear() {
        Iterator keyIter = this.keySet().iterator();
        while (keyIter.hasNext()) {
            this.remove(keyIter.next());
        }
    }
}

