/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.events;

import com.fr.third.javax.xml.namespace.NamespaceContext;
import com.fr.third.javax.xml.namespace.QName;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.events.Attribute;
import com.fr.third.javax.xml.stream.events.DummyEvent;
import com.fr.third.javax.xml.stream.events.Namespace;
import com.fr.third.javax.xml.stream.events.StartElement;
import com.fr.third.javax.xml.stream.util.ReadOnlyIterator;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StartElementEvent
extends DummyEvent
implements StartElement {
    private Map fAttributes;
    private List fNamespaces;
    private NamespaceContext fNamespaceContext = null;
    private QName fQName;

    public StartElementEvent(String prefix, String uri, String localpart) {
        this(new QName(uri, localpart, prefix));
    }

    public StartElementEvent(QName qname) {
        this.fQName = qname;
        this.init();
    }

    public StartElementEvent(StartElement startelement) {
        this(startelement.getName());
        this.addAttributes(startelement.getAttributes());
        this.addNamespaceAttributes(startelement.getNamespaces());
    }

    protected void init() {
        this.setEventType(1);
        this.fAttributes = new HashMap();
        this.fNamespaces = new ArrayList();
    }

    public QName getName() {
        return this.fQName;
    }

    public void setName(QName qname) {
        this.fQName = qname;
    }

    public Iterator getAttributes() {
        if (this.fAttributes != null) {
            Collection coll = this.fAttributes.values();
            return new ReadOnlyIterator(coll.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Iterator getNamespaces() {
        if (this.fNamespaces != null) {
            return new ReadOnlyIterator(this.fNamespaces.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Attribute getAttributeByName(QName qname) {
        if (qname == null) {
            return null;
        }
        return (Attribute)this.fAttributes.get(qname);
    }

    public String getNamespace() {
        return this.fQName.getNamespaceURI();
    }

    public String getNamespaceURI(String prefix) {
        if (this.getNamespace() != null && this.fQName.getPrefix().equals(prefix)) {
            return this.getNamespace();
        }
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getNamespaceURI(prefix);
        }
        return null;
    }

    public String toString() {
        Attribute attr;
        Iterator it;
        String s = "<" + this.nameAsString();
        if (this.fAttributes != null) {
            it = this.getAttributes();
            attr = null;
            while (it.hasNext()) {
                attr = (Attribute)it.next();
                s = String.valueOf(s) + " " + attr.toString();
            }
        }
        if (this.fNamespaces != null) {
            it = this.fNamespaces.iterator();
            attr = null;
            while (it.hasNext()) {
                attr = (Namespace)it.next();
                s = String.valueOf(s) + " " + attr.toString();
            }
        }
        s = String.valueOf(s) + ">";
        return s;
    }

    public String nameAsString() {
        if ("".equals(this.fQName.getNamespaceURI())) {
            return this.fQName.getLocalPart();
        }
        if (this.fQName.getPrefix() != null) {
            return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getPrefix() + ":" + this.fQName.getLocalPart();
        }
        return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getLocalPart();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext nc) {
        this.fNamespaceContext = nc;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
    }

    void addAttribute(Attribute attr) {
        if (attr.isNamespace()) {
            this.fNamespaces.add(attr);
        } else {
            this.fAttributes.put(attr.getName(), attr);
        }
    }

    /*
     * Unable to fully structure code
     */
    void addAttributes(Iterator attrs) {
        if (attrs != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            attr = (Attribute)attrs.next();
            this.fAttributes.put(attr.getName(), attr);
lbl6:
            // 2 sources

            ** while (attrs.hasNext())
        }
lbl7:
        // 1 sources

    }

    void addNamespaceAttribute(Namespace attr) {
        if (attr == null) {
            return;
        }
        this.fNamespaces.add(attr);
    }

    /*
     * Unable to fully structure code
     */
    void addNamespaceAttributes(Iterator attrs) {
        if (attrs != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            attr = (Namespace)attrs.next();
            this.fNamespaces.add(attr);
lbl6:
            // 2 sources

            ** while (attrs.hasNext())
        }
lbl7:
        // 1 sources

    }
}

