/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.events;

import com.fr.third.javax.xml.stream.Location;
import com.fr.third.javax.xml.stream.events.DummyEvent;
import com.fr.third.javax.xml.stream.events.StartDocument;

public class StartDocumentEvent
extends DummyEvent
implements StartDocument {
    protected String fSystemId;
    protected String fEncodingScheam;
    protected boolean fStandalone;
    protected String fVersion;
    private boolean fEncodingSchemeSet;
    private boolean fStandaloneSet;

    public StartDocumentEvent() {
        this("UTF-8", "1.0", true, null);
    }

    public StartDocumentEvent(String encoding) {
        this(encoding, "1.0", true, null);
    }

    public StartDocumentEvent(String encoding, String version) {
        this(encoding, version, true, null);
    }

    public StartDocumentEvent(String encoding, String version, boolean standalone) {
        this(encoding, version, standalone, null);
    }

    public StartDocumentEvent(String encoding, String version, boolean standalone, Location loc) {
        this.init();
        this.fEncodingScheam = encoding;
        this.fVersion = version;
        this.fStandalone = standalone;
        this.fEncodingSchemeSet = false;
        this.fStandaloneSet = false;
        this.fLocation = loc;
    }

    protected void init() {
        this.setEventType(7);
    }

    public String getSystemId() {
        if (this.fLocation == null) {
            return "";
        }
        return this.fLocation.getSystemId();
    }

    public String getCharacterEncodingScheme() {
        return this.fEncodingScheam;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setStandalone(boolean flag) {
        this.fStandaloneSet = true;
        this.fStandalone = flag;
    }

    public void setStandalone(String s) {
        this.fStandaloneSet = true;
        if (s == null) {
            this.fStandalone = true;
            return;
        }
        this.fStandalone = s.equals("yes");
    }

    public boolean encodingSet() {
        return this.fEncodingSchemeSet;
    }

    public boolean standaloneSet() {
        return this.fStandaloneSet;
    }

    public void setEncoding(String encoding) {
        this.fEncodingScheam = encoding;
    }

    void setDeclaredEncoding(boolean value) {
        this.fEncodingSchemeSet = value;
    }

    public void setVersion(String s) {
        this.fVersion = s;
    }

    void clear() {
        this.fEncodingScheam = "UTF-8";
        this.fStandalone = true;
        this.fVersion = "1.0";
        this.fEncodingSchemeSet = false;
        this.fStandaloneSet = false;
    }

    public String toString() {
        String s = "<?xml version=\"" + this.fVersion + "\"";
        s = String.valueOf(s) + " encoding='" + this.fEncodingScheam + "'";
        s = this.fStandaloneSet ? (this.fStandalone ? String.valueOf(s) + " standalone='yes'?>" : String.valueOf(s) + " standalone='no'?>") : String.valueOf(s) + "?>";
        return s;
    }

    public boolean isStartDocument() {
        return true;
    }
}

