/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.namespace.NamespaceContext;
import com.fr.third.javax.xml.stream.Entity;
import com.fr.third.javax.xml.stream.Location;
import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.StaxErrorReporter;
import com.fr.third.javax.xml.stream.XMLDTDScannerImpl;
import com.fr.third.javax.xml.stream.XMLEntityManager;
import com.fr.third.javax.xml.stream.XMLEntityReaderImpl;
import com.fr.third.javax.xml.stream.XMLEntityStorage;
import com.fr.third.javax.xml.stream.XMLNSDocumentScannerImpl;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamReader;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.DTDGrammar;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLNotationDecl;
import com.fr.third.javax.xml.stream.events.EntityDeclarationImpl;
import com.fr.third.javax.xml.stream.events.NotationDeclarationImpl;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import com.fr.third.javax.xml.stream.xerces.util.XMLStringBuffer;
import com.fr.third.javax.xml.stream.xerces.xni.QName;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;

public class XMLReaderImpl
implements XMLStreamReader {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private SymbolTable fSymbolTable = new SymbolTable();
    protected XMLNSDocumentScannerImpl fScanner = new XMLNSDocumentScannerImpl();
    protected NamespaceContextWrapper fNamespaceContextWrapper = new NamespaceContextWrapper(this.fScanner.getNamespaceContext());
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected StaxErrorReporter fErrorReporter = new StaxErrorReporter();
    protected XMLEntityReaderImpl fEntityScanner = null;
    protected XMLInputSource fInputSource = null;
    protected PropertyManager fPropertyManager = null;
    private int fEventType;
    static final boolean DEBUG = false;
    private boolean fReuse = true;
    private boolean fBindNamespaces = true;
    private String fDTDDecl = null;

    public XMLReaderImpl(InputStream inputStream, PropertyManager props) throws XMLStreamException {
        this.init(props);
        XMLInputSource inputSource = new XMLInputSource(null, null, null, inputStream, null);
        this.setInputSource(inputSource);
    }

    public XMLReaderImpl(String systemid, PropertyManager props) throws XMLStreamException {
        this.init(props);
        XMLInputSource inputSource = new XMLInputSource(null, systemid, null);
        this.setInputSource(inputSource);
    }

    public XMLReaderImpl(InputStream inputStream, String encoding, PropertyManager props) throws XMLStreamException {
        this.init(props);
        XMLInputSource inputSource = new XMLInputSource(null, null, null, new BufferedInputStream(inputStream), encoding);
        this.setInputSource(inputSource);
    }

    public XMLReaderImpl(Reader reader, PropertyManager props) throws XMLStreamException {
        this.init(props);
        XMLInputSource inputSource = new XMLInputSource(null, null, null, new BufferedReader(reader), null);
        this.setInputSource(inputSource);
    }

    public XMLReaderImpl(XMLInputSource inputSource, PropertyManager props) throws XMLStreamException {
        this.init(props);
        this.setInputSource(inputSource);
    }

    public void setInputSource(XMLInputSource inputSource) throws XMLStreamException {
        this.fReuse = false;
        try {
            this.fScanner.setInputSource(inputSource);
            this.fEventType = this.fScanner.next();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void setInputSource(InputSource inputSource) throws XMLStreamException {
        this.setInputSource(this.convertSAXInputSource2XMLInputSource(inputSource));
    }

    XMLInputSource convertSAXInputSource2XMLInputSource(InputSource inputSource) {
        XMLInputSource xmlInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null && !(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        xmlInputSource.setByteStream(inputStream);
        Reader reader = inputSource.getCharacterStream();
        if (!(reader == null || reader instanceof BufferedReader || reader instanceof CharArrayReader || reader instanceof StringReader)) {
            reader = new BufferedReader(reader);
        }
        xmlInputSource.setCharacterStream(reader);
        xmlInputSource.setEncoding(inputSource.getEncoding());
        return xmlInputSource;
    }

    void init(PropertyManager propertyManager) throws XMLStreamException {
        this.fPropertyManager = propertyManager;
        propertyManager.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        propertyManager.setProperty(ERROR_REPORTER, this.fErrorReporter);
        propertyManager.setProperty(ENTITY_MANAGER, this.fEntityManager);
        this.reset();
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void reset() {
        this.fReuse = true;
        this.fEventType = 0;
        this.fEntityManager.reset(this.fPropertyManager);
        this.fScanner.reset(this.fPropertyManager);
        this.fDTDDecl = null;
        this.fEntityScanner = (XMLEntityReaderImpl)this.fEntityManager.getEntityReader();
        this.fBindNamespaces = (Boolean)this.fPropertyManager.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware");
    }

    public void close() throws XMLStreamException {
        this.fReuse = true;
    }

    public String getCharacterEncodingScheme() {
        return this.fScanner.getCharacterEncodingScheme();
    }

    public int getColumnNumber() {
        return this.fEntityScanner.getColumnNumber();
    }

    public String getEncoding() {
        return this.fEntityScanner.getEncoding();
    }

    public int getEventType() {
        return this.fEventType;
    }

    public int getLineNumber() {
        return this.fEntityScanner.getLineNumber();
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        if (this.fEventType == 9) {
            return this.fScanner.getEntityName();
        }
        return null;
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().uri;
        }
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().prefix;
        }
        return null;
    }

    public char[] getTextCharacters() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().ch;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextCharacters() ");
    }

    public int getTextLength() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().length;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextLength() ");
    }

    public int getTextStart() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().offset;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextStart() ");
    }

    public String getValue() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        if (this.fEventType == 5) {
            return this.fScanner.getComment();
        }
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 4) {
            return this.fScanner.getCharacterData().toString();
        }
        return null;
    }

    public String getVersion() {
        return this.fEntityScanner.getVersion();
    }

    public boolean hasAttributes() {
        return this.fScanner.getAttributeIterator().getLength() > 0;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public boolean hasValue() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3 || this.fEventType == 5 || this.fEventType == 4;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isStandalone() {
        return this.fScanner.isStandAlone();
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (this.isCharacters() || this.fEventType == 12) {
            char[] ch = this.getTextCharacters();
            int start = this.getTextStart();
            int end = start + this.getTextLength();
            int i = start;
            while (i < end) {
                if (!XMLChar.isSpace(ch[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int next() throws XMLStreamException {
        try {
            this.fEventType = this.fScanner.next();
            return this.fEventType;
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex.getMessage(), this.getLocation(), ex);
        }
        catch (XNIException ex) {
            throw new XMLStreamException(ex.getMessage(), this.getLocation(), ex.getException());
        }
    }

    static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + String.valueOf(eventType);
    }

    public int getAttributeCount() {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLength();
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeCount()");
    }

    public com.fr.third.javax.xml.namespace.QName getAttributeName(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getAttributeIterator().getQualifiedName(index));
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeName()");
    }

    public String getAttributeLocalName(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLocalName(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeLocalName()");
    }

    public String getAttributeNamespace(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getURI(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeNamespace()");
    }

    public String getAttributePrefix(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getPrefix(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributePrefix()");
    }

    public com.fr.third.javax.xml.namespace.QName getAttributeQName(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            String localName = this.fScanner.getAttributeIterator().getLocalName(index);
            String uri = this.fScanner.getAttributeIterator().getURI(index);
            return new com.fr.third.javax.xml.namespace.QName(uri, localName);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeQName()");
    }

    public String getAttributeType(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getType(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeType()");
    }

    public String getAttributeValue(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(namespaceURI, localName);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuffer content = new StringBuffer();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return content.toString();
    }

    public Location getLocation() {
        return new Location(){

            public String getLocationURI() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public int getCharacterOffset() {
                return XMLReaderImpl.this.fEntityScanner.getCharacterOffset();
            }

            public int getColumnNumber() {
                return XMLReaderImpl.this.fEntityScanner.getColumnNumber();
            }

            public int getLineNumber() {
                return XMLReaderImpl.this.fEntityScanner.getLineNumber();
            }

            public String getPublicId() {
                return XMLReaderImpl.this.fEntityScanner.getPublicId();
            }

            public String getSystemId() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public String toString() {
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append("Line number = " + this.getLineNumber());
                sbuffer.append("\n");
                sbuffer.append("Column number = " + this.getColumnNumber());
                sbuffer.append("\n");
                sbuffer.append("System Id = " + this.getSystemId());
                sbuffer.append("\n");
                sbuffer.append("Public Id = " + this.getPublicId());
                sbuffer.append("\n");
                sbuffer.append("Location Uri= " + this.getLocationURI());
                sbuffer.append("\n");
                sbuffer.append("CharacterOffset = " + this.getCharacterOffset());
                sbuffer.append("\n");
                return sbuffer.toString();
            }
        };
    }

    public com.fr.third.javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getElementQName());
        }
        throw new IllegalArgumentException("Illegal to call getName() when event type is " + XMLReaderImpl.getEventTypeString(this.fEventType) + "." + " Valid states are " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2));
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContextWrapper;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getDeclaredPrefixCount();
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceCount().");
    }

    public String getNamespacePrefix(int index) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            String prefix = this.fScanner.getNamespaceContext().getDeclaredPrefixAt(index);
            return prefix.equals("") ? null : prefix;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespacePrefix().");
    }

    public String getNamespaceURI(int index) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getURI(this.fScanner.getNamespaceContext().getDeclaredPrefixAt(index));
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceURI().");
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPropertyManager != null) {
            if (name.equals("com.fr.third.javax.xml.stream.notations")) {
                return this.getNotationDecls();
            }
            if (name.equals("com.fr.third.javax.xml.stream.entities")) {
                return this.getEntityDecls();
            }
            return this.fPropertyManager.getProperty(name);
        }
        return null;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().toString();
        }
        if (this.fEventType == 9) {
            String name = this.fScanner.getEntityName();
            if (name != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return this.fScanner.getCharacterData().toString();
                }
                XMLEntityStorage entityStore = this.fEntityManager.getEntityStore();
                Hashtable ht = entityStore.getDeclaredEntities();
                Entity en = (Entity)ht.get(name);
                if (en == null) {
                    return null;
                }
                if (en.isExternal()) {
                    return ((Entity.ExternalEntity)en).entityLocation.getExpandedSystemId();
                }
                return ((Entity.InternalEntity)en).text;
            }
            return null;
        }
        if (this.fEventType == 11) {
            if (this.fDTDDecl != null) {
                return this.fDTDDecl;
            }
            XMLStringBuffer tmpBuffer = this.fScanner.getDTDDecl();
            this.fDTDDecl = tmpBuffer.toString();
            return this.fDTDDecl;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states" + XMLReaderImpl.getEventTypeString(4) + ", " + XMLReaderImpl.getEventTypeString(5) + ", " + XMLReaderImpl.getEventTypeString(12) + ", " + XMLReaderImpl.getEventTypeString(6) + ", " + XMLReaderImpl.getEventTypeString(9) + ", " + XMLReaderImpl.getEventTypeString(11) + " valid for getText() ");
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this.fEventType) {
            throw new XMLStreamException("Event type " + XMLReaderImpl.getEventTypeString(type) + " specified did " + "not match with current parser event " + XMLReaderImpl.getEventTypeString(this.fEventType));
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Namespace URI " + namespaceURI + " specified did not match " + "with current namespace URI");
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("LocalName " + localName + " specified did not match with " + "current local name");
        }
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (target == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (targetStart < 0 || length < 0 || sourceStart < 0 || targetStart >= target.length || targetStart + length > target.length) {
            throw new IndexOutOfBoundsException();
        }
        int copiedLength = 0;
        int available = this.getTextLength() - sourceStart;
        if (available < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        copiedLength = available < length ? available : length;
        System.arraycopy(this.getTextCharacters(), this.getTextStart() + sourceStart, target, targetStart, copiedLength);
        return copiedLength;
    }

    public boolean hasText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12) {
            return this.fScanner.getCharacterData().length > 0;
        }
        if (this.fEventType == 9) {
            String name = this.fScanner.getEntityName();
            if (name != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return true;
                }
                XMLEntityStorage entityStore = this.fEntityManager.getEntityStore();
                Hashtable ht = entityStore.getDeclaredEntities();
                Entity en = (Entity)ht.get(name);
                if (en == null) {
                    return false;
                }
                if (en.isExternal()) {
                    return ((Entity.ExternalEntity)en).entityLocation.getExpandedSystemId() != null;
                }
                return ((Entity.InternalEntity)en).text != null;
            }
            return false;
        }
        if (this.fEventType == 11) {
            return this.fScanner.fSeenDoctypeDecl;
        }
        return false;
    }

    public boolean isAttributeSpecified(int index) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().isSpecified(index);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for isAttributeSpecified()");
    }

    public boolean isCharacters() {
        return this.fEventType == 4;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public boolean standaloneSet() {
        return this.fScanner.isStandAlone();
    }

    public com.fr.third.javax.xml.namespace.QName convertXNIQNametoJavaxQName(QName qname) {
        if (qname == null) {
            return null;
        }
        if (qname.prefix == null) {
            return new com.fr.third.javax.xml.namespace.QName(qname.uri, qname.localpart);
        }
        return new com.fr.third.javax.xml.namespace.QName(qname.uri, qname.localpart, qname.prefix);
    }

    public String getNamespaceURI(String prefix) {
        return this.fScanner.getNamespaceContext().getURI(this.fSymbolTable.addSymbol(prefix));
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
        this.fScanner.setProperty("stax-properties", propertyManager);
        this.fScanner.setPropertyManager(propertyManager);
    }

    protected PropertyManager getPropertyManager() {
        return this.fPropertyManager;
    }

    static void pr(String str) {
        System.out.println(str);
    }

    protected List getEntityDecls() {
        if (this.fEventType == 11) {
            XMLEntityStorage entityStore = this.fEntityManager.getEntityStore();
            Hashtable ht = entityStore.getDeclaredEntities();
            ArrayList<EntityDeclarationImpl> list = null;
            if (ht != null) {
                EntityDeclarationImpl decl = null;
                list = new ArrayList<EntityDeclarationImpl>(ht.size());
                Enumeration enu = ht.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    Entity en = (Entity)ht.get(key);
                    decl = new EntityDeclarationImpl();
                    decl.setEntityName(key);
                    if (en.isExternal()) {
                        decl.setXMLResourceIdentifier(((Entity.ExternalEntity)en).entityLocation);
                        decl.setNotationName(((Entity.ExternalEntity)en).notation);
                    } else {
                        decl.setEntityReplacementText(((Entity.InternalEntity)en).text);
                    }
                    list.add(decl);
                }
            }
            return list;
        }
        return null;
    }

    protected List getNotationDecls() {
        if (this.fEventType == 11) {
            if (this.fScanner.fDTDScanner == null) {
                return null;
            }
            DTDGrammar grammar = ((XMLDTDScannerImpl)this.fScanner.fDTDScanner).getGrammar();
            if (grammar == null) {
                return null;
            }
            List notations = grammar.getNotationDecls();
            Iterator it = notations.iterator();
            ArrayList<NotationDeclarationImpl> list = new ArrayList<NotationDeclarationImpl>();
            while (it.hasNext()) {
                XMLNotationDecl ni = (XMLNotationDecl)it.next();
                if (ni == null) continue;
                list.add(new NotationDeclarationImpl(ni));
            }
            return list;
        }
        return null;
    }
}

