/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.parser.destinations;

import com.fr.third.com.lowagie.text.rtf.parser.RtfParser;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestinationListener;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class RtfDestination {
    protected RtfParser rtfParser = null;
    protected boolean modified = false;
    protected RtfCtrlWordData lastCtrlWord = null;
    private static ArrayList listeners = new ArrayList();

    public RtfDestination() {
        this.rtfParser = null;
    }

    public RtfDestination(RtfParser parser) {
        this.rtfParser = parser;
    }

    public void setParser(RtfParser parser) {
        if (this.rtfParser != null && this.rtfParser.equals(parser)) {
            return;
        }
        this.rtfParser = parser;
    }

    public abstract boolean closeDestination();

    public abstract boolean handleOpeningSubGroup();

    public abstract boolean handleCloseGroup();

    public abstract boolean handleOpenGroup();

    public abstract boolean handleCharacter(int var1);

    public abstract boolean handleControlWord(RtfCtrlWordData var1);

    public abstract void setToDefaults();

    public boolean isModified() {
        return this.modified;
    }

    public boolean addListener(RtfDestinationListener listener) {
        return listeners.add(listener);
    }

    public boolean removeListener(RtfDestinationListener listener) {
        return listeners.remove(listener);
    }

    protected RtfCtrlWordData beforeCtrlWord(RtfCtrlWordData ctrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.beforeCtrlWord(ctrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData onCtrlWord(RtfCtrlWordData ctrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.onCtrlWord(ctrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData afterCtrlWord(RtfCtrlWordData ctrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.afterCtrlWord(ctrlWordData);
        }
        return null;
    }

    protected int beforeCharacter(int ch) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.beforeCharacter(ch);
        }
        return 0;
    }

    protected int onCharacter(int ch) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.onCharacter(ch);
        }
        return 0;
    }

    protected int afterCharacter(int ch) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.afterCharacter(ch);
        }
        return 0;
    }

    protected boolean onOpenGroup() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.onOpenGroup();
        }
        return true;
    }

    protected boolean onCloseGroup() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener listener = (RtfDestinationListener)iterator.next();
            listener.onCloseGroup();
        }
        return true;
    }

    public int getNewTokeniserState() {
        return 5;
    }
}

