/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf;

import com.fr.third.com.lowagie.text.Anchor;
import com.fr.third.com.lowagie.text.Annotation;
import com.fr.third.com.lowagie.text.Chapter;
import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Image;
import com.fr.third.com.lowagie.text.List;
import com.fr.third.com.lowagie.text.ListItem;
import com.fr.third.com.lowagie.text.Meta;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.Phrase;
import com.fr.third.com.lowagie.text.Section;
import com.fr.third.com.lowagie.text.SimpleTable;
import com.fr.third.com.lowagie.text.Table;
import com.fr.third.com.lowagie.text.pdf.PdfPTable;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.document.RtfInfoElement;
import com.fr.third.com.lowagie.text.rtf.field.RtfAnchor;
import com.fr.third.com.lowagie.text.rtf.graphic.RtfImage;
import com.fr.third.com.lowagie.text.rtf.list.RtfList;
import com.fr.third.com.lowagie.text.rtf.list.RtfListItem;
import com.fr.third.com.lowagie.text.rtf.table.RtfTable;
import com.fr.third.com.lowagie.text.rtf.text.RtfAnnotation;
import com.fr.third.com.lowagie.text.rtf.text.RtfChapter;
import com.fr.third.com.lowagie.text.rtf.text.RtfChunk;
import com.fr.third.com.lowagie.text.rtf.text.RtfNewPage;
import com.fr.third.com.lowagie.text.rtf.text.RtfParagraph;
import com.fr.third.com.lowagie.text.rtf.text.RtfPhrase;
import com.fr.third.com.lowagie.text.rtf.text.RtfSection;
import com.fr.third.com.lowagie.text.rtf.text.RtfTab;
import java.util.ArrayList;

public class RtfMapper {
    RtfDocument rtfDoc;

    public RtfMapper(RtfDocument doc) {
        this.rtfDoc = doc;
    }

    public RtfBasicElement[] mapElement(Element element) throws DocumentException {
        ArrayList<RtfBasicElement> rtfElements = new ArrayList<RtfBasicElement>();
        if (element instanceof RtfBasicElement) {
            RtfBasicElement rtfElement = (RtfBasicElement)((Object)element);
            rtfElement.setRtfDocument(this.rtfDoc);
            return new RtfBasicElement[]{rtfElement};
        }
        switch (element.type()) {
            case 10: {
                Chunk chunk = (Chunk)element;
                if (chunk.hasAttributes()) {
                    if (chunk.getAttributes().containsKey("IMAGE")) {
                        rtfElements.add(new RtfImage(this.rtfDoc, chunk.getImage()));
                        break;
                    }
                    if (chunk.getAttributes().containsKey("NEWPAGE")) {
                        rtfElements.add(new RtfNewPage(this.rtfDoc));
                        break;
                    }
                    if (chunk.getAttributes().containsKey("TAB")) {
                        Float tabPos = (Float)((Object[])chunk.getAttributes().get("TAB"))[1];
                        RtfTab tab = new RtfTab(tabPos.floatValue(), 0);
                        tab.setRtfDocument(this.rtfDoc);
                        rtfElements.add(tab);
                        rtfElements.add(new RtfChunk(this.rtfDoc, new Chunk("\t")));
                        break;
                    }
                    rtfElements.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                    break;
                }
                rtfElements.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                break;
            }
            case 11: {
                rtfElements.add(new RtfPhrase(this.rtfDoc, (Phrase)element));
                break;
            }
            case 12: {
                rtfElements.add(new RtfParagraph(this.rtfDoc, (Paragraph)element));
                break;
            }
            case 17: {
                rtfElements.add(new RtfAnchor(this.rtfDoc, (Anchor)element));
                break;
            }
            case 29: {
                rtfElements.add(new RtfAnnotation(this.rtfDoc, (Annotation)element));
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                rtfElements.add(new RtfImage(this.rtfDoc, (Image)element));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rtfElements.add(new RtfInfoElement(this.rtfDoc, (Meta)element));
                break;
            }
            case 14: {
                rtfElements.add(new RtfList(this.rtfDoc, (List)element));
                break;
            }
            case 15: {
                rtfElements.add(new RtfListItem(this.rtfDoc, (ListItem)element));
                break;
            }
            case 13: {
                rtfElements.add(new RtfSection(this.rtfDoc, (Section)element));
                break;
            }
            case 16: {
                rtfElements.add(new RtfChapter(this.rtfDoc, (Chapter)element));
                break;
            }
            case 22: {
                try {
                    rtfElements.add(new RtfTable(this.rtfDoc, (Table)element));
                }
                catch (ClassCastException e) {
                    rtfElements.add(new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable()));
                }
                break;
            }
            case 23: {
                try {
                    rtfElements.add(new RtfTable(this.rtfDoc, (PdfPTable)element));
                    break;
                }
                catch (ClassCastException e) {
                    rtfElements.add(new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable()));
                }
            }
        }
        return rtfElements.toArray(new RtfBasicElement[rtfElements.size()]);
    }
}

