/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf;

import com.fr.third.com.lowagie.text.pdf.PdfArray;
import com.fr.third.com.lowagie.text.pdf.PdfDictionary;
import com.fr.third.com.lowagie.text.pdf.PdfEncodings;
import com.fr.third.com.lowagie.text.pdf.PdfIndirectReference;
import com.fr.third.com.lowagie.text.pdf.PdfName;
import com.fr.third.com.lowagie.text.pdf.PdfObject;
import com.fr.third.com.lowagie.text.pdf.PdfReader;
import com.fr.third.com.lowagie.text.pdf.PdfString;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap items, PdfWriter writer) throws IOException {
        if (items.isEmpty()) {
            return null;
        }
        Object[] names = new String[items.size()];
        names = items.keySet().toArray(names);
        Arrays.sort(names);
        if (names.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k = 0;
            while (k < names.length) {
                ar.add(new PdfString((String)names[k], null));
                ar.add((PdfObject)items.get(names[k]));
                ++k;
            }
            dic.put(PdfName.NAMES, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(names.length + 64 - 1) / 64];
        int k = 0;
        while (k < kids.length) {
            int offset = k * 64;
            int end = Math.min(offset + 64, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString((String)names[offset], null));
            arr.add(new PdfString((String)names[end - 1], null));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfString((String)names[offset], null));
                arr.add((PdfObject)items.get(names[offset]));
                ++offset;
            }
            dic.put(PdfName.NAMES, arr);
            kids[k] = writer.addToBody(dic).getIndirectReference();
            ++k;
        }
        int top = kids.length;
        while (true) {
            int k2;
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                k2 = 0;
                while (k2 < top) {
                    arr.add(kids[k2]);
                    ++k2;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 64) - 1) / skip;
            k2 = 0;
            while (k2 < tt) {
                int offset = k2 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfString((String)names[k2 * skip], null));
                arr.add(new PdfString((String)names[Math.min((k2 + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k2] = writer.addToBody(dic).getIndirectReference();
                ++k2;
            }
            top = tt;
        }
    }

    private static void iterateItems(PdfDictionary dic, HashMap items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NAMES));
                if (nn == null) break block2;
                int k = 0;
                while (k < nn.size()) {
                    PdfString s = (PdfString)PdfReader.getPdfObjectRelease(nn.getPdfObject(k++));
                    items.put(PdfEncodings.convertToString(s.getBytes(), null), nn.getPdfObject(k));
                    ++k;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            int k = 0;
            while (k < nn.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease(nn.getPdfObject(k));
                PdfNameTree.iterateItems(kid, items);
                ++k;
            }
        }
    }

    public static HashMap readTree(PdfDictionary dic) {
        HashMap items = new HashMap();
        if (dic != null) {
            PdfNameTree.iterateItems(dic, items);
        }
        return items;
    }
}

