/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.ElementListener;
import com.fr.third.com.lowagie.text.LargeElement;
import com.fr.third.com.lowagie.text.MarkedObject;
import com.fr.third.com.lowagie.text.MarkedSection;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Section
extends ArrayList
implements TextElementArray,
LargeElement {
    public static final int NUMBERSTYLE_DOTTED = 0;
    public static final int NUMBERSTYLE_DOTTED_WITHOUT_FINAL_DOT = 1;
    private static final long serialVersionUID = 3324172577544748043L;
    protected Paragraph title;
    protected String bookmarkTitle;
    protected int numberDepth;
    protected int numberStyle = 0;
    protected float indentationLeft;
    protected float indentationRight;
    protected float indentation;
    protected boolean bookmarkOpen = true;
    protected boolean triggerNewPage = false;
    protected int subsections = 0;
    protected ArrayList numbers = null;
    protected boolean complete = true;
    protected boolean addedCompletely = false;
    protected boolean notAddedYet = true;

    protected Section() {
        this.title = new Paragraph();
        this.numberDepth = 1;
    }

    protected Section(Paragraph title, int numberDepth) {
        this.numberDepth = numberDepth;
        this.title = title;
    }

    public boolean process(ElementListener listener) {
        try {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                listener.add(element);
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public int type() {
        return 13;
    }

    public boolean isChapter() {
        return this.type() == 16;
    }

    public boolean isSection() {
        return this.type() == 13;
    }

    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            tmp.addAll(((Element)i.next()).getChunks());
        }
        return tmp;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    public void add(int index, Object o) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        try {
            Element element = (Element)o;
            if (!element.isNestable()) {
                throw new ClassCastException("You can't add a " + element.getClass().getName() + " to a Section.");
            }
            super.add(index, element);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
        }
    }

    public boolean add(Object o) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        try {
            Element element = (Element)o;
            if (element.type() == 13) {
                Section section = (Section)o;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(section);
            }
            if (o instanceof MarkedSection && ((MarkedObject)o).element.type() == 13) {
                MarkedSection mo = (MarkedSection)o;
                Section section = (Section)mo.element;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(mo);
            }
            if (element.isNestable()) {
                return super.add(o);
            }
            throw new ClassCastException("You can't add a " + element.getClass().getName() + " to a Section.");
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public Section addSection(float indentation, Paragraph title, int numberDepth) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        Section section = new Section(title, numberDepth);
        section.setIndentation(indentation);
        this.add(section);
        return section;
    }

    public Section addSection(float indentation, Paragraph title) {
        return this.addSection(indentation, title, this.numberDepth + 1);
    }

    public Section addSection(Paragraph title, int numberDepth) {
        return this.addSection(0.0f, title, numberDepth);
    }

    public MarkedSection addMarkedSection() {
        MarkedSection section = new MarkedSection(new Section(null, this.numberDepth + 1));
        this.add(section);
        return section;
    }

    public Section addSection(Paragraph title) {
        return this.addSection(0.0f, title, this.numberDepth + 1);
    }

    public Section addSection(float indentation, String title, int numberDepth) {
        return this.addSection(indentation, new Paragraph(title), numberDepth);
    }

    public Section addSection(String title, int numberDepth) {
        return this.addSection(new Paragraph(title), numberDepth);
    }

    public Section addSection(float indentation, String title) {
        return this.addSection(indentation, new Paragraph(title));
    }

    public Section addSection(String title) {
        return this.addSection(new Paragraph(title));
    }

    public void setTitle(Paragraph title) {
        this.title = title;
    }

    public Paragraph getTitle() {
        return Section.constructTitle(this.title, this.numbers, this.numberDepth, this.numberStyle);
    }

    public static Paragraph constructTitle(Paragraph title, ArrayList numbers, int numberDepth, int numberStyle) {
        if (title == null) {
            return null;
        }
        int depth = Math.min(numbers.size(), numberDepth);
        if (depth < 1) {
            return title;
        }
        StringBuffer buf = new StringBuffer(" ");
        int i = 0;
        while (i < depth) {
            buf.insert(0, ".");
            buf.insert(0, (Integer)numbers.get(i));
            ++i;
        }
        if (numberStyle == 1) {
            buf.deleteCharAt(buf.length() - 2);
        }
        Paragraph result = new Paragraph(title);
        result.add(0, new Chunk(buf.toString(), title.getFont()));
        return result;
    }

    public void setNumberDepth(int numberDepth) {
        this.numberDepth = numberDepth;
    }

    public int getNumberDepth() {
        return this.numberDepth;
    }

    public void setNumberStyle(int numberStyle) {
        this.numberStyle = numberStyle;
    }

    public int getNumberStyle() {
        return this.numberStyle;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public void setIndentation(float indentation) {
        this.indentation = indentation;
    }

    public float getIndentation() {
        return this.indentation;
    }

    public void setBookmarkOpen(boolean bookmarkOpen) {
        this.bookmarkOpen = bookmarkOpen;
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public void setTriggerNewPage(boolean triggerNewPage) {
        this.triggerNewPage = triggerNewPage;
    }

    public boolean isTriggerNewPage() {
        return this.triggerNewPage && this.notAddedYet;
    }

    public void setBookmarkTitle(String bookmarkTitle) {
        this.bookmarkTitle = bookmarkTitle;
    }

    public Paragraph getBookmarkTitle() {
        if (this.bookmarkTitle == null) {
            return this.getTitle();
        }
        return new Paragraph(this.bookmarkTitle);
    }

    public void setChapterNumber(int number) {
        this.numbers.set(this.numbers.size() - 1, new Integer(number));
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object s = i.next();
            if (!(s instanceof Section)) continue;
            ((Section)s).setChapterNumber(number);
        }
    }

    public int getDepth() {
        return this.numbers.size();
    }

    private void setNumbers(int number, ArrayList numbers) {
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(number));
        this.numbers.addAll(numbers);
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean notAddedYet) {
        this.notAddedYet = notAddedYet;
    }

    protected boolean isAddedCompletely() {
        return this.addedCompletely;
    }

    protected void setAddedCompletely(boolean addedCompletely) {
        this.addedCompletely = addedCompletely;
    }

    public void flushContent() {
        this.setNotAddedYet(false);
        this.title = null;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (element instanceof Section) {
                Section s = (Section)element;
                if (!s.isComplete() && this.size() == 1) {
                    s.flushContent();
                    return;
                }
                s.setAddedCompletely(true);
            }
            i.remove();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void newPage() {
        this.add(Chunk.NEXTPAGE);
    }
}

