/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text;

import com.fr.third.com.lowagie.text.Cell;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.ElementListener;
import java.util.ArrayList;

public class Row
implements Element {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected Object[] cells;
    protected int height = 0;
    protected int horizontalAlignment;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Row(int columns) {
        this.columns = columns;
        this.reserved = new boolean[columns];
        this.cells = new Object[columns];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    void deleteColumn(int column) {
        if (column >= this.columns || column < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + column);
        }
        --this.columns;
        boolean[] newReserved = new boolean[this.columns];
        Cell[] newCells = new Cell[this.columns];
        int i = 0;
        while (i < column) {
            newReserved[i] = this.reserved[i];
            newCells[i] = this.cells[i];
            if (newCells[i] != null && i + newCells[i].getColspan() > column) {
                newCells[i].setColspan(((Cell)this.cells[i]).getColspan() - 1);
            }
            ++i;
        }
        i = column;
        while (i < this.columns) {
            newReserved[i] = this.reserved[i + 1];
            newCells[i] = this.cells[i + 1];
            ++i;
        }
        if (this.cells[column] != null && ((Cell)this.cells[column]).getColspan() > 1) {
            newCells[column] = this.cells[column];
            newCells[column].setColspan(newCells[column].getColspan() - 1);
        }
        this.reserved = newReserved;
        this.cells = newCells;
    }

    int addElement(Object element) {
        return this.addElement(element, this.currentColumn);
    }

    int addElement(Object element, int column) {
        int lColspan;
        if (element == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (column < 0 || column > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(element) != 1 && this.getObjectID(element) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fr.third.com.lowagie.text.Cell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int n = lColspan = clazz.isInstance(element) ? ((Cell)element).getColspan() : 1;
        if (!this.reserve(column, lColspan)) {
            return -1;
        }
        this.cells[column] = element;
        this.currentColumn += lColspan - 1;
        return column;
    }

    void setElement(Object aElement, int column) {
        if (this.reserved[column]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[column] = aElement;
        if (aElement != null) {
            this.reserved[column] = true;
        }
    }

    boolean reserve(int column) {
        return this.reserve(column, 1);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    boolean reserve(int column, int size) {
        if (column < 0 || column + size > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        int i = column;
        while (i < column + size) {
            if (this.reserved[i]) {
                int j = i;
                while (j >= column) {
                    this.reserved[j] = false;
                    --j;
                }
                return false;
            }
            this.reserved[i] = true;
            ++i;
        }
        return true;
    }

    boolean isReserved(int column) {
        return this.reserved[column];
    }

    int getElementID(int column) {
        if (this.cells[column] == null) {
            return 0;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fr.third.com.lowagie.text.Cell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(this.cells[column])) {
            return 1;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.fr.third.com.lowagie.text.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isInstance(this.cells[column])) {
            return 2;
        }
        return -1;
    }

    int getObjectID(Object element) {
        if (element == null) {
            return 0;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fr.third.com.lowagie.text.Cell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(element)) {
            return 1;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.fr.third.com.lowagie.text.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isInstance(element)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int column) {
        if (column < 0 || column > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + column + " max is " + this.columns);
        }
        return this.cells[column];
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.columns) {
            if (this.cells[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setHorizontalAlignment(int value) {
        this.horizontalAlignment = value;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

