/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr;

import com.fr.third.antlr.ANTLRTokdefLexer;
import com.fr.third.antlr.ANTLRTokdefParser;
import com.fr.third.antlr.Grammar;
import com.fr.third.antlr.RecognitionException;
import com.fr.third.antlr.SimpleTokenManager;
import com.fr.third.antlr.StringLiteralSymbol;
import com.fr.third.antlr.TokenStreamException;
import com.fr.third.antlr.TokenSymbol;
import com.fr.third.antlr.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    ImportVocabTokenManager(Grammar grammar, String filename_, String name_, Tool tool_) {
        super(name_, tool_);
        this.grammar = grammar;
        this.filename = filename_;
        File grammarFile = new File(this.filename);
        if (!grammarFile.exists() && !(grammarFile = new File(this.antlrTool.getOutputDirectory(), this.filename)).exists()) {
            this.antlrTool.panic("Cannot find importVocab file '" + this.filename + "'");
        }
        this.setReadOnly(true);
        try {
            BufferedReader fileIn = new BufferedReader(new FileReader(grammarFile));
            ANTLRTokdefLexer tokdefLexer = new ANTLRTokdefLexer(fileIn);
            ANTLRTokdefParser tokdefParser = new ANTLRTokdefParser(tokdefLexer);
            tokdefParser.setTool(this.antlrTool);
            tokdefParser.setFilename(this.filename);
            tokdefParser.file(this);
        }
        catch (FileNotFoundException fnf) {
            this.antlrTool.panic("Cannot find importVocab file '" + this.filename + "'");
        }
        catch (RecognitionException ex) {
            this.antlrTool.panic("Error parsing importVocab file '" + this.filename + "': " + ex.toString());
        }
        catch (TokenStreamException ex) {
            this.antlrTool.panic("Error reading importVocab file '" + this.filename + "'");
        }
    }

    public Object clone() {
        ImportVocabTokenManager tm = (ImportVocabTokenManager)super.clone();
        tm.filename = this.filename;
        tm.grammar = this.grammar;
        return tm;
    }

    public void define(TokenSymbol ts) {
        super.define(ts);
    }

    public void define(String s, int ttype) {
        TokenSymbol ts = null;
        ts = s.startsWith("\"") ? new StringLiteralSymbol(s) : new TokenSymbol(s);
        ts.setTokenType(ttype);
        super.define(ts);
        this.maxToken = ttype + 1 > this.maxToken ? ttype + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }
}

