/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr;

import com.fr.third.antlr.Grammar;
import com.fr.third.antlr.JavaCodeGeneratorPrintWriterManager;
import com.fr.third.antlr.PrintWriterWithSMAP;
import com.fr.third.antlr.Tool;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DefaultJavaCodeGeneratorPrintWriterManager
implements JavaCodeGeneratorPrintWriterManager {
    private Grammar grammar;
    private PrintWriterWithSMAP smapOutput;
    private PrintWriter currentOutput;
    private Tool tool;
    private Map sourceMaps = new HashMap();
    private String currentFileName;

    public PrintWriter setupOutput(Tool tool, Grammar grammar) throws IOException {
        return this.setupOutput(tool, grammar, null);
    }

    public PrintWriter setupOutput(Tool tool, String fileName) throws IOException {
        return this.setupOutput(tool, null, fileName);
    }

    public PrintWriter setupOutput(Tool tool, Grammar grammar, String fileName) throws IOException {
        this.tool = tool;
        this.grammar = grammar;
        if (fileName == null) {
            fileName = grammar.getClassName();
        }
        this.smapOutput = new PrintWriterWithSMAP(tool.openOutputFile(fileName + ".java"));
        this.currentFileName = fileName + ".java";
        this.currentOutput = this.smapOutput;
        return this.currentOutput;
    }

    public void startMapping(int sourceLine) {
        this.smapOutput.startMapping(sourceLine);
    }

    public void startSingleSourceLineMapping(int sourceLine) {
        this.smapOutput.startSingleSourceLineMapping(sourceLine);
    }

    public void endMapping() {
        this.smapOutput.endMapping();
    }

    public void finishOutput() throws IOException {
        this.currentOutput.close();
        if (this.grammar != null) {
            PrintWriter smapWriter = this.tool.openOutputFile(this.grammar.getClassName() + ".smap");
            String grammarFile = this.grammar.getFilename();
            int lastSlash = (grammarFile = grammarFile.replace('\\', '/')).lastIndexOf(47);
            if (lastSlash != -1) {
                grammarFile = grammarFile.substring(lastSlash + 1);
            }
            this.smapOutput.dump(smapWriter, this.grammar.getClassName(), grammarFile);
            this.sourceMaps.put(this.currentFileName, this.smapOutput.getSourceMap());
        }
        this.currentOutput = null;
    }

    public Map getSourceMaps() {
        return this.sourceMaps;
    }

    public int getCurrentOutputLine() {
        return this.smapOutput.getCurrentOutputLine();
    }
}

