/**
 * Coder: Sean
 * Date: 14-4-29
 * Time: 12:31
 */
FS.USERMGR = {
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_usermgr.css', 'css');
        this.preLoadData();
        this.createSetPane(renderer);
        this.user = new FS.LTabPane({
            width: '100%',
            height: '100%',
            style: 'blue',
            top: 15,
            left: 20,
            marginLeft: 40,
            items: [this.userModule()],
            renderEl: renderer
        })
    },
    /**
     * ûҳԤ
     */
    preLoadData: function(){
        var self = this;
        //ȡû֤ʽ
        this.loginAuthenticateType = FS.Trans.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=loginAuthenticateType",
            returnString: true
        });
        //ȡݼͬݼϢ
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=fs_get_syncdatainfo',
            type: 'POST',
            async : false,
            complete : function(res) {
                self.syncdata = FR.jsonDecode(res.responseText);
            }
        });
        //Ƿͬݼ
        var state = FS.Trans.getTableDataSyncState();
        this.isSyncOn = (state.type === 1);
    },
    /**
     * жǷLDAP֤
     * @returns {boolean} ǷLDAP֤
     */
    isAuthLdap: function(){
        if(this.loginAuthenticateType == 'ldap'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * жǷƽ̨֤ʽ
     * @returns {boolean}
     */
    isAuthDefault: function(){
        if(this.loginAuthenticateType == 'default'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * 
     * @param anchor ̶dom
     */
    createSetPane: function (anchor) {
        var self = this;
        var confirmPanel =  {
            type: 'confirm',
            fit: true,
            doSize: true,
            closeAfterAction: false,
            btnsAlignment: 'left',
            needSeparate: 8,
            onOK: function () {
                var isSaveSuccess = true;
                var authtype = self.floatPane.getWidgetByName("authModeRadioGroup").getValue();
                switch (authtype){
                    case 0: authtype = "default";break;
                    case 1: authtype = "ldap";break;
                    default : authtype = "http";break;
                }
                FR.ajax({
                    url : FR.servletURL + "?op=fs_load&cmd=installLoginAuthenticateType",
                    data : { loginAuthenticateType : authtype},
                    async: false,
                    complete: function(res, status){
                        if(status == 'success'){
                            var re = FR.jsonDecode(res.responseText);
                            isSaveSuccess = re.success && isSaveSuccess;
                            if (isSaveSuccess) {
                                var result = self.saveAuthConfig(authtype, self.floatPane);
                                self.loginAuthenticateType = authtype;
                                isSaveSuccess = result.success && isSaveSuccess;
                            }
                        }
                    }
                });
                //ͬݼñ
                var syncOn = self.floatPane.getWidgetByName("tableDataCombo").getValue() ? true : false;
                if(syncOn){
                    var data = self.getDSWidgetData(self.floatPane);
                    var syncRes = FS.Trans.saveTableDataSync(data);
                    isSaveSuccess = syncRes.success && isSaveSuccess;
                }else{
                    var result = FS.Trans.closeTableDataSync();
                    isSaveSuccess = result.success && isSaveSuccess;
                }
                if(isSaveSuccess){
                    FS.signOut();
                }else{
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                }
            },
            onCancel: function () {
                self.popAuthSetData(self.floatPane);
                self.popSyncSetData(self.floatPane);
                self.floatPane.doSlide();
            },
            contentWidget: {
                type: "tablepane",
                widgetName: "scrollSetPane",
                colSize: ["fill"],
                rowSize: ["auto"],
                scrollable: true,
                items: [
                    [self._createSetPaneContent()]
                ]
            }
        };
        self.floatPane = FR.createWidget({
            type: 'floatpane',
            anchor: anchor,
            contentHeight: 350,
            contentWidget: confirmPanel
        });
        self.floatPane.getWidgetByName("scrollSetPane").element.css({
            position: 'relative',
            'overflow-y': 'auto'
        });
        self.floatPane.getWidgetByName("authModeRadioGroup").element.css({
            position: 'relative'
        });
        this.popAuthSetData(self.floatPane);
        this.popSyncSetData(self.floatPane);
    },

    _createSetPaneContent: function () {
        var self = this;
        return {
            type: 'tablepane',
            widgetName: 'SETTABLE',
            colSize: [20, 110, 450],
            rowSize: [0, 21, 230, 25, 170, 5],
            vgap: 15,
            items: [
                [
                    null, null, {}
                ], [
                    //û֤ʽ
                    {}, {type: 'llabel', value: FR.i18nText("FS-User-Simple_Authentication")},
                    {
                        type: 'radiogroup',
                        assureSelect: true,
                        columnsInRow: 3,
                        widgetName: 'authModeRadioGroup',
                        width: 300,
                        value: 0,
                        items: [
                            {value: 0, text: FR.i18nText("FS-User-Builtin_Authentification")},
                            {value: 1, text: FR.i18nText("FS-User-LDAP_Authentification")},
                            {value: 2, text: FR.i18nText("FS-User-Http_Authentification")}
                        ],
                        listeners: [
                            {eventName: FR.Events.AFTEREDIT,
                                action: function () {
                                    var value = this.getValue();
                                    if (value === 0) {
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2, 3], false);
                                    } else if (value === 1) {
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2], true);
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([3], false);
                                    } else if (value === 2){
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2], false);
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([3], true);
                                    }
                                }
                            }
                        ]
                    }
                ], [
                    {}, {}, self._createLdapSetTable()
                ], [
                    {}, {}, {type:'text',widgetName:'httpurlText',watermark:'Example: http://localhost/saa'}
                ], [
                    {}, {
                        type: 'tablepane',
                        colSize: ['fill'],
                        rowSize: [21, 'fill'],
                        vgap: 8,
                        items: [
                            [
                                {type: 'llabel', value: FR.i18nText("FS-User-Synchronized_DataSet"), verticalcenter: false}
                            ],
                            [{}]
                        ]
                    },
                    self._createUserAuthSetTable()
                ], [
                    null, null, {}
                ]
            ]
        }
    },

    _createLdapSetTable: function () {
        return {
            type: 'tablepane',
            widgetName: 'LDAPSETTABLE',
            colSize: [110, 210],
            rowSize: [21, 21, 21, 21, 21, 21, 21, 21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: '*URL'},
                    {type: 'text', widgetName: 'urlCombo', watermark: FR.i18nText("FS-Generic-Simple_Example") + ':ldap://192.168.106.201:389'}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Retrieve_Location")},
                    {type: 'text', widgetName: 'locationText', watermark: FR.i18nText("FS-Generic-Simple_Example") + 'DC=finereport'}
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Simple_Authentication")},
                    {type: 'combo', widgetName: 'authmodCombo',
                        items: [
                            {
                                'text': 'simple',
                                'value': 1
                            }, {
                                'text': 'strong',
                                'value': 2
                            }, {
                                'text': 'none',
                                'value': 3
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Ldap_Context")},
                    {type: 'combo', widgetName: 'contextCombo',
                        items: [
                            {
                                'text': 'com.sun.jndi.ldap.LdapCtxFactory',
                                'value': 1
                            }, {
                                'text': 'com.sun.jndi.ldap.connect.pool',
                                'value': 2
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Ldap_Referral")},
                    {type: 'combo', widgetName: 'ReferralCombo',
                        items: [
                            {
                                'text': 'follow',
                                'value': 1
                            }, {
                                'text': 'ignore',
                                'value': 2
                            }, {
                                'text': 'throw',
                                'value': 3
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Ldap_Suffix")},
                    {type: 'text', widgetName: 'suffixText', watermark: FR.i18nText("FS-Generic-Simple_Example") + ':@finereport.com'}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Simple_Name")},
                    {type: 'text', widgetName: 'adminnameText'}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Admin_Password")},
                    {type: 'password', widgetName: 'adminpwdText'}
                ]
            ]
        }
    },

    _createUserAuthSetTable: function () {
        var self = this;
        var $line = $('<div class="fs-usermgr-line"/>');
        var leftPane = {
            type: 'tablepane',
            widgetName: 'userAuthTable',
            colSize: [100, 110],
            rowSize: [21,21,21,21,21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-DS_Server_TableData")},
                    {
                        type: 'combo' ,
                        widgetName:'tableDataCombo',
                        widgetUrl:FR.servletURL+"?op=fs_manager&cmd=fs_get_servertabledata",
                        listeners: [
                            {
                                eventName: FR.Events.AFTEREDIT,
                                action: function () {
                                    var ds = this.getValue();
                                    self.rebuildDSWidgets(ds, this);
                                }
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Username")},
                    {type: 'combo' ,widgetName:'usernameCombo', items:[]}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Password")},
                    {type: 'combo' ,widgetName:'passwordCombo', items:[]}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Encryption_Mode")},
                    {
                        type: 'combo',
                        widgetName: 'encryptionCombo',
                        allowBlank: true,
                        items: [
                            {text: FR.i18nText("FS-User-No_Encryption"), value: 0},
                            {text: FR.i18nText("FS-User-Custom_Encryption"), value: 1},
                            {text: FR.i18nText("FS-User-MD5_Encryption"), value: 2}
                        ],
                        listeners: [
                            {
                                eventName: FR.Events.AFTEREDIT,
                                action: function () {
                                    var val = this.getValue();
                                    var table = this.getWidgetByName("userAuthTable");
                                    if (val === 1) {
                                        table.getWidgetByName('customEncrypText').setVisible(true);
                                    } else {
                                        table.getWidgetByName('customEncrypText').setVisible(false);
                                    }
                                }
                            }
                        ]
                    }
                ], [
                    {},
                    {type: 'text' ,widgetName:'customEncrypText'}
                ]
            ]
        };
        var rightPane = {
            type: 'tablepane',
            colSize: [60, 110],
            rowSize: [21, 21, 21, 21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Full_Name")},
                    {type: 'combo' ,widgetName:'fullnameCombo', items:[]}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Role")},
                    {type: 'combo' ,widgetName:'roleCombo', items:[]}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Email")},
                    {type: 'combo' ,widgetName:'emailCombo', items:[]}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Mobile_Phone")},
                    {type: 'combo' ,widgetName:'mobilephoneCombo', items:[]}
                ]
            ]
        };
        return {
            type: 'tablepane',
            colSize: [240, 30, 180],
            rowSize: [180],
            vgap: 8,
            items: [
                [
                    leftPane,
                    $('<div/>').append($line),
                    rightPane
                ]
            ]
        };
    },
    
    popAuthSetData: function(pw){
        if(this.isAuthDefault()){
            pw.getWidgetByName('authModeRadioGroup').setValue(0, true);
        }else if(this.isAuthLdap()){
            var ldapAttrs = FR.jsonDecode(FS.Trans.getLdapAttrs());
            pw.getWidgetByName('authModeRadioGroup').setValue(1, true);
            pw.getWidgetByName('urlCombo').setValue(ldapAttrs.ldapUrl);
            pw.getWidgetByName('locationText').setValue(ldapAttrs.ldapSearchBase);
            pw.getWidgetByName('authmodCombo').setValue(ldapAttrs.authentication);
            pw.getWidgetByName('contextCombo').setValue(ldapAttrs.contextFactory);
            pw.getWidgetByName('ReferralCombo').setValue(ldapAttrs.referral);
            pw.getWidgetByName('suffixText').setValue(ldapAttrs.principalSuffix);
            pw.getWidgetByName('adminnameText').setValue(ldapAttrs.ldapSystemName);
            pw.getWidgetByName('adminpwdText').setValue(ldapAttrs.ldapSystemPassword);
        }else{
            pw.getWidgetByName('authModeRadioGroup').setValue(2, true);
            FR.ajax({
                url: FR.servletURL+"?op=fs_set&cmd=sc_http_get",
                complete: function(res, status){
                    if(status == 'success'){
                        var http = FR.jsonDecode(res.responseText);
                        if(http.url){
                            pw.getWidgetByName('httpurlText').setValue(http.url);
                        }
                    }
                }
            })
        }
    },
    /**
     * 
     * @param {FR.Widget} pw 
     */
    popSyncSetData: function(pw){
        //ͬݼݡ
        var syncdata = this.syncdata;
        pw.getWidgetByName("customEncrypText").setVisible(false);
        if(this.isSyncOn){
            pw.getWidgetByName("tableDataCombo").setValue(syncdata.dsName);
            this.rebuildDSWidgets(syncdata.dsName, pw);
            if(syncdata.userName > -1){
                pw.getWidgetByName("usernameCombo").setValue(syncdata.userName);
            }
            if(syncdata.password > -1){
                pw.getWidgetByName("passwordCombo").setValue(syncdata.password);
            }
            if(syncdata.name > -1){
                pw.getWidgetByName("fullnameCombo").setValue(syncdata.name);
            }
            if(syncdata.role > -1){
                pw.getWidgetByName("roleCombo").setValue(syncdata.role);
            }
            if(syncdata.encrypt > -1){
                pw.getWidgetByName("encryptionCombo").setValue(syncdata.encrypt);
            } else {
                pw.getWidgetByName("encryptionCombo").setValue(0);
            }
            if(syncdata.email > -1){
                pw.getWidgetByName("emailCombo").setValue(syncdata.email);
            }
            if(syncdata.mobile > -1){
                pw.getWidgetByName("mobilephoneCombo").setValue(syncdata.mobile);
            }
            if(syncdata.encrypt === 1){
                pw.getWidgetByName("customEncrypText").setVisible(true);
                pw.getWidgetByName("customEncrypText").setValue(syncdata.myencrypt);
            }
        }
    },
    /**
     * ֤ʽ
     * @param {String} type û֤ʽ
     * @param {FR.Widget} pw 
     */
    saveAuthConfig: function(type, pw){
        var result = {success: true};
        if(type == "ldap") {
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_load&cmd=installLdapAttrs",
                data : {
                    loginLdapUrl: pw.getWidgetByName('urlCombo').getValue(),
                    ldapSearchBase: pw.getWidgetByName('locationText').getValue(),
                    referral: pw.getWidgetByName('ReferralCombo').getText(),
                    authentication: pw.getWidgetByName('authmodCombo').getText(),
                    contextFactory: pw.getWidgetByName('contextCombo').getText(),
                    ldapPrincipalSuffix: pw.getWidgetByName('suffixText').getValue(),
                    ldapSystemName: pw.getWidgetByName('adminnameText').getText(),
                    ldapSystemPassword: pw.getWidgetByName('adminpwdText').getText()
                }
            });
        }else if(type == 'http'){
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_set&cmd=sc_http_set",
                data : {
                    httpurl: pw.getWidgetByName('httpurlText').getValue()
                }
            });
        }
        return result;
    },
    /************û*************/
    userModule: function(){
        //ͬݼûϢ򲻼û
        var isSyncOn = this.isSyncOn;
        var config = {
            title: FR.i18nText("FS-User-Simple_Management"),
            content: {
                type: 'quickgrid',
                page: true,
                autoPage: false,
                pageCount: 10,
                marginLeft: 10,
                marginRight: 10,
                widgetName: 'USERINFOGRID',
                async: !isSyncOn ? null:{
                    url: FR.servletURL + "?op=fs_set&cmd=auth_getalluserinfo",
                    data: {
                        startIdx: 0,
                        count: 10
                    }
                },
                onPageTurn: function(active, count, nav){
                    var async = this.options.async;
                    async.data = {
                        startIdx: (active-1) * count,
                        count: count
                    };
                    this.refresh();
                },
                onAsyncSuccess: function (res, status) {
                    var result = FR.jsonDecode(res);
                    this.options.items = result.users;
                    this.totalpages = Math.ceil(result.total/10);
                },
                columnsConfig: [
                    {
                        key: 'username',
                        value: FR.i18nText("FS-Generic-Simple_Username"),
                        width: 160
                    },
                    {
                        key: 'realname',
                        value: FR.i18nText("FS-Admin-Full_Name"),
                        width: 130
                    },
                    {
                        key: 'role',
                        value: FR.i18nText("FS-Generic-Simple_Role"),
                        width: 130
                    },
                    {
                        key: 'email',
                        value: FR.i18nText("FS-Generic-Simple_Email"),
                        width: 130
                    },
                    {
                        key: 'mobile',
                        value: FR.i18nText("FS-Generic-Mobile_Phone"),
                        width: 130
                    }
                ]
            }
        };
        return config;
    },

    /**
     * ֻƽ̨֤ʱûֻû
     * @param username ûֶ
     * @param password ֶ
     * @returns {boolean} Ƿ
     */
    checkUserValid :function(username, password) {
        if(FR.isEmpty(username)) {
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-User_Can_Not_Be_Null"));
            return false;
        }
        if(this.isAuthDefault() && FR.isEmpty(password)){
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Admin-Password_Can_Not_Be_Null"));
            return false;
        }
        return true;
    },

    /**
     * ȡݼпؼֵ
     * @param pw 
     * @returns {*}
     */
    getDSWidgetData: function(pw){
        var self = this;
        var username = pw.getWidgetByName("usernameCombo").getValue(),
            name = pw.getWidgetByName("fullnameCombo").getValue(),
            password = pw.getWidgetByName("passwordCombo").getValue(),
            role = pw.getWidgetByName("roleCombo").getValue(),
            mobile = pw.getWidgetByName("mobilephoneCombo").getValue(),
            email = pw.getWidgetByName("emailCombo").getValue();
        if(!this.checkUserValid(username,password)){
            return null;
        }
        var res = {
            dsName: pw.getWidgetByName("tableDataCombo").getValue(),
            userName: FR.isEmpty(username) ? -1 : username,
            name: FR.isEmpty(name) ? -1 : name,
            password: FR.isEmpty(password) ? -1 : password,
            role: FR.isEmpty(role) ? -1 : role,
            mobile: FR.isEmpty(mobile) ? -1 : mobile,
            email: FR.isEmpty(email) ? -1 : email,
            encrypt: pw.getWidgetByName("encryptionCombo").getValue()
        };
        if(res.encrypt === 1) {
            res.myencrypt = pw.getWidgetByName("customEncrypText").getValue();
        }
        if(!res.encrypt) {
            res.encrypt = 0;
        }
        return res;
    },
    /**
     * ÷ݼֶѡؼ
     * @param ds ݼ
     * @param pw 
     */
    rebuildDSWidgets: function(ds, pw){
        var cols = [];
        if(!FR.isEmpty(ds)){
            cols = FS.Tools.getColsByTableDataName(ds);
        }
        var widgetNames= ["usernameCombo", "passwordCombo", "fullnameCombo", "emailCombo",
            "mobilephoneCombo", "roleCombo"];
        for(var i= 0;i<6;i++){
            var widget = pw.getWidgetByName(widgetNames[i]);
            widget.options.renderEl = widget.element;
            widget.rebuild(cols);
        }
    }
};
