/**
 * Coder: Sean
 * Date: 14-4-14
 * Time: 6:21
 */
FS.USERMGR = FSUM ={
    Constants: {
        userLimitConfigPanelWD: "userLimitConfigPanel",
        userLimitConfigTableWD: "userLimitConfigTable",
        userLimitUnauthorizedPanelWD: "userLimitUnauthorizedPanel",
        userLimitAuthorizedPanelWD: "userLimitAuthorizedPanel",
        userLimitUnauthorizedListWD: "userLimitUnauthorizedList",
        userLimitAuthorizedListWD: "userLimitAuthorizedList",
        userLimitUnauthorizedListPanelWD: "userLimitUnauthorizedListPanel",
        userLimitAuthorizedListPanelWD: "userLimitAuthorizedListPanel",
        userLimitAuthMoveRightButtonWD: "userLimitAuthMoveRightButton",
        userLimitAuthMoveLeftButtonWD: "userLimitAuthMoveLeftButton"
    },

    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_usermgr.css', 'css');
        this.preLoadData();
        this.mainPane = renderer;
        if (!FS.isGradeAuthorityOpen() || FS.isAdmin()) {
            //ûп༶Ȩ޷ǹԱ¼ʱ,ʹ塣
            this.createSetPane(renderer);
        }
        var items = [
            this.userModule(),
            this.institutionModule()
        ];
        var initActions = [
            function() {

            }, function () {

            }
        ];
        // û¼
        if (FS.config.userLimit > 0 && FS.isAdmin()) {
            items.push(this.userLimitTabConfig());
            initActions.push(function () {
                this.getWidgetByName(FSUM.Constants.userLimitAuthMoveLeftButtonWD).setEnable(false);
                this.getWidgetByName(FSUM.Constants.userLimitAuthMoveRightButtonWD).setEnable(false);
                this.getWidgetByName(FSUM.Constants.userLimitConfigTableWD).element.css("overflow", "auto");
                this.getWidgetByName(FSUM.Constants.userLimitUnauthorizedPanelWD).element.css({
                    position: "relative",
                    overflow: "visible"
                });
                this.getWidgetByName(FSUM.Constants.userLimitAuthorizedPanelWD).element.css({
                    position: "relative",
                    overflow: "visible"
                });
                this.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListPanelWD).element.css("position", "relative");
                this.getWidgetByName(FSUM.Constants.userLimitAuthorizedListPanelWD).element.css("position", "relative");
                this.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListWD).element.css("position", "relative");
                this.getWidgetByName(FSUM.Constants.userLimitAuthorizedListWD).element.css("position", "relative");
                this.getWidgetByName(FSUM.Constants.userLimitConfigTableWD).element.css("position", "relative");
            })
        }
        this.tabPane = new FS.LTabPane({
            width: '100%',
            height: '100%',
            style: 'blue',
            top: 15,
            left: 20,
            marginLeft: 40,
            items: items,
            renderEl: renderer,
            initAfterActions : initActions
        })
    },
    /**
     * ûҳԤ
     */
    preLoadData: function () {
        var self = this;
        //ȡû֤ʽ
        this.loginAuthenticateType = FS.Trans.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=loginAuthenticateType",
            returnString: true
        });
        //ȡݼͬݼϢ
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=fs_get_syncdatainfo',
            type: 'POST',
            async: false,
            complete: function (res, status) {
                self.syncdata = FR.jsonDecode(res.responseText);
            }
        });
        //Ƿͬݼ 0:hsql,1:ͬݼ
        var state = FS.Trans.getTableDataSyncState();
        this.isSyncOn = (state.type === 1);
    },
    /**
     * жǷLDAP֤
     * @returns {boolean} ǷLDAP֤
     */
    isAuthLdap: function () {
        if (this.loginAuthenticateType == 'ldap') {
            return true;
        } else {
            return false;
        }
    },
    /**
     * жǷƽ̨֤ʽ
     * @returns {boolean}
     */
    isAuthDefault: function () {
        if (this.loginAuthenticateType == 'default') {
            return true;
        } else {
            return false;
        }
    },
    /**
     * 
     * @param anchor ̶dom
     */
    createSetPane: function (anchor) {
        var self = this;
        var confirmPanel = {
            type: 'confirm',
            fit: true,
            doSize: true,
            closeAfterAction: false,
            btnsAlignment: 'left',
            needSeparate: 8,
            onOK: function () {
                var isSaveSuccess = true;
                //Sean: ȫͬ˳УΪͬݼҪжLDAP
                //û֤ʽñ
                var authtype = self.floatPane.getWidgetByName("authModeRadioGroup").getValue();
                switch (authtype) {
                    case 0:
                        authtype = "default";
                        break;
                    case 1:
                        authtype = "ldap";
                        break;
                    default :
                        authtype = "http";
                        break;
                }
                FR.ajax({
                    url: FR.servletURL + "?op=fs_load&cmd=installLoginAuthenticateType",
                    data: {loginAuthenticateType: authtype},
                    async: false,
                    complete: function (res, status) {
                        if (status == 'success') {
                            var re = FR.jsonDecode(res.responseText);
                            isSaveSuccess = re.success && isSaveSuccess;
                            if (isSaveSuccess) {
                                var result = self.saveAuthConfig(authtype, self.floatPane);
                                self.loginAuthenticateType = authtype;
                                isSaveSuccess = result.success && isSaveSuccess;
                            }
                        }
                    }
                });
                //ͬݼñ
                var syncOn = self.floatPane.getWidgetByName("syncOpenSwitch").getValue();
                if (syncOn) {
                    var data = self.getDSWidgetData(self.floatPane);
                    var syncRes = FS.Trans.saveTableDataSync(data);
                    isSaveSuccess = syncRes.success && isSaveSuccess;
                } else {
                    var result = FS.Trans.closeTableDataSync();
                    isSaveSuccess = result.success && isSaveSuccess;
                }
                if (isSaveSuccess) {
                    FS.signOut();
                } else {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                }
            },
            onCancel: function () {
                self.popAuthSetData(self.floatPane);
                self.popSyncSetData(self.floatPane);
                self.floatPane.doSlide();
            },
            contentWidget: {
                type: "tablepane",
                widgetName: "scrollSetPane",
                colSize: ["fill"],
                rowSize: ["auto"],
                scrollable: true,
                items: [
                    [self._createSetPaneContent()]
                ]
            }
        };
        self.floatPane = FR.createWidget({
            type: 'floatpane',
            anchor: anchor,
            contentHeight: 350,
            contentWidget: confirmPanel
        });
        self.floatPane.getWidgetByName("scrollSetPane").element.css({
            position: 'relative',
            'overflow-y': 'auto'
        });
        self.floatPane.getWidgetByName("authModeRadioGroup").element.css({
            position: 'relative'
        });
        if (!self.isAuthDefault()) {
            self.floatPane.getWidgetByName("passwordCombo").setEnable(false);
            self.floatPane.getWidgetByName("encryptionCombo").setEnable(false);
        }
        this.popAuthSetData(self.floatPane);
        this.popSyncSetData(self.floatPane);
    },

    _createSetPaneContent: function () {
        var self = this;
        return {
            type: 'tablepane',
            widgetName: 'SETTABLE',
            colSize: [20, 110, 450],
            rowSize: [0, 21, 230, 21, 25, 170, 5],
            vgap: 15,
            items: [
                [
                    null, null, {}
                ], [
                    //û֤ʽ
                    {}, {type: 'llabel', value: FR.i18nText("FS-User-Simple_Authentication")},
                    {
                        type: 'radiogroup',
                        assureSelect: true,
                        columnsInRow: 3,
                        widgetName: 'authModeRadioGroup',
                        width: 300,
                        value: 0,
                        items: [
                            {value: 0, text: FR.i18nText("FS-User-Builtin_Authentification")},
                            {value: 1, text: FR.i18nText("FS-User-LDAP_Authentification")},
                            {value: 2, text: FR.i18nText("FS-User-Http_Authentification")}
                        ],
                        listeners: [
                            {
                                eventName: FR.Events.AFTEREDIT,
                                action: function () {
                                    var value = this.getValue();
                                    if (value === 0) {
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2, 3], false);
                                        self.floatPane.getWidgetByName("passwordCombo").setEnable(true);
                                        self.floatPane.getWidgetByName("encryptionCombo").setEnable(true);
                                    } else if (value === 1) {
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2], true);
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([3], false);
                                        self.floatPane.getWidgetByName("passwordCombo").setEnable(false);
                                        self.floatPane.getWidgetByName("encryptionCombo").setEnable(false);
                                    } else if (value === 2) {
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([2], false);
                                        self.floatPane.getWidgetByName("SETTABLE").setRowVisible([3], true);
                                        self.floatPane.getWidgetByName("passwordCombo").setEnable(false);
                                        self.floatPane.getWidgetByName("encryptionCombo").setEnable(false);
                                    }
                                }
                            }
                        ]
                    }
                ], [
                    {}, {}, self._createLdapSetTable()
                ], [
                    {}, {}, {type: 'text', widgetName: 'httpurlText', watermark: 'Example: http://localhost/saa'}
                ], [
                    {}, {type: 'llabel', value: FR.i18nText("FS-User-Synchronized_DataSet")},
                    {
                        type: 'switch',
                        widgetName: 'syncOpenSwitch',
                        onTurnOff: function () {
                            //رͬݼ
                            self.floatPane.getWidgetByName("SETTABLE").setRowVisible([5], false);
                        },
                        onTurnOn: function () {
                            //ͬݼ
                            self.floatPane.getWidgetByName("SETTABLE").setRowVisible([5], true);
                        }
                    }
                ], [
                    {}, {}, self._createUserAuthSetTable()
                ], [
                    null, null, {}
                ]
            ]
        };
    },

    _createLdapSetTable: function () {
        return {
            type: 'tablepane',
            widgetName: 'LDAPSETTABLE',
            colSize: [110, 210],
            rowSize: [21, 21, 21, 21, 21, 21, 21, 21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: '*URL'},
                    {
                        type: 'text',
                        widgetName: 'urlCombo',
                        watermark: FR.i18nText("FS-Generic-Simple_Example") + ':ldap://192.168.106.201:389'
                    }
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Retrieve_Location")},
                    {
                        type: 'text',
                        widgetName: 'locationText',
                        watermark: FR.i18nText("FS-Generic-Simple_Example") + ':DC=finereport'
                    }
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Simple_Authentication")},
                    {
                        type: 'combo', widgetName: 'authmodCombo',
                        items: [
                            {
                                'text': 'simple',
                                'value': 1
                            }, {
                                'text': 'strong',
                                'value': 2
                            }, {
                                'text': 'none',
                                'value': 3
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Ldap_Context")},
                    {
                        type: 'combo', widgetName: 'contextCombo',
                        items: [
                            {
                                'text': 'com.sun.jndi.ldap.LdapCtxFactory',
                                'value': 1
                            }, {
                                'text': 'com.sun.jndi.ldap.connect.pool',
                                'value': 2
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-User-Ldap_Referral")},
                    {
                        type: 'combo', widgetName: 'ReferralCombo',
                        items: [
                            {
                                'text': 'follow',
                                'value': 1
                            }, {
                                'text': 'ignore',
                                'value': 2
                            }, {
                                'text': 'throw',
                                'value': 3
                            }
                        ]
                    }
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Ldap_Suffix")},
                    {
                        type: 'text',
                        widgetName: 'suffixText',
                        watermark: FR.i18nText("FS-Generic-Simple_Example") + ':@finereport.com'
                    }
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Simple_Name")},
                    {type: 'text', widgetName: 'adminnameText'}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Admin_Password")},
                    {type: 'password', widgetName: 'adminpwdText'}
                ]
            ]
        }
    },

    _createUserAuthSetTable: function () {
        var self = this;
        var $line = $('<div class="fs-usermgr-line"/>');
        var leftPane = {
            type: 'tablepane',
            widgetName: 'userAuthTable',
            colSize: [100, 110],
            rowSize: [21, 21, 21, 21, 21, 21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-DS_Server_TableData")},
                    self.getTableDataComboCfg()
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Username")},
                    {type: 'combo', widgetName: 'usernameCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Admin-Full_Name")},
                    {type: 'combo', widgetName: 'fullnameCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Password")},
                    {type: 'combo', widgetName: 'passwordCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Encryption_Mode")},
                    self.createEncrypComboCfg()
                ], [
                    {},
                    {type: 'text', widgetName: 'customEncrypText'}
                ]
            ]
        };
        var rightPane = {
            type: 'tablepane',
            colSize: [60, 110],
            rowSize: [21, 21, 21, 21, 21],
            vgap: 8,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-User-Simple_Department")},
                    {type: 'combo', widgetName: 'departmentCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Simple_Position")},
                    {type: 'combo', widgetName: 'positionCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Role")},
                    {type: 'combo', widgetName: 'roleCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Email")},
                    {type: 'combo', widgetName: 'emailCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Mobile_Phone")},
                    {type: 'combo', widgetName: 'mobilephoneCombo', items: []}
                ]
            ]
        };
        return {
            type: 'tablepane',
            colSize: [240, 30, 180],
            rowSize: [180],
            vgap: 8,
            items: [
                [
                    leftPane,
                    $('<div/>').append($line),
                    rightPane
                ]
            ]
        };
    },

    popAuthSetData: function (pw) {
        if (this.isAuthDefault()) {
            pw.getWidgetByName('authModeRadioGroup').setValue(0, true);
        } else if (this.isAuthLdap()) {
            var ldapAttrs = FR.jsonDecode(FS.Trans.getLdapAttrs());
            pw.getWidgetByName('authModeRadioGroup').setValue(1, true);
            pw.getWidgetByName('urlCombo').setValue(ldapAttrs.ldapUrl);
            pw.getWidgetByName('locationText').setValue(ldapAttrs.ldapSearchBase);
            pw.getWidgetByName('authmodCombo').setValue(ldapAttrs.authentication);
            pw.getWidgetByName('contextCombo').setValue(ldapAttrs.contextFactory);
            pw.getWidgetByName('ReferralCombo').setValue(ldapAttrs.referral);
            pw.getWidgetByName('suffixText').setValue(ldapAttrs.principalSuffix);
            pw.getWidgetByName('adminnameText').setValue(ldapAttrs.ldapSystemName);
            pw.getWidgetByName('adminpwdText').setValue(ldapAttrs.ldapSystemPassword);
        } else {
            pw.getWidgetByName('authModeRadioGroup').setValue(2, true);
            FR.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=sc_http_get",
                complete: function (res, status) {
                    if (status == 'success') {
                        var http = FR.jsonDecode(res.responseText);
                        if (http.url) {
                            pw.getWidgetByName('httpurlText').setValue(http.url);
                        }
                    }
                }
            });
        }
    },
    /**
     * 
     * @param pw 
     */
    popSyncSetData: function (pw) {
        //ͬݼݡ
        var syncdata = this.syncdata;
        pw.getWidgetByName("userAuthTable").setRowVisible(5, false);
        if (this.isSyncOn) {
            pw.getWidgetByName("syncOpenSwitch").setValue(true, true);
        } else {
            pw.getWidgetByName("syncOpenSwitch").setValue(false, true);
        }
        if (syncdata.dsName) {
            pw.getWidgetByName("tableDataCombo").setValue(syncdata.dsName);
            this.rebuildDSWidgets(syncdata.dsName, pw);
            if (syncdata.userName > -1) {
                pw.getWidgetByName("usernameCombo").setValue(syncdata.userName);
            }
            if (syncdata.password > -1) {
                pw.getWidgetByName("passwordCombo").setValue(syncdata.password);
            }
            if (syncdata.name > -1) {
                pw.getWidgetByName("fullnameCombo").setValue(syncdata.name);
            }
            if (syncdata.department > -1) {
                pw.getWidgetByName("departmentCombo").setValue(syncdata.department);
            }
            if (syncdata.post > -1) {
                pw.getWidgetByName("positionCombo").setValue(syncdata.post);
            }
            if (syncdata.role > -1) {
                pw.getWidgetByName("roleCombo").setValue(syncdata.role);
            }
            if (syncdata.email > -1) {
                pw.getWidgetByName("emailCombo").setValue(syncdata.email);
            }
            if (syncdata.mobile > -1) {
                pw.getWidgetByName("mobilephoneCombo").setValue(syncdata.mobile);
            }
        }
        this.popEncryptSet(pw, syncdata);
    },

    popEncryptSet: function (pw, syncdata) {
        var combo = pw.getWidgetByName("encryptionCombo");
        if (syncdata.encrypt > -1) {
            combo.setValue(syncdata.encrypt, true);
        } else {
            combo.setValue(0, true);
        }
        if (syncdata.encrypt === 1) {
            pw.getWidgetByName("customEncrypText").setValue(syncdata.myencrypt);
        }
    },
    /**
     * ֤ʽ
     * @param {String} type û֤ʽ
     * @param {FR.Widget} pw 
     */
    saveAuthConfig: function (type, pw) {
        var result = {success: true};
        if (type == "ldap") {
            result = FS.Trans.ajax({
                url: FR.servletURL + "?op=fs_load&cmd=installLdapAttrs",
                data: {
                    loginLdapUrl: pw.getWidgetByName('urlCombo').getValue(),
                    ldapSearchBase: pw.getWidgetByName('locationText').getValue(),
                    referral: pw.getWidgetByName('ReferralCombo').getText(),
                    authentication: pw.getWidgetByName('authmodCombo').getText(),
                    contextFactory: pw.getWidgetByName('contextCombo').getText(),
                    ldapPrincipalSuffix: pw.getWidgetByName('suffixText').getValue(),
                    ldapSystemName: pw.getWidgetByName('adminnameText').getText(),
                    ldapSystemPassword: pw.getWidgetByName('adminpwdText').getText()
                }
            });
        } else if (type == 'http') {
            result = FS.Trans.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=sc_http_set",
                data: {
                    httpurl: pw.getWidgetByName('httpurlText').getValue()
                }
            });
        }
        return result;
    },
    /************û*************/
    userModule: function () {
        var self = this;
        var items = [
            self.createHeaderControl(),
            [self.createUserGridCfg(), null, null, null, null, null]
        ];
        var config = {
            title: FR.i18nText("FS-User-All_Users"),
            content: {
                type: 'panel',
                width: 710,
                height: 400,
                doSize: true,
                contentWidget: {
                    type: 'tablepane',
                    colSize: ['auto', 60, 60, 60, 240, 214],
                    rowSize: [28, 'auto'],
                    vgap: 15,
                    marginLeft: 10,
                    marginRight: 10,
                    items: items
                }
            }
        };
        return config;
    },

    createHeaderControl: function () {
        var self = this;
        var header = [
            {}, {
                type: 'search',
                widgetName: 'searchUser',
                onSearch: function () {
                    var value = this.getValue();
                    var usergrid = self.tabPane.getWidgetByName("USERINFOGRID");
                    var data = usergrid.options.async.data;
                    data.startIdx = 0;
                    data.keyword = value;
                    usergrid.activedPage = 1;
                    usergrid.refresh();
                }
            }
        ];
        //δͬݼûӡ롢ɾ
        if (!self.isSyncOn) {
            header.unshift(
                null, {
                    type: 'iconbutton',
                    text: FR.i18nText("FS-Generic-Simple_Add"),
                    baseClass: 'fs-usermgr-add',
                    handler: function () {
                        var addUserDialog = new FR.Dialog({
                            title: FR.i18nText("FS-User-Add_User"),
                            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
                            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
                            onOK: function () {
                                //ûdialogȷť¼
                                var userTable = self.tabPane.getWidgetByName("USERINFOGRID");
                                var userName = addUserDialog.getWidgetByName("USERNAMETEXT").getValue();
                                var realName = addUserDialog.getWidgetByName("FULLNAMETEXT").getValue();
                                var password = !self.isAuthDefault() ? "123456" : addUserDialog.getWidgetByName("PASSWORDTEXT").getValue();
                                if (!self.checkUserValid(userName, realName, password)) {
                                    return false;
                                }
                                var user = {
                                    username: userName,
                                    realname: realName,
                                    password: password,
                                    email: addUserDialog.getWidgetByName("EMAILTEXT").getValue(),
                                    mobile: addUserDialog.getWidgetByName("PHONETEXT").getValue()
                                };
                                var result = FS.Trans.addUser(user);
                                if (!result.success) {
                                    FR.Msg.alert(FR.Msg.Alert, FR.i18nText("FS-User-Add_User_Failure"));
                                    return false;
                                }
                                userTable.refresh();
                            },
                            onCancel: function () {
                            },
                            destroyOnClose: true,
                            animate: false,
                            width: 355,
                            height: 250,
                            confirm: true,
                            border: true,
                            closable: true,
                            contentWidget: {
                                type: 'tablelayout',
                                columnSize: [92, 16, 180],
                                rowSize: [0, 21, 21, 21, 21, 21, 21],
                                vgap: 10,
                                items: [
                                    [
                                        {el: $('<div/>')}
                                    ],
                                    [
                                        {
                                            el: {
                                                type: 'llabel',
                                                textalign: 'right',
                                                value: FR.i18nText("FS-Generic-Simple_Username")
                                            }
                                        },
                                        null,
                                        {el: {type: 'text', widgetName: 'USERNAMETEXT'}}
                                    ],
                                    [
                                        {
                                            el: {
                                                type: 'llabel',
                                                textalign: 'right',
                                                value: FR.i18nText("FS-Admin-Full_Name")
                                            }
                                        },
                                        null,
                                        {el: {type: 'text', widgetName: 'FULLNAMETEXT'}}
                                    ],
                                    !self.isAuthDefault() ? [] :
                                        [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    textalign: 'right',
                                                    value: FR.i18nText("FS-Generic-Simple_Password")
                                                }
                                            },
                                            null,
                                            {el: {type: 'password', widgetName: 'PASSWORDTEXT'}}
                                        ],
                                    [
                                        {
                                            el: {
                                                type: 'llabel',
                                                textalign: 'right',
                                                value: FR.i18nText("FS-Generic-Simple_Email")
                                            }
                                        },
                                        null,
                                        {el: {type: 'text', widgetName: 'EMAILTEXT'}}
                                    ],
                                    [
                                        {
                                            el: {
                                                type: 'llabel',
                                                textalign: 'right',
                                                value: FR.i18nText("FS-Generic-Mobile_Phone")
                                            }
                                        },
                                        null,
                                        {el: {type: 'text', widgetName: 'PHONETEXT'}}
                                    ]
                                ]
                            }
                        });
                        addUserDialog.setVisible(true);
                    }
                }, {
                    type: 'iconbutton',
                    text: FR.i18nText("FS-Generic-Import_2"),
                    baseClass: 'fs-usermgr-import',
                    handler: function () {
                        var dialog = self.createUserImportDialog();
                        dialog.setVisible(true);
                    }
                }, {
                    type: 'iconbutton',
                    text: FR.i18nText("FS-Generic-Simple_Delete"),
                    baseClass: 'fs-usermgr-delete-blue',
                    handler: function () {
                        FR.Msg.confirm(FR.i18nText("FS-User-Delete_User"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                            if (result) {
                                var usrgrid = self.tabPane.getWidgetByName("USERINFOGRID");
                                var selectedData = usrgrid.getSelectedData();
                                var duserids = [];
                                for (var i = 0, len = selectedData.length; i < len; i++) {
                                    duserids.push(selectedData[i].id);
                                }
                                FS.Trans.removeUser(duserids.join(","));
                                usrgrid.refresh();
                            }
                        });
                    }
                }
            )
        } else {
            header.unshift(
                null, {}, {}, {}
            )
        }
        return header;
    },

    /**
     * ûϢбؼϢ
     * @returns {JSON} Ϣ
     */
    createUserGridCfg: function () {
        var self = this;
        var colcfg = [
            {
                key: 'username',
                value: FR.i18nText("FS-Generic-Simple_Username"),
                width: 100
            },
            {
                key: 'realname',
                value: FR.i18nText("FS-Admin-Full_Name"),
                width: 100
            },
            {
                key: 'depart',
                value: FR.i18nText("FS-User-Department_Position"),
                width: 120
            },
            {
                key: 'role',
                value: FR.i18nText("FS-Generic-Simple_Role"),
                width: 100
            },
            {
                key: 'email',
                value: FR.i18nText("FS-Generic-Simple_Email"),
                width: 95
            },
            {
                key: 'mobile',
                value: FR.i18nText("FS-Generic-Mobile_Phone"),
                width: 95
            }
        ];
        if (!this.isSyncOn) {
            colcfg.push({
                width: 24,
                onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                    var usrgrid = this;
                    var editBtn = new FR.IconButton({
                        width: 24,
                        height: 24,
                        imgsrc: 'fs-module-edit-white',
                        handler: function () {
                            var okCallback = function () {
                                //༭ûdialogȷť¼
                                var username = editUserDialog.getWidgetByName("USERNAMETEXT").getValue();
                                var realname = editUserDialog.getWidgetByName("FULLNAMETEXT").getValue();
                                var user = {
                                    username: username,
                                    realname: realname,
                                    email: editUserDialog.getWidgetByName("EMAILTEXT").getValue(),
                                    mobile: editUserDialog.getWidgetByName("PHONETEXT").getValue(),
                                    id: item.id
                                };
                                if (!self.checkUserValid(username, realname, true)) {
                                    return false;
                                }
                                var result = FS.Trans.addUser(user);
                                if (!result.success) {
                                    FR.Msg.alert(FR.Msg.Alert, FR.i18nText("FS-User-Add_User_Failure"));
                                    return false;
                                }
                                usrgrid.refresh();
                            };
                            var editUserDialog = new FR.Dialog({
                                title: FR.i18nText("FS-User-Edit_User"),
                                text4OK: FR.i18nText("FS-Generic-Simple_OK"),
                                text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
                                onOK: function () {
                                    return okCallback.apply(this);
                                },
                                onCancel: function () {
                                },
                                destroyOnClose: true,
                                width: 355,
                                height: 250,
                                confirm: true,
                                border: true,
                                contentWidget: {
                                    type: 'tablelayout',
                                    columnSize: [92, 16, 180],
                                    rowSize: [0, 21, 21, 24, 21, 21, 21],
                                    vgap: 10,
                                    items: [
                                        [
                                            {el: $('<div/>')}
                                        ],
                                        [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    textalign: 'right',
                                                    value: FR.i18nText("FS-Generic-Simple_Username")
                                                }
                                            },
                                            null,
                                            {el: {type: 'text', widgetName: 'USERNAMETEXT'}}
                                        ],
                                        [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    textalign: 'right',
                                                    value: FR.i18nText("FS-Admin-Full_Name")
                                                }
                                            },
                                            null,
                                            {el: {type: 'text', widgetName: 'FULLNAMETEXT'}}
                                        ],
                                        !self.isAuthDefault() ? [] :
                                            [
                                                {
                                                    el: {
                                                        type: 'llabel',
                                                        textalign: 'right',
                                                        value: FR.i18nText("FS-User-Reset_Password")
                                                    }
                                                },
                                                null,
                                                {
                                                    el: {
                                                        type: 'iconbutton',
                                                        widgetName: 'PASSWORDRESET',
                                                        text: FR.i18nText("FS-User-Reset_Password_As"),
                                                        imgsrc: 'fs-usermgr-pwd',
                                                        handler: function () {
                                                            //밴ť¼
                                                            item.password = "123456";
                                                            var result = FS.Trans.addUser(item);
                                                            if (!result.success) {
                                                                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                                                                return false;
                                                            }
                                                            this.setEnable(false);
                                                            this.element.addClass('fs-usermgr-pwd-done').text(FR.i18nText("FS-User-Password_Reseted"));
                                                        }
                                                    }
                                                }
                                            ],
                                        [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    textalign: 'right',
                                                    value: FR.i18nText("FS-Generic-Simple_Email")
                                                }
                                            },
                                            null,
                                            {el: {type: 'text', widgetName: 'EMAILTEXT'}}
                                        ],
                                        [
                                            {
                                                el: {
                                                    type: 'llabel',
                                                    textalign: 'right',
                                                    value: FR.i18nText("FS-Generic-Mobile_Phone")
                                                }
                                            },
                                            null,
                                            {el: {type: 'text', widgetName: 'PHONETEXT'}}
                                        ]
                                    ]
                                }
                            });
                            editUserDialog.setVisible(true);
                            editUserDialog.getWidgetByName("USERNAMETEXT").setValue(item.username);
                            editUserDialog.getWidgetByName("FULLNAMETEXT").setValue(item.realname);
                            editUserDialog.getWidgetByName("EMAILTEXT").setValue(item.email);
                            editUserDialog.getWidgetByName("PHONETEXT").setValue(item.mobile);
                        }
                    });
                    return editBtn.element;
                }
            });
            colcfg.push({
                width: 24,
                onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                    var delBtn = new FR.IconButton({
                        width: 24,
                        height: 24,
                        imgsrc: 'fs-module-delete-white',
                        handler: function () {
                            var userTable = self.tabPane.getWidgetByName("USERINFOGRID");
                            //ɾû
                            FR.Msg.confirm(FR.i18nText("FS-User-Delete_User"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                                if (result) {
                                    FS.Trans.removeUser(item.id);
                                    userTable.refresh();
                                }
                            });
                        }
                    });
                    return delBtn.element;
                }
            });
        }
        var cfg = {
            type: 'quickgrid',
            page: true,
            autoPage: false,
            pageCount: 10,
            multiSelect: !self.isSyncOn,
            intervalColor: true,
            marginLeft: 10,
            marginRight: 10,
            widgetName: 'USERINFOGRID',
            async: {
                url: FR.servletURL + "?op=fs_set&cmd=auth_getalluserinfo",
                data: {
                    startIdx: 0,
                    count: 10
                }
            },
            onPageTurn: function (active, count, nav) {
                var async = this.options.async;
                async.data.startIdx = (active - 1) * count;
                this.refresh();
            },
            onAsyncSuccess: function (res, status) {
                var result = FR.jsonDecode(res);
                this.options.items = result.users;
                this.totalpages = Math.ceil(result.total / 10);
            },
            columnsConfig: colcfg
        };
        return cfg;
    },
    /**
     * û룬ͬݼúûݱֶѡ
     * ֻƽ̨֤ʱûֻûźְλͬʱѡͬʱѡ
     * @param username ûֶ
     * @param realname ֶ
     * @param password ֶ
     * @param depart ֶ
     * @param post ְλֶ
     * @returns {boolean} Ƿ
     */
    checkUserValid: function (username, realname, password, depart, post) {
        if (FR.isEmpty(username)) {
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-User_Can_Not_Be_Null"));
            return false;
        }
        if (FR.isEmpty(realname)) {
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Admin-Name_Can_Not_Be_Null"));
            return false;
        }
        if (this.isAuthDefault() && FR.isEmpty(password)) {
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Admin-Password_Can_Not_Be_Null"));
            return false;
        }
        if (FR.isEmpty(post) && !FR.isEmpty(depart) || !FR.isEmpty(post) && FR.isEmpty(depart)) {
            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Depart_Post_Together"));
            return false;
        }
        return true;
    },

    /**
     * ûԻ
     */
    createUserImportDialog: function () {
        var self = this;
        var encryptCfg = FS.Trans.ajax({
            url: FR.servletURL + "?op=fs_manager&cmd=gethsqlpv"
        });
        var importDialog = new FR.Dialog({
            title: FR.i18nText("FS-Generic-Import_2") + FR.i18nText("FS-Generic-Simple_User"),
            width: 350,
            height: 430,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'tablepane',
                colSize: [350],
                rowSize: [10, 350],
                items: [
                    [{}], [self.getUserImportConfig()]
                ]
            },
            closeAfterAction: false,
            destroyOnClose: true,
            onOK: function () {
                var data = self.getDSWidgetData(importDialog);
                if (!data) {
                    return false;
                }
                self.doImportUsers({res: data});
                importDialog.doClose();
            },
            onCancel: function () {
                this.doClose();
            }
        });
        if (!self.isAuthDefault()) {
            importDialog.getWidgetByName("passwordCombo").setEnable(false);
            importDialog.getWidgetByName("encryptionCombo").setEnable(false);
        }
        this.popEncryptSet(importDialog, encryptCfg);
        return importDialog;
    },

    /**
     * ܷʽǷı(û)
     * @param oldEncrypt ɼܷʽ
     * @param newEncrypt ¼ܷʽ
     * @returns {boolean} ؼܷʽǷı
     */
    hasEncryptChanged: function (oldEncrypt, newEncrypt) {
        if (oldEncrypt.encrypt != newEncrypt.encrypt) {
            return true;
        } else if (newEncrypt.encrypt === 1 && oldEncrypt.myencrypt != newEncrypt.myencrypt) {
            return true;
        }
        return false;
    },

    doImportUsers: function (data) {
        var self = this,
            usergrid = this.tabPane.getWidgetByName("USERINFOGRID");
        var $loading = this._createLoading();
        $loading.appendTo(this.mainPane);
        FR.ajax({
            url: FR.servletURL + "?op=fs_manager&cmd=importUser",
            data: data,
            complete: function (res, status) {
                if (status == 'success') {
                    var importres = FR.jsonDecode(res.responseText);
                    if (importres.query) {
                        FR.Msg.confirm(FR.i18nText("FS-Generic-Simple_Warning"), importres.query + '?',
                            function (result) {
                                if (result) {
                                    data.clearall = true;
                                    self.doImportUsers(data);
                                }
                                $loading.remove();
                            });
                        return;
                    }
                    if (importres.hasDuplicated) {
                        FR.Msg.confirm(FR.i18nText("FS-Generic-Simple_Warning"), importres.warnings + '?',
                            function (result) {
                                if (result) {
                                    self.addDuplicatedUsers($loading);
                                } else {
                                    usergrid.refresh();
                                    $loading.remove();
                                }
                            });
                    } else {
                        usergrid.refresh();
                        $loading.remove();
                    }
                } else {
                    $loading.remove();
                }
            }
        });
    },

    _createLoading: function () {
        var $loading = $('<div class="fs-usermgr-loading"/>');
        return $loading;
    },
    /**
     * û
     * @returns {*}
     */
    getUserImportConfig: function () {
        var self = this;
        //ʾϢ
        var $tip = $('<div class="fs-usermgr-tip-icon"></div>').click(
            function () {
                var $tipContext = $('<div class="fs-usermgr-tip-context">' +
                FR.i18nText("FS-User-Sync_Dataset_Config_Tip") +
                '</div>');
                var left = $(this).offset().left + $(this).width();
                var top = $(this).offset().top + $(this).height();
                $tipContext.appendTo($('body')).css({
                    position: 'absolute',
                    left: left,
                    top: top,
                    'z-index': FR.widget.opts.zIndex++
                });
                $(document).bind('mousedown.tip', $tipContext, function (e) {
                    var target = e.target;
                    if (!$(target).isChildAndSelfOf('div.fs-usermgr-tip-context')) {
                        $tipContext.remove();
                        $(document).unbind('mousedown.tip');
                    }
                });
            }
        );
        return {
            type: 'tablepane',
            widgetName: 'userAuthTable',
            colSize: [110, 10, 150, 6],
            rowSize: [21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21],
            vgap: 11,
            items: [
                [
                    {
                        type: 'llabel',
                        value: '*' + FR.i18nText("FS-Generic-DS_Server_TableData"),
                        textalign: 'right'
                    }, {},
                    self.getTableDataComboCfg(), $('<div/>').append($tip)
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-Generic-Simple_Username"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'usernameCombo', items: []}
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-Admin-Full_Name"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'fullnameCombo', items: []}
                ], [
                    {type: 'llabel', value: '*' + FR.i18nText("FS-Generic-Simple_Password"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'passwordCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Encryption_Mode"), textalign: 'right'}, {},
                    self.createEncrypComboCfg()
                ], [
                    {}, {}, {type: 'text', widgetName: 'customEncrypText'}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Simple_Department"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'departmentCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-User-Simple_Position"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'positionCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Role"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'roleCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Email"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'emailCombo', items: []}
                ], [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Mobile_Phone"), textalign: 'right'}, {},
                    {type: 'combo', widgetName: 'mobilephoneCombo', items: []}
                ]
            ]
        };
    },
    /**
     * ɷݼϢ
     * @returns {*}
     */
    getTableDataComboCfg: function () {
        var self = this;
        return {
            type: 'combo',
            widgetName: 'tableDataCombo',
            widgetUrl: FR.servletURL + "?op=fs_manager&cmd=fs_get_servertabledata",
            listeners: [
                {
                    eventName: FR.Events.AFTEREDIT,
                    action: function () {
                        var ds = this.getValue();
                        self.rebuildDSWidgets(ds, this);
                    }
                }
            ]
        }
    },

    /**
     * ȡݼпؼֵ
     * @param pw 
     * @returns {*}
     */
    getDSWidgetData: function (pw) {
        var self = this;
        var username = pw.getWidgetByName("usernameCombo").getValue(),
            name = pw.getWidgetByName("fullnameCombo").getValue(),
            password = pw.getWidgetByName("passwordCombo").getValue(),
            department = pw.getWidgetByName("departmentCombo").getValue(),
            post = pw.getWidgetByName("positionCombo").getValue(),
            role = pw.getWidgetByName("roleCombo").getValue(),
            mobile = pw.getWidgetByName("mobilephoneCombo").getValue(),
            email = pw.getWidgetByName("emailCombo").getValue();
        if (!this.checkUserValid(username, name, password, department, post)) {
            return null;
        }
        var res = {
            dsName: pw.getWidgetByName("tableDataCombo").getValue(),
            userName: FR.isEmpty(username) ? -1 : username,
            name: FR.isEmpty(name) ? -1 : name,
            password: FR.isEmpty(password) ? -1 : password,
            department: FR.isEmpty(department) ? -1 : department,
            post: FR.isEmpty(post) ? -1 : post,
            role: FR.isEmpty(role) ? -1 : role,
            mobile: FR.isEmpty(mobile) ? -1 : mobile,
            email: FR.isEmpty(email) ? -1 : email,
            encrypt: pw.getWidgetByName("encryptionCombo").getValue()
        };
        if (res.encrypt === 1) {
            res.myencrypt = pw.getWidgetByName("customEncrypText").getValue();
        }
        if (!res.encrypt) {
            res.encrypt = 0;
        }
        return res;
    },
    /**
     * ÷ݼֶѡؼ
     * @param ds ݼ
     * @param pw 
     */
    rebuildDSWidgets: function (ds, pw) {
        var cols = [];
        if (!FR.isEmpty(ds)) {
            cols = FS.Tools.getColsByTableDataName(ds);
        }
        var widgetNames = ["usernameCombo", "passwordCombo", "fullnameCombo", "departmentCombo",
            "positionCombo", "emailCombo", "mobilephoneCombo", "roleCombo"];
        for (var i = 0; i < 8; i++) {
            var widget = pw.getWidgetByName(widgetNames[i]);
            widget.options.renderEl = widget.element;
            widget.rebuild(cols);
        }
    },

    /**
     * ɼϢ
     * @returns {*}
     */
    createEncrypComboCfg: function () {
        return {
            type: 'combo',
            widgetName: 'encryptionCombo',
            allowBlank: true,
            value: 0,
            items: [
                {text: FR.i18nText("FS-User-No_Encryption"), value: 0},
                {text: FR.i18nText("FS-User-Custom_Encryption"), value: 1},
                {text: FR.i18nText("FS-User-MD5_Encryption"), value: 2}
            ],
            listeners: [
                {
                    eventName: FR.Events.AFTEREDIT,
                    action: function () {
                        var val = this.getValue();
                        var table = this.getWidgetByName("userAuthTable");
                        if (val === 1) {
                            table.setRowVisible([5], true);
                        } else {
                            table.setRowVisible([5], false);
                        }
                    }
                }
            ]
        }
    },
    /**
     * ǵû
     */
    addDuplicatedUsers: function ($loading) {
        var self = this;
        FR.ajax({
            url: FR.servletURL + "?op=fs_manager&cmd=importUser",
            data: {
                override: true
            },
            complete: function (res, status) {
                if (status == 'success') {
                    if (res.success) {
                        //ɹ
                        self.tabPane.getWidgetByName("USERINFOGRID").refresh();
                    }
                }
                $loading.remove();
            }
        });
    },
    /************Ź*************/
    institutionModule: function () {
        var self = this, isSyncOn = this.isSyncOn;
        var filter = function (parentNode, node, newNodes, result, open) {
            if (!newNodes) {
                return null;
            }
            if (!result) {
                result = [];
            }
            for (var i = 0, l = newNodes.length; i < l; i++) {
                var item = newNodes[i];
                var zItem = {};
                zItem.name = item.text;
                if (item.ChildNodes && item.ChildNodes.length > 0) {
                    filter(item, node, item.ChildNodes, result, false);
                }
                zItem.id = item.id;
                zItem.pId = item.parentID || item.parentId;
                zItem.type = item.type;
                zItem.description = item.description;
                zItem.open = (open === false ? open : true);
                if (self._alreadyExists(zItem.id, result)) {
                    continue;
                }
                result.push(zItem);
            }
            return result;
        };
        var paneWidth = 230, paneHeight = 375,
            dpadd = null, dpedit = null,
            postedit = null, postdel = null,
            useredit = null, userdel = null;
        if (!isSyncOn) {
            dpadd = this._createDpmgrTool();
            dpedit = this._createDptreeTool();
            postedit = this._createPostTool();
            useredit = this._createUserTool();
        }
        var config = {
            title: FR.i18nText("FS-Generic-Simple_Institution"),
            content: {
                type: 'panel',
                width: 800,
                height: 510,
                doSize: true,
                contentWidget: {
                    type: 'absolute',
                    widgetName: 'INSTITUTLAYOUT',
                    items: [
                        //Ź
                        {
                            el: {
                                type: "panel",
                                width: paneWidth,
                                height: paneHeight,
                                title: FR.i18nText("FS-User-Department_Management"),
                                border: true,
                                doSize: true,
                                tools: dpadd,
                                contentWidget: {
                                    type: 'fstabletree',
                                    widgetName: 'DEPARTMENTTABLETREE',
                                    treeID: 'fsUserDepartmentTableTree',
                                    height: '100%',
                                    width: '100%',
                                    alwaysShowTools: false,
                                    toolMargin: 0,
                                    itemHoverCls: 'fs-usermgr-tabletree-item-hover',
                                    setting: {
                                        view: {
                                            showIcon: false  //ʾÿڵǰICON
                                        },
                                        data: {
                                            simpleData: {
                                                enable: true,
                                                idKey: "id",
                                                pidKey: "pId",
                                                rootPId: "-2"
                                            }
                                        },
                                        async: {
                                            enable: true,
                                            url: FR.servletURL + "?op=fs_set&cmd=auth_getspecialdepart",
                                            dataFilter: filter
                                        },
                                        callback: {
                                            onClick: function (e, treeId, treeNode) {
                                                //ѡʾµְλб
                                                var nodeid = treeNode.id,
                                                    postlist = self.tabPane.getWidgetByName("POSTLIST"),
                                                    userlist = self.tabPane.getWidgetByName("USERLIST");
                                                userlist.clear();
                                                postlist.refresh({
                                                    async: {
                                                        url: FR.servletURL + "?op=fs_set&cmd=auth_getjrole_post",
                                                        data: {departid: nodeid}
                                                    }
                                                });
                                            }
                                        }
                                    },
                                    tools: dpedit
                                }
                            }, x: 0, y: 0
                        },
                        //ְλ
                        {
                            el: {
                                type: "panel",
                                title: FR.i18nText("FS-User-Post_Management"),
                                border: true,
                                width: paneWidth,
                                height: paneHeight,
                                tools: postedit,
                                contentWidget: {
                                    type: 'quicklist',
                                    widgetName: "POSTLIST",
                                    height: '100%',
                                    alwaysShowTools: false,
                                    itemCanBeSelect: true,
                                    showField: 'postName',
                                    valueField: 'postId',
                                    tools: isSyncOn ? null : [
                                        {
                                            iconCls: 'fs-module-delete-white',
                                            iconCls4Hover: 'fs-module-delete-white-hover'
                                        }
                                    ],
                                    onItemToolClick: function (toolindex, index) {
                                        //ɾְλ
                                        var depart = self.tabPane.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
                                        var postlist = self.tabPane.getWidgetByName("POSTLIST");
                                        var userlist = self.tabPane.getWidgetByName("USERLIST");
                                        if (!depart) {
                                            return;
                                        }
                                        FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                                            if (result) {
                                                FR.ajax({
                                                    url: FR.servletURL + "?op=fs_set&cmd=auth_removejrole_post",
                                                    data: {
                                                        departid: depart.id,
                                                        postid: postlist.getValueAtIndex(index)
                                                    },
                                                    type: 'POST',
                                                    complete: function (res, status) {
                                                        if (status == 'success') {
                                                            var re = FR.jsonDecode(res.responseText);
                                                            if (re.success) {
                                                                userlist.clear();
                                                                userlist.element.data('users', null);
                                                                postlist.remove(index);
                                                            }
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    },
                                    onItemSelect: function () {
                                        var data = self._getPostAndDepart();
                                        var userlist = self.tabPane.getWidgetByName("USERLIST");
                                        if (!data) {
                                            return;
                                        }
                                        userlist.refresh({
                                            async: {
                                                url: FR.servletURL + "?op=fs_set&cmd=auth_getallemployee",
                                                data: data
                                            }
                                        });
                                    }

                                }
                            }, x: 270, y: 0
                        },
                        //Ա
                        {
                            el: {
                                type: "panel",
                                width: paneWidth,
                                height: paneHeight,
                                title: FR.i18nText("FS-User-Personnel_Management"),
                                border: true,
                                tools: useredit,
                                contentWidget: {
                                    type: 'quicklist',
                                    widgetName: 'USERLIST',
                                    scrollLoading: true,
                                    height: '100%',
                                    alwaysShowTools: false,
                                    itemCanBeSelect: true,
                                    onAsyncSuccess: function (items) {
                                        this.element.data("users", items);
                                    },
                                    dataFilter: function (item) {
                                        return {
                                            text: (item.realname || "") + '(' + item.username + ')',
                                            value: item.userid
                                        }
                                    },
                                    tools: isSyncOn ? null : [
                                        {
                                            iconCls: 'fs-module-delete-white',
                                            iconCls4Hover: 'fs-module-delete-white-hover'
                                        }
                                    ],
                                    onItemToolClick: function (toolindex, index) {
                                        var userlist = self.tabPane.getWidgetByName("USERLIST");
                                        //ɾԱ
                                        FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                                            if (result) {
                                                var users = userlist.element.data("users");
                                                var uid = users[index].id;
                                                var data = self._getPostAndDepart();
                                                FR.ajax({
                                                    data: {
                                                        userid: uid,
                                                        departid: data.departid,
                                                        postid: data.postid
                                                    },
                                                    url: FR.servletURL + "?op=fs_set&cmd=auth_removeemployee",
                                                    type: 'POST',
                                                    complete: function (res, status) {
                                                        if (status == 'success') {
                                                            var re = FR.jsonDecode(res.responseText);
                                                            if (re.success) {
                                                                userlist.remove(index);
                                                                users.splice(index, 1);
                                                                userlist.element.data("users", users);
                                                            }
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }
                            }, x: 540, y: 0
                        }
                    ]
                }
            }
        };
        return config;
    },
    /**
     * ŹPanelӰť
     */
    _createDpmgrTool: function () {
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-add-white',
                width: 24,
                height: 24,
                handler: function () {
                    //Ӳ
                    var selecteDepart = self.tabPane.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
                    if (!selecteDepart) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Do_Select_Department"));
                        return;
                    }
                    FR.Msg.prompt(FR.i18nText("FS-User-Add_Department"), FR.i18nText("FS-User-Department_Name"), "",
                        function (value) {
                            if (value) {
                                if (value.length > 0) {
                                    var departid = selecteDepart.id;
                                    var result = FS.Trans.addDepart({parentID: departid, text: value});
                                    if (result.success) {
                                        var node = {
                                            id: result.id,
                                            name: value,
                                            pId: departid,
                                            open: true
                                        };
                                        self.tabPane.getWidgetByName("DEPARTMENTTABLETREE").addNodes(selecteDepart, node, true);
                                    } else {
                                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Same_Department"));
                                        return false;
                                    }
                                } else {
                                    // Ϊ
                                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Empty_Department"));
                                    return false;
                                }
                            }
                        },
                        225
                    );
                }
            }
        ];
        return cfg;
    },

    /**
     * ŹTabletree༭ɾ
     * @private
     */
    _createDptreeTool: function () {
        var self = this;
        var cfg = [
            {
                rootToolHide: true,
                iconCls: 'fs-module-edit-white',
                hoverCls: 'fs-module-edit-white-over',
                //༭ť¼
                onToolClick: function (e) {
                    var nodeID = $(this).data('nodeID');
                    var departTT = self.tabPane.getWidgetByName("DEPARTMENTTABLETREE");
                    var preDeleteNode = departTT.getNodeById(nodeID);
                    departTT.selectNode(preDeleteNode);
                    FR.Msg.prompt(FR.i18nText("FS-User-Edit_Department"),
                        FR.i18nText("FS-User-Department_Name"),
                        preDeleteNode.name,
                        function (value) {
                            if (value) {
                                var selecteDepart = departTT.getSelectedNodes()[0];
                                var departid = selecteDepart.id;
                                var result = FS.Trans.addDepart({id: departid, text: value});
                                if (result.success) {
                                    selecteDepart.name = value;
                                    departTT.updateNode(selecteDepart);
                                } else {
                                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Same_Department"));
                                }
                            }
                        },
                        225);
                    e.stopEvent();
                }
            },
            {
                rootToolHide: true,
                iconCls: 'fs-module-delete-white',
                hoverCls: 'fs-module-delete-white-hover',
                //ɾť¼
                onToolClick: function (e) {
                    var nodeID = $(this).data('nodeID');
                    var departTT = self.tabPane.getWidgetByName("DEPARTMENTTABLETREE");
                    var preDeleteNode = departTT.getNodeById(nodeID);
                    departTT.selectNode(preDeleteNode);
                    FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + '?', function (result) {
                        if (result) {
                            //̨ɾݣɹwebɾ
                            var departmentId = departTT.getSelectedNodes()[0].id;
                            FS.Trans.removeDepart(departmentId);
                            departTT.removeSelectedNodes();
                        }
                    });
                    e.stopEvent();
                }
            }
        ];
        return cfg;
    },

    /**
     * ְλб༭ť
     * @private
     */
    _createPostTool: function () {
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-edit-white',
                width: 24,
                height: 24,
                handler: function () {
                    self._createPostEditDialog();
                }
            }
        ];
        return cfg;
    },

    /**
     * Աб༭ť
     * @private
     */
    _createUserTool: function () {
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-edit-white',
                width: 24,
                height: 24,
                handler: function () {
                    var dp = self._getPostAndDepart();
                    //û
                    self._createUserDialog(dp);
                }
            }
        ];
        return cfg;
    },
    /**
     * Ӻͱ༭ְλĶԻ
     * @private
     */
    _createPostEditDialog: function () {
        var self = this;
        var depart = this.tabPane.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
        if (!depart) {
            return;
        }
        var departid = depart.id;
        var postlist = this.tabPane.getWidgetByName("POSTLIST");
        var toAddList = [], toDelList = [];
        var dialog = new FR.Dialog({
            confirm: true,
            needSeparate: 8,
            height: 450,
            width: 300,
            title: FR.i18nText("FS-User-Post_Management"),
            destroyOnClose: true,
            onOK: function () {
                var delResult = true, addResult = true;
                if (toDelList.length) {
                    var re = FS.Trans.removePostsFromDepart({
                        departid: departid,
                        postid: toDelList.join(',')
                    });
                    delResult = re.success;
                }
                if (toAddList.length) {
                    var re = FS.Trans.addPostsToDepart({
                        departid: departid,
                        postid: toAddList.join(',')
                    });
                    addResult = re.success;
                }
                if (addResult && delResult) {
                    postlist.refresh();
                } else {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                }
            },
            contentWidget: {
                type: 'border',
                items: [
                    {
                        region: 'north',
                        height: 1,
                        el: $('<div/>')
                    },
                    {
                        region: 'center',
                        el: {
                            type: 'search',
                            autoSearch: true,
                            widgetName: 'POSTNAMETEXT',
                            onKeyup: function (e) {
                                var val = this.getValue(), data = {departid: depart.id};
                                if (val) {
                                    data.keyword = val;
                                }
                                var allpost = dialog.getWidgetByName('ALLPOSTLIST');
                                if (!FR.isNavKeyPress(e)) {
                                    setTimeout(function () {
                                        allpost.clear();
                                        allpost.refresh({
                                            async: {
                                                url: FR.servletURL + "?op=fs_set&cmd=auth_getfilterposts",
                                                data: data
                                            }
                                        });
                                    }, 100);
                                }
                            }
                        }
                    },
                    {
                        region: 'west',
                        width: 1,
                        el: $('<div/>')
                    },
                    {
                        region: 'east',
                        width: 24,
                        el: {
                            type: 'iconbutton',
                            widgetName: 'POSTADDBTN',
                            imgsrc: 'fs-usermgr-add-blue',
                            handler: function () {
                                //ְλбְλ
                                var newpost = dialog.getWidgetByName("POSTNAMETEXT").getValue();
                                if (!newpost) {
                                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Position_Can_Not_Be_Null"));
                                    return;
                                }
                                var id = FS.Trans.addPost({postname: newpost});
                                if (id > 0) {
                                    dialog.getWidgetByName("ALLPOSTLIST").addItem({
                                        text: newpost,
                                        id: id
                                    });
                                } else {
                                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-User-Add_Position_Failure"));
                                }
                            }
                        }
                    },
                    {
                        region: 'south',
                        height: 342,
                        el: {
                            type: 'quicklist',
                            widgetName: 'ALLPOSTLIST',
                            alwaysShowTools: false,
                            itemCanBeSelect: true,
                            paddingLeft: 0,
                            valueField: 'id',
                            async: {
                                url: FR.servletURL + "?op=fs_set&cmd=auth_getfilterposts",
                                data: {departid: departid}
                            },
                            tools: [
                                {
                                    iconCls: 'fs-module-delete-white',
                                    iconCls4Hover: 'fs-module-delete-white-hover'
                                }
                            ],
                            onBeforeItemCreate: function (element, options) {
                                var $check = new FR.CheckBox({
                                    renderEl: element,
                                    height: this.options.height,
                                    value: options.inDepart ? true : false,
                                    listeners: [{
                                        eventName: FR.Events.STATECHANGE,
                                        action: function () {
                                            var id = options.id;
                                            if (this.getValue()) {
                                                if (toDelList.length === toDelList.remove(id).length) {
                                                    toAddList.push(id);
                                                }
                                            } else {
                                                if (toAddList.length === toAddList.remove(id).length) {
                                                    toDelList.push(id);
                                                }
                                            }
                                        }
                                    }]
                                });
                            },
                            onItemToolClick: function (toolindex, index) {
                                var allpostlist = dialog.getWidgetByName('ALLPOSTLIST');
                                var selpost = allpostlist.getValueAtIndex(index);
                                if (!selpost) {
                                    return;
                                }
                                //ɾְλ
                                FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                                    if (result) {
                                        FR.ajax({
                                            url: FR.servletURL + "?op=fs_set&cmd=auth_removepost",
                                            data: {
                                                id: selpost
                                            },
                                            type: 'POST',
                                            complete: function (res, status) {
                                                if (status == 'success') {
                                                    var re = FR.jsonDecode(res.responseText);
                                                    if (re.success) {
                                                        toAddList.remove(selpost)
                                                        allpostlist.remove(index);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }
                ]
            }
        });
        dialog.setVisible(true);
    },

    /**
     * ӺɾûĶԻ
     * @param data ʼ
     * @private
     */
    _createUserDialog: function (data) {
        var self = this;
        var $userOptPane = FS.Tools.createUserOptPane(data),
            userlist = this.tabPane.getWidgetByName('USERLIST');
        var userDialog = new FR.Dialog({
            confirm: true,
            title: FR.i18nText("FS-User-Personnel_Management"),
            width: 550,
            height: 445,
            doSize: true,
            destroyOnClose: true,
            contentWidget: {
                type: 'absolute',
                widgetName: 'USERABSOLUTE',
                items: [
                    {
                        el: {
                            type: 'label',
                            widgetName: 'POSTNAME',
                            wrap: false,
                            fontsize: 14,
                            color: '#676767',
                            width: 220,
                            value: data.departname + '-' + data.postname,
                            title: data.departname + '-' + data.postname,
                            height: 21
                        }, x: 15, y: 12
                    },
                    {
                        el: {
                            type: 'search',
                            width: 230,
                            autoSearch: true,
                            onKeyup: function (e) {
                                if (self.filerid != null) {
                                    clearTimeout(self.filerid);
                                    self.filerid = null;
                                }
                                if (!FR.isNavKeyPress(e)) {
                                    var val = this.getValue();
                                    var dp = {
                                        departid: data.departid,
                                        postid: data.postid
                                    };
                                    if (val) {
                                        dp.keyword = val;
                                    }
                                    self.filerid = setTimeout(function () {
                                        $userOptPane.refresh(dp, $userOptPane.seluser, $userOptPane.alluser, function () {
                                            $userOptPane.seluser.empty();
                                            $userOptPane.alluser.empty();
                                        });
                                    }, 200);
                                }
                            }
                        }, x: 300, y: 10
                    },
                    {el: $userOptPane, x: 15, y: 50}
                ]
            },
            onOK: function () {
                var addids = $userOptPane.getAddlist, delids = $userOptPane.getDellist;
                //Ա
                if (addids.length) {
                    FS.Trans.addEmployee({
                        userid: addids.join(','),
                        departid: data.departid,
                        postid: data.postid
                    })
                }
                //ɾԱ
                if (delids.length) {
                    FS.Trans.removeEmployee({
                        userid: delids.join(','),
                        departid: data.departid,
                        postid: data.postid
                    });
                }
                userlist.refresh({
                    async: {
                        url: FR.servletURL + "?op=fs_set&cmd=auth_getallemployee",
                        data: data
                    }
                });
            }
        });
        userDialog.setVisible(true);
    },

    /**
     * ȡѡеĲźְλ
     * @returns {*}
     * @private
     */
    _getPostAndDepart: function () {
        var depart = this.tabPane.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0],
            post = this.tabPane.getWidgetByName("POSTLIST");
        if (depart && post) {
            return {
                departname: depart.name,
                departid: depart.id,
                postid: post.getValue(),
                postname: post.getText()
            }
        } else {
            return null
        }
    },

    _alreadyExists: function (id, result) {
        for (var i = 0; i < result.length; i++) {
            if (result[i].id === id) {
                return true;
            }
        }
        return false;
    },

    /**
     * û¼
     */
    userLimitTabConfig : function(){
        var self = this;
        return {
            title : FR.i18nText("FS-User-Platform_User_Management"),
            content : {
                type : 'panel',
                widgetName: FSUM.Constants.userLimitConfigPanelWD,
                doSize : true,
                width : 650,
                height : 460,
                closeAfterAction: false,
                contentWidget : {
                    type : 'tablepane',
                    widgetName: FSUM.Constants.userLimitConfigTableWD,
                    colSize: [270, 18, 44, 18, 'fill'],
                    rowSize: [24, 420],
                    scrollable: true,
                    vgap: 8,
                    items: [
                        [
                            null, null, null, null, self._createUserLimitTip()
                        ], [
                            self._createUserPanel(false),
                            {}, self._createUserAuthButtons(),
                            {}, self._createUserPanel(true)
                        ]
                    ]
                }
            }
        }
    },

    _createUserLimitTip: function() {
        return $('<div/>').addClass("fs-user-limit-tip").append(
            $('<span/>').text(FR.i18nText("FS-User-User_Limit_Tip_Left") + " "
                + FS.config.userLimit + " " + FR.i18nText("FS-User-User_Limit_Tip_Right")
            )
        );
    },

    _createUserPanel: function (isAuthorizedList) {
        var self = this;
        var userPanelOptions = isAuthorizedList ? {
            panelWidgetName: FSUM.Constants.userLimitUnauthorizedPanelWD,
            panelTitle: FR.i18nText("FS-User-Authorized_Users"),
            listWidgetName:  FSUM.Constants.userLimitAuthorizedListWD,
            listPanelWidgetName: FSUM.Constants.userLimitAuthorizedListPanelWD,
            listUrl: FR.servletURL + "?op=fs_set&cmd=auth_getall_loginusers&type=fs"
        } : {
            panelWidgetName: FSUM.Constants.userLimitAuthorizedPanelWD,
            panelTitle: FR.i18nText("FS-User-Unauthorized_Users"),
            listWidgetName: FSUM.Constants.userLimitUnauthorizedListWD,
            listPanelWidgetName: FSUM.Constants.userLimitUnauthorizedListPanelWD,
            listUrl: FR.servletURL + "?op=fs_set&cmd=auth_getallusers&exclude=fs_login"
        };
        var searchFunc = function(e){
            if (self.searchId != null) {
                clearTimeout(self.searchId);
                self.searchId = null;
            }
            self.searchId = setTimeout(function () {
                if (!FR.isNavKeyPress(e)) {
                    var val = this.getValue();
                    var userList = self.tabPane.getWidgetByName(userPanelOptions.listWidgetName);
                    userList.refresh({
                        async: {
                            url: userPanelOptions.listUrl,
                            data: {
                                dataFilter: val
                            }
                        }
                    });
                }
            }.createDelegate(this), 200);
        };
        var items = [
            [{
                type: 'search',
                width: 268,
                autoSearch: true,
                onKeyup: searchFunc
            }],
            [{
                type: 'panel',
                widgetName: userPanelOptions.listPanelWidgetName,
                width: 268,
                height: 346,
                doSize: true,
                contentWidget: {
                    type: 'quicklist',
                    width: 268,
                    fit: false,
                    scrollLoading: true,
                    widgetName: userPanelOptions.listWidgetName,
                    async: {
                        url: userPanelOptions.listUrl
                    },
                    dataFilter: function (user) {
                        return {
                            text: (user.realname || "") + '(' + user.username + ')',
                            value: user.username,
                            realname: user.realname
                        }
                    },
                    itemCanBeSelect: true,
                    onItemSelect: function () {
                        self.setAuthButtonStatus();
                    }
                }
            }]
        ];
        return {
            type: 'panel',
            fit: false,
            title: userPanelOptions.panelTitle,
            width: 270,
            height: 375,
            widgetName: userPanelOptions.panelWidgetName,
            border: true,
            contentWidget: {
                type: 'tablepane',
                colSize: [270],
                rowSize: [28, 'fill'],
                items: items
            }
        }
    },

    _createUserAuthButtons: function () {
        var self = this;
        return {
            type: 'tablepane',
            colSize: ['fill'],
            rowSize: [148, 24, 30, 24, 'fill'],
            items: [
                [[]], [{
                    type: 'iconbutton',
                    widgetName: FSUM.Constants.userLimitAuthMoveRightButtonWD,
                    baseClass: 'fs-user-auth-move-right-icon',
                    imgsrc: 'fs-user-auth-move-right',
                    width: 44,
                    height: 24,
                    handler: function () {
                        var unauthorizedList = self.tabPane.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListWD);
                        var index = unauthorizedList.getSelectedIndex();
                        if (index == null) {
                            return;
                        }
                        self.setLoginUser(index, false);
                    }
                }], [[]], [{
                    type: 'iconbutton',
                    widgetName: FSUM.Constants.userLimitAuthMoveLeftButtonWD,
                    baseClass: 'fs-user-auth-move-left-icon',
                    imgsrc: 'fs-user-auth-move-left',
                    width: 44,
                    height: 24,
                    handler: function () {
                        var authorizedList = self.tabPane.getWidgetByName(FSUM.Constants.userLimitAuthorizedListWD);
                        var index = authorizedList.getSelectedIndex();
                        if (index === null) {
                            return;
                        }
                        self.setLoginUser(index, true);
                    }
                }], [[]]
            ]
        }
    },

    /**
     * ֧ƶ˷ûðť״̬
     */
    setAuthButtonStatus : function() {
        var pane = this.tabPane;
        var authorizedList = pane.getWidgetByName(FSUM.Constants.userLimitAuthorizedListWD),
            unauthorizedList = pane.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListWD);
        var moveLeftButton = pane.getWidgetByName(FSUM.Constants.userLimitAuthMoveLeftButtonWD),
            moveRightButton = pane.getWidgetByName(FSUM.Constants.userLimitAuthMoveRightButtonWD);
        var enableLeft = true,
            enableRight = true;
        enableLeft &= !FR.isNull(authorizedList.getSelectedIndex());
        enableLeft &= authorizedList.getItemLength() !== 0;
        moveLeftButton.setEnable(Boolean(enableLeft));
        enableRight &= !FR.isNull(unauthorizedList.getSelectedIndex());
        enableRight &= unauthorizedList.getItemLength() !== 0;
        enableRight &= authorizedList.getItemLength() < FS.config.userLimit;
        moveRightButton.setEnable(Boolean(enableRight));
    },

    /**
     * ƽ̨¼û
     * @param index бе˳
     * @param isRemove ǷΪƳ
     */
    setLoginUser : function (index, isRemove) {
        var self = this;
        var sourceList = isRemove ? this.tabPane.getWidgetByName(FSUM.Constants.userLimitAuthorizedListWD)
            : this.tabPane.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListWD);
        var targetList = isRemove ? this.tabPane.getWidgetByName(FSUM.Constants.userLimitUnauthorizedListWD)
            : this.tabPane.getWidgetByName(FSUM.Constants.userLimitAuthorizedListWD);
        var username = sourceList.getValue();
        var realname = sourceList.options.listItems[index].options.realname;
        var cmd = isRemove ? "auth_removeloginuser" : "auth_addloginuser";
        FR.ajax({
            url: FR.servletURL + "?op=fs_set&cmd=" + cmd + "&type=fs",
            type: "POST",
            data: {
                'username': username
            },
            complete: function(res, status) {
                if (status == "success") {
                    var success = FR.jsonDecode(res.responseText).success;
                    if (success) {
                        sourceList.remove(index);
                        targetList.addItem({
                            text: (realname || "") + '(' + username + ')',
                            value: username,
                            realname: realname
                        });
                        //ѡȡ
                        if (sourceList.getItemLength() === 0) {
                            index = -1;
                        } else if (index >= sourceList.getItemLength()) {
                            index = sourceList.getItemLength() - 1;
                        }
                        if (index !== -1) {
                            sourceList.selectItemByIndex(index);
                        }
                        self.setAuthButtonStatus();
                    }
                }
            }
        })
    }
};
