(function($){
    /**
     * Tabؼ
     *
     * @class FS.QuickTab
     * @extends FR.Widget
     * @since 8.0
     *
     * @cfg {String} baseCls        ؼ
     * @cfg {String} style          ؼʽ
     * @cfg {Number} tabWidth       Tab
     * @cfg {Number} tabHeight      Tab߶ȣĿǰݲִ֧
     * @cfg {Number} dropBoxWidth   Tabť
     * @cfg {Boolean} isCollapsible Ƿ
     * @cfg {String} hasHomepageBtn Ƿʾҳť
     *
     * @cfg {Function} onCreateTab      TabǩʱĲ޸ıǩʽ(ȫ)
     * @cfg {Function} onSelectTab      ѡÿTabҳʱĲ޸(ȫ)
     * @cfg {Function} onCloseTab       رÿTabҳʱĲ(ȫ)
     * @cfg {Function} afterLoadTab     ÿTabҳʱĲ(ȫ)
     */
    FS.QuickTab = FR.extend(FR.Widget, {
        NAV: {
            'BACK': 0,
            'MORE': 1,
            'ITEM': 2,
            'HOMEPAGE': 3,
            'MOREITEM': 4,
            'CLOSEALL': 5,
            'CLOSEOTHER': 6
        },

        _defaultConfig: function () {
            return $.extend(FS.QuickTab.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fs-tab',
                style: 'alpha',
                tabWidth: 150,
                tabHeight: 30,
                dropBoxWidth: 150,
                isCollapsible: true,
                hasHomepageBtn: false,
                onCreateTab: null,
                onSelectTab: null,
                onCloseTab: null,
                afterLoadTab: null
            });
        },

        _init: function () {
            FS.QuickTab.superclass._init.apply(this, arguments);
            this.element.addClass(this.options.style);
            // Ԫ
            this.$float = $('<div class="fs-tab-float"/>').css({
                'z-Index': FR.widget.opts.zIndex++
            }).appendTo(this.element);
            // Tabť
            this.$btns = this._createBtns();
            // 
            this.$contentMask = this._createContentMask().hide().appendTo(this.element);
            // 
            this.$content = $('<div class="fs-tab-content"/>').appendTo(this.element);
            // 浱ǰ tab ѼصĶӦ entry $tabs ˳һ
            this.loadedEntries = [];
            this._createHomepageBtn();
            this._bindBtnEvts();
            this.visibleTabCount = 0;
            this.currentTabWidth = this.options.tabWidth;
            this.dropdownLeft = Math.floor((this.options.tabWidth - this.options.dropBoxWidth) / 2);
            this.doResize();
            // չ״̬
            this.isExpand = true;
            if (this.options.isCollapsible === true) {
                this.setExpand(false);
                this.isExpand = false;
                this.element.hide();
            }
        },

        _resizeTabs: function(){
            var self = this;
            var width = this.element.width(),
                height = this.element.height();
            // Ӧtab
            var tabBarWidth = width - 40;
            // tabߴ
            if (this.options.isCollapsible) {
                tabBarWidth -= 60;
            }
            if (this.options.hasHomepageBtn) {
                tabBarWidth -= 60;
            }
            this.$tabs.width(tabBarWidth);
            var tabs = this.$tabs.children();
            // ֻ
            var visibleTabCount = Math.floor(tabBarWidth / this.options.tabWidth) + 1;
            var tabWidth = this.options.tabWidth;
            if (tabs.length >= visibleTabCount) {
                tabWidth = Math.floor(tabBarWidth / visibleTabCount);
            }
            this.visibleTabCount = visibleTabCount;
            // Ų
            if (tabWidth !== this.currentTabWidth) {
                this.dropdownLeft = Math.floor((tabWidth - this.options.dropBoxWidth) / 2);
                $.each(tabs, function (i, tab) {
                    $(tab).outerWidth(tabWidth);
                    // ı
                    $(".fs-tab-item-label", $(tab)).outerWidth(tabWidth-20);
                });
                this.currentTabWidth = tabWidth;
            }
            // 
            this.$content.width(width).height(height - this.options.tabHeight);
            // ԶԵǰѡбǩִ
            var $selectedTab = this._getSelectedTab();
            if ($selectedTab !== null) {
                this._doSelectTab($selectedTab)
            }
        },

        _createContentMask: function () {
            var self = this;
            return $('<div class="fs-tab-content-mask"/>').click(
                function (e) {
                    if (self._isMenuExpanded()) {
                        // Tab˵
                        self._expandMenu(false);
                        e.stopEvent();
                    }
                }).css({
                    'z-Index': FR.widget.opts.zIndex++
                });
        },

        _createBtns: function(){
            var self = this;
            var $btns = $('<div class="fs-tab-btns fui-seb"/>').appendTo(this.element);
            // Ŀ¼ť
            if (this.options.isCollapsible) {
                $('<div class="fs-tab-back fui-bsb nav-btn"/>')
                    .append($('<i class="icon-tab-dashboard"/>'))
                    .data('NAV', this.NAV.BACK)
                    .appendTo($btns);
            }
            // ҳ
            if (this.options.hasHomepageBtn) {
                $('<div class="fs-tab-homepage fui-seb nav-btn"/>')
                    .append($('<i class="icon-tab-home"/>'))
                    .data('NAV', this.NAV.HOMEPAGE)
                    .appendTo($btns);
            }
            // tabǩ
            this.$tabs = $('<ul class="fs-tab-names"/>')
                .appendTo($btns);
            //tabť
            $('<div class="fs-tab-more nav-btn"/>')
                .append($('<i class="icon-tab-menu"/>'))
                .data('NAV', this.NAV.MORE)
                .appendTo($btns);
            // ˵
            this.$menu = $('<div class="fs-tab-menu-wrapper fui-bcb lower"/>').css({
                'top': this.options.tabHeight
            }).hide().appendTo(this.$float);
            var menuOptions = $('<div class="fs-tab-menu-options">').appendTo(this.$menu);
            // ر
            $('<div class="fs-tab-menu-item nav-btn"/>').append(
                $('<span/>').text(FR.i18nText("FS-Frame-Close_All"))
            ).data('NAV', this.NAV.CLOSEALL).appendTo(menuOptions);
            // ر
            $('<div class="fs-tab-menu-item nav-btn"/>').append(
                $('<span/>').text(FR.i18nText("FS-Frame-Close_Other_Tabs"))
            ).data('NAV', this.NAV.CLOSEOTHER).appendTo(menuOptions);
            this.$menuItems = $('<ul class="fs-tab-menu-items"/>')
                .appendTo(this.$menu);
            return $btns;
        },

        _bindBtnEvts: function(){
            var NAV = this.NAV, self = this;
            var doProxy = function(event){
                var target = event.target;
                var type = event.type;
                var $obj = $(target).closest('.nav-btn');
                if ($obj && $obj.length > 0){
                    var navitype = $obj.data('NAV');
                    if (type === 'mouseover') {
                        switch (navitype){
                            case NAV.CLOSEALL:
                            case NAV.CLOSEOTHER:
                            case NAV.MOREITEM:
                                $obj.addClass('fui-fbc fui-bsb');
                                break;
                            default :break;
                        }
                        $('.icon-tab-close', $obj).show();
                    } else if (type === 'mouseout') {
                        switch (navitype){
                            case NAV.CLOSEALL:
                            case NAV.CLOSEOTHER:
                            case NAV.MOREITEM:
                                $obj.removeClass('fui-fbc fui-bsb');
                                break;
                            default :break;
                        }
                        $('.icon-tab-close', $obj).hide();
                    } else if (type === 'click') {
                        switch(navitype){
                            case NAV.BACK:
                                //
                                self.setExpand(!self.isExpanded());
                                self._expandMenu(false);
                                break;
                            case NAV.HOMEPAGE:
                                // ҳť
                                self.setExpand(true);
                                self._doSelectHomepage();
                                break;
                            case NAV.MOREITEM:
                            case NAV.ITEM:
                                //ָǩ
                                if ($obj.hasClass("fs-tab-menu-item")) {
                                    $obj = self._findLoadedTabFromEntry($obj.data('ENTRY'));
                                }
                                self._doSelectTab($obj);
                                self.setExpand(true);
                                self._expandMenu(false);
                                break;
                            case NAV.MORE:
                                //ǩ
                                self._expandMenu(true);
                                break;
                            case NAV.CLOSEALL:
                                //ر
                                self._doCloseAllTabs();
                                self._expandMenu(false);
                                break;
                            case NAV.CLOSEOTHER:
                                self._doCloseOtherTabs();
                                self._expandMenu(false);
                                break;
                            default: break;
                        }
                    }
                }
            };
            this.$btns.unbind();
            this.$btns.bind('click', doProxy)
                .bind('mouseover', doProxy)
                .bind('mouseout', doProxy);
            this.$float.unbind();
            this.$float.bind('click', doProxy)
                .bind('mouseover', doProxy)
                .bind('mouseout', doProxy);
        },

        _doSelectTab: function($tab){
            var idx = this._getTabIndex($tab);
            if (idx < 0) {
                return;
            }
            // ѡTabʱĲ
            var entry = this._getTabEntry($tab);
            var $content = $tab.data('CONTENT');
            if (FR.applyFunc(this, entry.onSelect, [$tab, $content, entry], false) === false) {
                FR.applyFunc(this, this.options.onSelectTab, [$tab, $content, entry], false);
            }
            // ص tab ƶʾһ
            var lastIndex = this.visibleTabCount - 1;
            if (idx > lastIndex) {
                this._moveTabByIndex(idx, lastIndex)
            }
            // ѡ״̬
            if (!$tab.hasClass('select')) {
                $('.select', this.$btns).removeClass('select fui-bsb');
                $tab.addClass('select fui-bsb');
            }
            // չʾ
            if ($content && $content.is(":hidden")) {
                $('.fs-tab-content-item', this.$content).hide();
                $content.show();
            }
            this._refreshMenu();
        },

        _doCloseTab: function ($tab) {
            var self = this;
            var idx = this._getTabIndex($tab);
            var $selectedTab = this._getSelectedTab();
            var selectedIdx = this._getTabIndex($selectedTab);
            var $content = $tab.data('CONTENT');
            if ($content) {
                // 鲢ȷǷرձǩҳ
                var entry = this._getTabEntry($tab);
                var doNotClose = FR.applyFunc(this, entry.onClose, [$tab, $content, entry], false);
                if (!doNotClose) {
                    doNotClose = FR.applyFunc(this, this.options.onCloseTab, [$tab, $content, entry], false);
                }
                // رձǩҳ
                if (!doNotClose && this._needToClose($content)) {
                    $content.detach();
                } else {
                    // δȷϹرգ
                    return;
                }

            }
            var callback = function () {
                // ƳTab
                var index = self._getTabIndex($tab);
                $tab.remove();
                self.loadedEntries.splice(index, 1);
                if (self.loadedEntries.length === 0) {
                    if (self.options.hasHomepageBtn) {
                        // ѡҳ
                        self._doSelectHomepage();
                    } else {
                        // ûпѡTabʱ
                        var hideFn = function () {
                            if (self.loadedEntries.length === 0) {
                                self.element.hide();
                            }
                        };
                        self.setExpand(false, hideFn)
                    }
                }
                self._refreshMenu();
            };
            // Ƴť
            $(".fs-tab-item-dropdown-wrapper", self.$float).remove();
            // ִйرղ
            $tab.animate({
                width: '-=' + this.options.tabWidth
            }, 'fast', callback);

            // ѡTab
            var $target = null;
            if (idx !== selectedIdx) {
                // ֮ǰѡеTab
                $target = $selectedTab;
            } else if (idx + 1 < this.loadedEntries.length) {
                // пѡTab
                $target = this._getTabByIndex(idx + 1)
            } else {
                // ǰһTab
                $target = this._getTabByIndex(this.loadedEntries.length - 2);
            }
            this._doSelectTab($target);
        },

        _needToClose: function (frame) {
            if (frame.length > 0 && frame[0].contentWindow) {
                // ifame ֱӹر
                if (frame[0].nodeName === "IFRAME") {
                    return true;
                }
                var win = frame[0].contentWindow;
                var beforeUnload = win.onbeforeunload || (win.document && win.document.body.onbeforeunload);
                // رǰǩҳ
                if ($.isFunction(beforeUnload)) {
                    var info = beforeUnload.call();
                    if (info) {
                        var confirm = window.confirm(info + "\n" + FR.i18nText('FS-Frame-Sure_To_Leave'));
                        if (!confirm) {
                            return false;
                        }
                    }
                }
            }
            return true;
        },

        _doCloseAllTabs: function () {
            var self = this;
            $.each(this.$tabs.children(), function (index, tab) {
                self._doCloseTab($(tab));
            })
        },

        _doCloseOtherTabs: function () {
            var self = this;
            var $selected = this._getSelectedTab();
            $.each(this.$tabs.children(), function (index, tab) {
                if ($selected.context !== tab) {
                    self._doCloseTab($(tab));
                }
            })
        },

        _getSelectedTab: function () {
            var $tab = null;
            $.each(this.$tabs.children(), function (i, tab) {
                if ($(tab).hasClass('select')) {
                    $tab = $(tab);
                    return false;
                }
            });
            return $tab;
        },

        _getTabIndex: function ($tab) {
            if (FR.isNull($tab)) {
                return -1;
            }
            return $.inArray($tab.get(0), this.$tabs.children());
        },

        _getTabByIndex: function (idx) {
            return $(this.$tabs.children().get(idx));
        },

        _getTabEntry: function ($tab) {
            return this.loadedEntries[this._getTabIndex($tab)];
        },

        _moveTabByIndex: function (from, to) {
            var tabs = this.$tabs.children();
            tabs.splice(to, 0, tabs.splice(from, 1)[0]);
            this.$tabs.append(tabs);
            this.loadedEntries.splice(to, 0, this.loadedEntries.splice(from, 1)[0]);
        },

        _addNewTabFromEntry: function(entry){
            var self = this;
            var $tab = $('<li class="fs-tab-item nav-btn"/>')
                .data('NAV', this.NAV.ITEM)
                .hover(function () {
                    $(".fs-tab-item-dropdown-wrapper", self.$float).remove();
                    if ($(this).hasClass('select') && self.isExpanded()) {
                        var wrapperOffset = {
                            top: self.options.tabHeight,
                            left: $(this).offset().left - self.element.offset().left
                        };
                        var $wrapper = self._createTabDropdownWrapper(entry).offset(wrapperOffset).appendTo(self.$float);
                        $wrapper.data('TAB', $(this))
                    }
                }, function () {

                }).appendTo(this.$tabs);
            $tab.outerWidth(this.currentTabWidth);
            var $label = $('<div class="fs-tab-item-label">').outerWidth(this.currentTabWidth-20).append(
                $('<span/>').text(entry.text).attr('title', entry.text)
            ).appendTo($tab);
            // رհť
            $('<i class="icon-tab-close"/>')
                .click(function (e) {
                    self._doCloseTab($(this).closest(".fs-tab-item"));
                    // ѡв
                    e.stopEvent();
                }).hide()
                .appendTo($label);
            if (FR.applyFunc(this, entry.onCreate, [$tab, entry], false) === false) {
                FR.applyFunc(this, this.options.onCreateTab, [$tab, entry], false);
            }
            // entryˢʹ
            this.loadedEntries.push(entry);
            this._resizeTabs();
            this._doSelectTab($tab);
            return $tab;
        },

        _createHomepageBtn: function () {
            var self = this;
            if (this.options.hasHomepageBtn) {
                var url = FS.config.homePageUrl;
                var $btn = $(".fs-tab-homepage.nav-btn", this.$btns);
                $btn.hover(function () {
                    $(".fs-tab-item-dropdown-wrapper", self.$float).remove();
                    if ($(this).hasClass('select') && self.isExpanded()) {
                        var wrapperOffset ={
                            top: self.options.tabHeight,
                            left: $(this).offset().left - self.element.offset().left - 45
                        };
                        var $wrapper = self._createTabDropdownWrapper().offset(wrapperOffset)
                            .addClass('homepage-drop').appendTo(self.$float);
                        $wrapper.data('TAB', $(this));
                    }
                }, function () {

                });
                $('.fs-tab-content-item', this.$content).hide();
                // ҳ
                this.setExpand(true, function(){
                    var $content;
                    if(FS.isPlatForm()){
                        $content = $('<div class="fs-tab-content-item platform-bg"/>')
                            .append($('<div class="platform-fg"/>')).appendTo(self.$content);
                    }else{
                        $content = $('<iframe class="fs-tab-content-item"/>').attr(
                            'src', encodeURI(FS.Trans._dealWithSrc(url))
                        ).appendTo(self.$content);
                    }
                    $btn.data('CONTENT', $content);
                    self._doSelectHomepage();
                });
            }
        },

        _doSelectHomepage: function () {
            var $btn = $(".fs-tab-homepage.nav-btn", this.$btns);
            // ѡ״̬
            if (!$btn.hasClass('select')) {
                $('.select', this.$btns).removeClass('select fui-bsb');
                $btn.addClass('select fui-bsb');
            }
            // չʾ
            var content = $btn.data('CONTENT');
            if (content && content.is(":hidden")) {
                $('.fs-tab-content-item', this.$content).hide();
                content.show();
            }
        },

        _createTabDropdownWrapper: function (entry) {
            var self = this;
            var isStarred = false;
            // Ƿentry.idжtabǷΪҳ
            if (entry && entry.id) {
                isStarred = this._isEntryStarred(entry);
            }
            var btnCount = 1;
            // 
            var $wrapper = $('<div class="fs-tab-item-dropdown-wrapper"/>').css({
                'left': entry ? this.dropdownLeft : 0,
                'z-Index': FR.widget.opts.zIndex++
            });
            // Ƿentry.idжtabǷΪҳ
            if (entry && !entry.isModule) {
                btnCount ++;
            }
            // ˵
            var $drop = $('<div class="fs-tab-item-dropdown"/>').appendTo($wrapper);
            $('<span class="arrow"/>').appendTo($wrapper);
            // ˢ°ť
            this._createRefreshBtn().appendTo($drop);
            // ղذť
            if (btnCount > 1) {
                $drop.addClass("double-size");
                $('<span class="splitter"/>').appendTo($drop);
                this._createStarBtn(isStarred).appendTo($drop);
            }
            // ɾ˵¼
            var doRemove = function (e) {
                if (!$(e.target).closest('.fs-tab-item-dropdown-wrapper').length > 0
                        && !$(e.target).closest('.nav-btn.select').length > 0) {
                    $(".fs-tab-item-dropdown-wrapper", self.$float).remove();
                    $('body').unbind();
                }
            };
            $('body').bind('mouseover', doRemove);
            return $wrapper;
        },

        _isEntryStarred: function (entry) {
            var isStarred = false;
            $.each(FS.Control.getFavoriteNodes(), function (index, node) {
                if (node.entry.id === entry.id) {
                    isStarred = true;
                    return false;
                }
            });
            return isStarred;
        },

        _getFavoriteNodeByEntry: function (entry) {
            var target = null;
            $.each(FS.Control.getFavoriteNodes(), function (index, node) {
                if (node.entry.id === entry.id) {
                    target = node;
                    return false;
                }
            });
            return target;
        },

        _createDropdownBtn: function (config) {
            var self = this;
            return $('<div class="fs-tab-item-dropdown-btn"/>')
                .addClass(config.btnCls).append($('<i/>').addClass(config.iconCls))
                .append($('<span/>').text(config.text)).click(function (e) {
                    var $tab = $(this).closest(".fs-tab-item-dropdown-wrapper").data('TAB');
                    var entry = self.loadedEntries[self._getTabIndex($tab)];
                    config.op(e, $tab, entry);
                });
        },

        _createRefreshBtn: function () {
            var self = this;
            var config = {
                'btnCls': "dropdown-refresh",
                'iconCls': "icon-tab-refresh",
                'text': FR.i18nText('FS-Frame-Button_Refresh'),
                'op': function(e, $tab) {
                    self._refreshTab($tab);
                    // ˢť
                    $(".fs-tab-item-dropdown-wrapper", $tab).eq(0).hide();
                }
            };
            return this._createDropdownBtn(config);
        },

        _refreshTab: function($tab){
            var $content = $tab.data('CONTENT');
            var completeFn = $tab.data('COMPLETE');
            if ($content && $content.size() > 0) {
                var frame = $content[0];
                if (frame && frame.src) {
                    // ˢiframeֿ֧
                    frame.src = frame.src;
                    FR.applyFunc(self, completeFn, [$content], false);
                } else if ($(frame).hasClass("fs_design_container")) {
                    // ˢ¹ҳ
                    var entry = this._getTabEntry($tab);
                    entry.contentEl.children().remove();
                    this._loadPlainPaneFromEntry(entry, $tab);
                }
            }
        },

        _createStarBtn: function (isStarred) {
            var self = this;
            var starCfg = {
                'btnCls': "dropdown-star",
                'iconCls': "icon-tab-star",
                'op': function (e, $tab, entry) {
                    // ť
                    var target = e.target;
                    var $btn = $(target).closest('.fs-tab-item-dropdown-btn');
                    if (!entry && !entry.id) {
                        e.stopEvent();
                        return;
                    }
                    if ($btn && $btn.length > 0) {
                        var starred = $btn.data('isStarred');
                        if (starred === true) {
                            // ȡղ
                            var node = self._getFavoriteNodeByEntry(entry);
                            if (node !== null) {
                                FS.Control.removeFavoriteNode(node.id, function () {
                                    self._replaceStarBtn(!starred);
                                });
                            }
                        } else {
                            // ղ
                            FS.Control.addFavoriteNode(entry, function () {
                                self._replaceStarBtn(!starred);
                            });
                        }

                    }
                    // ѡв
                    e.stopEvent();
                }
            };
            starCfg.text = isStarred ? FR.i18nText('FS-Frame-Button_Unstar') : FR.i18nText('FS-Frame-Button_Star');
            var $btn = this._createDropdownBtn(starCfg);
            $('.icon-tab-star', $btn).html(isStarred ? '\ue603' : '\ue61e');
            $btn.data("isStarred", isStarred);
            return $btn;
        },

        _replaceStarBtn: function (isStarred) {
            var $btn = this.$float.find(".dropdown-star");
            if ($btn.data("isStarred") !== isStarred) {
                var $icon = $('.icon-tab-star', $btn);
                var $label = $('span', $btn);
                if (isStarred) {
                    // ȡղ
                    $icon.html('\ue603');
                    $label.text(FR.i18nText('FS-Frame-Button_Unstar'));
                } else {
                    // ղ
                    $icon.html('\ue61e');
                    $label.text(FR.i18nText('FS-Frame-Button_Star'));
                }
                $btn.data("isStarred", isStarred);
            }
        },

        _findLoadedTabFromEntry: function (entry) {
            var self = this;
            var $tab = null;
            $.each(self.loadedEntries, function (i, loadedEntry) {
                if (self._compareEntry(entry, loadedEntry)) {
                    $tab = $(self.$tabs.children()[i]);
                    return false;
                }
            });
            return $tab;
        },

        /**
         * Ƚ tab  entry ǷΪͬһ
         * @param e1 һentry
         * @param e2 ڶentry
         * @returns {boolean}  entry ǷΪͬһ
         */
        _compareEntry: function (e1, e2) {
            if (FR.isNull(e1) || FR.isNull(e2)) {
                return e1 == undefined && e2 == undefined || e1 == null && e2 == null
            }
            if (e1 === e2) {
                return true;
            } else if (typeof e1 == 'object' && typeof e2 == 'object') {
                if (e1.text === e2.text) {
                    // һ
                    return true;
                } else if (!FR.isNull(e1.id) && e1.id === e2.id) {
                    // id һ
                    return true;
                }
            }
            return false;
        },

        _expandMenu: function (expand, duration) {
            var isExpand = this._isMenuExpanded();
            if (expand === isExpand) {
                return;
            }
            duration = duration || 50;
            if (expand) {
                this.$contentMask.show();
                this.$menu.css({
                    'z-Index': FR.widget.opts.zIndex++
                }).slideDown(duration);
            } else {
                this.$contentMask.hide();
                this.$menu.slideUp(duration);
            }
        },

        _isMenuExpanded: function () {
            return this.$menu.is(":visible");
        },

        _refreshMenu: function () {
            var self = this;
            var menuEntries = this.loadedEntries.slice(this.visibleTabCount);
            this.$menu.children('.slimScrollDiv').detach();
            this.$menu.children('.fs-tab-menu-items').detach();
            this.$menuItems = $('<div class="fs-tab-menu-items"/>')
                .appendTo(this.$menu);
            var maxHeight = this.element.height() - 100;
            var itemsHeight = 0;
            $.each(menuEntries, function (index, entry) {
                itemsHeight += 30;
                var $menuItem = self._addMenuItemFromEntry(entry);
                self.$menuItems.append($menuItem);
            });
            if (itemsHeight > maxHeight) {
                this.$menuItems.slimScroll({
                    position: 'relative',
                    height: maxHeight + 'px'
                })
            }
        },

        _addMenuItemFromEntry: function (entry) {
            var self = this;
            var $menuItem = $('<a class="fs-tab-menu-item nav-btn"/>')
                .data('NAV', this.NAV.MOREITEM)
                .data('ENTRY', entry)
                .appendTo(this.$menuItems);
            $('<span/>').text(entry.text)
                .attr('title', entry.text)
                .appendTo($menuItem);
            $('<i class="icon-tab-close"/>')
                .click(function (e) {
                    var $item = $(this).closest(".fs-tab-menu-item");
                    var $tab = self._findLoadedTabFromEntry($item.data('ENTRY'));
                    self._doCloseTab($tab);
                    // ѡв
                    e.stopEvent();
                }).hide()
                .appendTo($menuItem);
            return $menuItem;
        },

        _loadIframePaneFromEntry: function(entry, $tab){
            var url, timeStamp = "", self = this;
            this.element.show();
            if (entry.src) {
                url = entry.src;
            } else if (entry.bilink) {
                url = entry.bilink;
            } else if(entry.url){
                url = entry.url;
                FR.ajax({
                    async : false,
                    url : FR.servletURL + '?op=fs_main&cmd=entry_report&id=' + entry.id + '&isTree=true',
                    complete : function(res, status) {
                        timeStamp = (url.indexOf('?') > -1 ? '&' : '?') + 'fr_check_url=' + res.responseText;
                    }
                });
            }
            var src = url ? url + timeStamp : '?op=fs_main&cmd=entry_report&id=' + entry.id;
            if (entry.bi_edit) {
                src += "&edit=_bi_edit_";
            }
            $('.fs-tab-content-item', this.$content).hide();
            this.setExpand(true, function(){
                var $content = $('<iframe class="fs-tab-content-item"/>').attr(
                    'src', encodeURI(src)
                ).appendTo(self.$content);
                $tab.data('CONTENT', $content);
                $tab.data('COMPLETE', entry.afterLoad);
                self._doSelectTab($tab);
                // ִк¼
                if (FR.applyFunc(self, entry.afterLoad, [$tab, $content, entry], false) === false) {
                    FR.applyFunc(self, self.options.afterLoadTab, [$tab, $content, entry], false);
                }
            });
        },

        _loadPlainPaneFromEntry: function(entry, $tab){
            var self = this;
            this.element.show();
            $('.fs-tab-content-item', this.$content).hide();
            this.setExpand(true, function(){
                var $content = $('<div class="fs-tab-content-item"/>');
                if (entry.contentEl) {
                    $content = entry.contentEl.addClass('fs-tab-content-item').appendTo(self.$content);
                }
                $tab.data('CONTENT', $content);
                $tab.data('COMPLETE', entry.afterLoad);
                self._doSelectTab($tab);
                // ִк¼
                if (FR.applyFunc(self, entry.afterLoad, [$tab, $content, entry], false) === false) {
                    FR.applyFunc(self, self.options.afterLoadTab, [$tab, $content, entry], false);
                }
            });
        },

        /*** TabPane ŵ API ***/

        /**
         * Tabߴ
         * @param give µĳߴ
         */
        doResize: function(give){
            if (give) {
                this.element.width(give.width)
                    .height(give.height);
            }
            this._resizeTabs();
        },

        /**
         * ȡTab״̬Ƿչ
         * @returns {boolean} tabǷչ
         */
        isExpanded: function(){
            return this.isExpand;
        },

        /**
         * Tabչ״̬
         * @param {Boolean} expand չ־: True -> չ, False -> 
         * @param {Function} callback չɺĻص
         */
        setExpand: function(expand, callback){
            if (this.isExpand == expand) {
                FR.applyFunc(this, callback, [], false);
                return;
            }
            // ʼչֱ
            if (!expand && !this.options.isCollapsible) {
                this.element.hide();
                return;
            }
            // չ
            if (expand && this.element.is(":hidden") && this.loadedEntries.length > 0) {
                this.element.show();
            }
            this.isExpand = expand;
            var top = 0;
            if(!expand){
                top = this.element.height() - this.options.tabHeight;
            }
            this.element.animate({
                top: top
            }, 'fast', callback);
            // ı䵯˵λ
            if (expand) {
                this.$menu.css({'top': this.options.tabHeight});
                this.$contentMask.css({'top': 0});
            } else {
                this.$menu.css({'top': -this.$menu.height() - 2});
                this.$contentMask.css({'top': this.options.tabHeight - document.body.clientHeight});
            }
        },

        /**
         * TabĿ
         * @param entry TabӦentry
         *
         * entry ĸɵ÷:
         * onCreate      TabǩʱĲ޸ıǩʽ
         * onSelect      ѡÿTabҳʱĲ޸
         * onClose       رÿTabҳʱĲ
         * afterLoad     ÿTabҳʱĲ
         */
        addItem: function (entry) {
            // title
            if (!entry.text) {
                entry.text = entry.title;
            }
            var $tab = this._findLoadedTabFromEntry(entry);
            if ($tab === null) {
                $tab = this._addNewTabFromEntry(entry);
            } else {
                this._doSelectTab($tab);
                this._refreshTab($tab);
                this.setExpand(true);
                return;
            }
            if (entry.isModule) {
                // ģ
                var designContainer = $("<div/>").addClass('fs_design_container');
                entry.contentEl= designContainer;
                FS.Design.initOP();
                var initOP = FS.Design.op;
                entry.afterLoad = function() {
                    if (initOP[entry.id]) {
                        initOP[entry.id].apply(FS.Design, [designContainer]);
                    }
                };
                this._loadPlainPaneFromEntry(entry, $tab);
            } else if (entry.contentEl) {
                this._loadPlainPaneFromEntry(entry, $tab);
            } else {
                this._loadIframePaneFromEntry(entry, $tab);
            }
        }
    });
})(jQuery);
