(function($){
    FS.MenuTree = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FS.MenuTree.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fs-menutree',
                nodes: [],
                onDataFilter: null,
                onBeforeNodeClick: null,
                onNodeClick: null,
                onAfterNodeClick: null,
                onBeforeNodeCreate: null,
                onNodeCreate: null,
                onAfterNodeCreate: null,
                onBeforeNodeExpand: null,
                onNodeExpand: null,
                onAfterNodeExpand: null,
                onBeforeNodeCollapse: null,
                onNodeCollapse: null,
                onAfterNodeCollapse: null,
                onBeforeDisplayNodes: null,
                onDisplayNodes: null,
                onAfterDisplayNodes: null,
                onBeforeInit: null,
                onAfterInit: null
            });
        },

        _init: function () {
            FS.MenuTree.superclass._init.apply(this, arguments);
            var o = this.options;
            var root = {
                hasChildren: true,
                ChildNodes: o.nodes,
                level: 0
            };
            FR.applyFunc(this, o.onBeforeInit, [this.element], false);
            FR.applyFunc(this, o.onDataFilter, [root, root.ChildNodes], false);
            this.expandNode(root, null, this.element);
            this._bindEvts();
            FR.applyFunc(this, o.onAfterInit, [this.element], false);
        },

        _bindEvts: function(){
            var self = this;
            var doProxy = function(event){
                var target = event.target;
                var $obj = $(target).closest('a.menutree-node');
                if($obj && $obj.length > 0){
                    var type = event.type;
                    if (type === 'mouseover') {
                        $obj.addClass('fui-seb fui-fht');
                    }else if(type === 'mouseout') {
                        if(!$obj.hasClass('select')){
                            $obj.removeClass('fui-seb fui-fht');
                        }
                    }else if(type === 'click'){
                        var node = $obj.data('NODE');
                        self.clickNode(node , $obj);
                    }
                }
            };
            this.element.bind('mouseover', doProxy)
                .bind('mouseout', doProxy)
                .bind('click', doProxy);
        },

        _onNodeCreate: function(node, $li){
            var o = this.options;
            var $node = $('<a class="menutree-node"/>').data('NODE', node);
            FR.applyFunc(this, o.onBeforeNodeCreate, [node, $node, $li], false);
            if(FR.applyFunc(this, o.onNodeCreate, [node, $node, $li], false) === false){
                if(node.level === 1){
                    //һĿ¼
                    $node.addClass("fs-menu-item").attr('title', node.text).appendTo($li);
                    if(node.isModule){
                        //ϵͳ̶ͼ
                        FS.createIconFont("icon-menu-setting-a", "icon-menu-setting-b").appendTo($node);
                    }else{
                        var icon = FS.config.folderIcons[parseInt(node.id)];
                        // ͼ겻ڣʹĬͼ
                        icon = icon ? icon : 'e642';
                        FS.createIconFont('icon-' + icon + '-a', 'icon-' + icon + '-b').appendTo($node);
                    }
                    $('<span/>').text(node.text).appendTo($node);
                }else{
                    //Ŀ¼
                    $node.addClass("fs-menu-item menutree-child")
                        .attr('title', node.text)
                        .css({
                            'padding-left': (node.level - 1) * 14 + 12
                        })
                        .appendTo($li);
                    var $icon = $('<i class="tree-icon"/>').appendTo($node);
                    if(node.hasChildren){
                        if(node.isexpand){
                            // ͼ
                            $icon.html('\ue624');
                        }else{
                            // չͼ
                            $icon.html('\ue61f');
                        }
                    }else{{
                        $icon.addClass('icon-tree-leaf icon-tree-'+node.nodeicon);
                    }}
                    $('<span class="menutree-text"/>').text(node.text).appendTo($node);
                }
            }
            FR.applyFunc(this, o.onAfterNodeCreate, [node, $node, $li], false);
            return $node;
        },

        clickNode: function(node, $node){
            var o = this.options, self = this;
            var $parent = $node.parent('li');
            FR.applyFunc(this, o.onBeforeNodeClick, [node, $node, $parent], false);
            if(FR.applyFunc(this, o.onNodeClick, [node, $node, $parent], false) === false){
                var $menu  = FS.CONSTS.Regions[o.region];
                $('.fs-menu-item.select', $menu).removeClass('select fui-seb fui-fht');
                $node.addClass('select fui-seb fui-fht');
                if(node.hasChildren){
                    if(!node.ChildNodes){
                        if(node.isModule){
                            FS.Async.getModuleTreeById(node.id, function(res, status){
                                node.ChildNodes = [];
                                var modules = FR.jsonDecode(res.responseText).ChildNodes;
                                $.each(modules, function(index, item){
                                    item.isModule = true;
                                    item.nodeicon = FS.CONSTS.ModuleIcons[item.id];
                                    node.ChildNodes.push(item);
                                });
                                FR.applyFunc(self, o.onDataFilter, [node, node.ChildNodes], false);
                                self._displayChildNodes(node, $node, $parent);
                            });
                        }else{
                            FS.Async.getReportTreeById(node.id, function(res, status){
                                node.ChildNodes = FR.jsonDecode(res.responseText) || [];
                                FR.applyFunc(self, o.onDataFilter, [node, node.ChildNodes], false);
                                self._displayChildNodes(node, $node, $parent);
                            });
                        }
                    }else{
                        this._displayChildNodes(node, $node, $parent);
                    }
                }else{
                    FS.loadContentByEntry(node);
                }
            }
            FR.applyFunc(this, o.onAfterNodeClick, [node, $node, $parent], false);
        },

        _displayChildNodes: function(node,$node, $parent){
            var o = this.options;
            FR.applyFunc(this, o.onBeforeDisplayNodes, [node, $node, $parent], false);
            if(FR.applyFunc(this, o.onDisplayNodes, [node, $node, $parent], false) === false){
                FS.doDisplayChildNodes(node.ChildNodes);
                if(node.isexpand){
                    this.collapseNode(node, $node, $parent);
                    $node.find('.tree-icon').html('\ue61f');
                }else{
                    this.expandNode(node, $node, $parent);
                    $node.find('.tree-icon').html('\ue624');
                }
            }
            FR.applyFunc(this, o.onAfterDisplayNodes, [node, $node, $parent], false);
        },

        expandNode: function(root, $node, $parent){
            var self = this, o = this.options, level = root.level;
            FR.applyFunc(this,o.onBeforeNodeExpand, [root, $node, $parent], false);
            if(FR.applyFunc(this,o.onNodeExpand, [root, $node, $parent], false) === false) {
                if(level === 1){
                    //ַٲ
                    if(this.selNode){
                        this.collapseNode(this.selNode.node, this.selNode.$node,this.selNode.wrapper);
                    }
                    this.selNode  = {
                        node: root,
                        $node: $node,
                        wrapper: $parent
                    };
                }
                if (root.hasChildren && root.ChildNodes) {
                    if (root.isLoaded) {
                        $parent.children('ul').slideDown('fast');
                    } else {
                        var $wrapper = $('<ul/>').appendTo($parent);
                        $.each(root.ChildNodes, function (index, item) {
                            item.level = root.level + 1;
                            var $li = $('<li/>').appendTo($wrapper);
                            var $child = self._onNodeCreate(item, $li);
                            if (item.isexpand) {
                                self.expandNode(item, $child, $li);
                            }
                        });
                        root.isLoaded = true;
                    }
                }
            }
            root.isexpand = true;
            FR.applyFunc(this,o.onAfterNodeExpand, [root, $node, $parent], false);
        },

        collapseNode: function(root, $node, $parent){
            var o = this.options;
            FR.applyFunc(this,o.onBeforeNodeCollapse, [root, $node, $parent], false);
            if(FR.applyFunc(this,o.onNodeCollapse, [root, $node, $parent], false) === false) {
                $parent.children('ul').slideUp('fast');
            }
            root.isexpand = false;
            FR.applyFunc(this,o.onAfterNodeCollapse, [root, $node, $parent], false);
        }
    });
})(jQuery);
