(function ($) {
    var embThemes = {
        BIStyle: {
            config4frame: {
                resizable: false,
                south: {
                    visible: true
                }
            },
            config4Gallery: {
                region: 'east'
            },
            config4MenuTree: {
                onNodeExpand: function (root, $node, $parent) {
                    return root.level !== 0;
                },
                onNodeClick: function (node, $node, $parent) {
                    FS.$wrapper && FS.$wrapper.empty();
                    return false;
                }
            },
            config4tabPane: {
                style: 'alpha',
                region: 'south',
                isCollapsible: true,
                hasHomepageBtn: false
            }
        }
    };

    $.extend(FS, {
        NAV: {
            'MESSAGE': 4,
            "ACCOUNT": 5,
            'FAVORITE': 6,
            'UNREG': 7
        },
        CONSTS: {
            ModuleIcons: {
                2: 'reportmgr',
                3: 'usermgr',
                5: 'sysmgr',
                8: 'register',
                9: 'monitor',
                14: 'plate',
                16: 'schedule',
                17: 'mobile',
                18: 'privilege'
            }
        },
        /**
         * FS
         */
        THEME: {
            config4frame: {
                resizable: true,
                //
                north: {
                    visible: true //Ƿɼ
                },
                //
                south: {
                    visible: false //Ƿɼ
                },
                //
                west: {
                    width: 230 //
                },
                //
                east: {}
            },
            config4Gallery: {
                region: null
            },
            config4MenuTree: {
                region: 'west'
            },
            config4tabPane: {
                style: 'bravo',
                region: 'east',
                isCollapsible: false,
                hasHomepageBtn: true
            },
            config4navigation: {
                onBeforeInit: null,
                onAfterInit: null
            }
        },
        /**
         * ƽ̨ʼ
         * @param {JSON} options ƽ̨
         */
        _init: function (options) {
            this.config = options;
            var theme = options.theme;
            $.extend(FS.THEME, theme);
            if (!theme.isCustom && theme.name !== 'default') {
                FS.THEME = $.extend(true, FS.THEME, embThemes.BIStyle);
            }
            var self = this;
            this._initHeader(FS.THEME.config4navigation);
            this._initFrame(FS.THEME.config4frame);
            this._initTabPane(FS.THEME.config4tabPane);
            this._initMenuTree(FS.THEME.config4MenuTree);
            this._initGallery(FS.THEME.config4Gallery, this.$body);
            this._initBackGroundImg(
                options.isBackgroundImg,
                options.backgroundImageID,
                options.backgroundColor
            );
            this._doResize();

            $(window).resize(function () {
                if (self.timer != null) {
                    clearTimeout(self.timer);
                }
                self.timer = setTimeout(function () {
                    self._doResize();
                    self.lastTimer = null;
                }, 200);
            });
        },

        _initFrame: function (config) {
            this.$footer = $('#fs-frame-footer').text(FS.config.company);
            if (!config.north.visible) {
                this.$header.hide();
            }
            if (!config.south.visible) {
                this.$footer.hide();
            }
            this.$body = $('#fs-frame-body');
            this.$menu = $('#fs-frame-menu').width(config.west.width);
            this.$content = $('#fs-frame-content');
            //ʼ
            FS.CONSTS.Regions = {
                north: FS.$header,
                south: FS.$footer,
                west: FS.$menu,
                east: FS.$content
            };
            this._makeResizable(config);
        },

        _makeResizable: function (config) {
            if(config.resizable) {
                var self = this, cc = $('body');
                this.$menu.resizable({
                    handles: "e",
                    onStartResize: function (e) {
                        if (!self.pmask) {
                            self.pmask = $('<div class="fs-resize-mask"/>').insertAfter(self.$menu);
                        }
                        self.pmask.css({
                            zIndex: FR.widget.opts.zIndex++
                        });
                        if (!self.proxy) {
                            self.proxy = $('<div class="fs-resize-line"/>').insertAfter(self.$menu);
                        }
                        self.proxy.css({
                            zIndex: FR.widget.opts.zIndex++,
                            left: e.data.width,
                            top: e.data.top
                        });
                        self.proxy._outerWidth(e.data.width);
                        self.proxy._outerHeight(e.data.height);
                    },
                    onResize: function (e) {
                        self.proxy.css({
                            left: e.data.width,
                            top: e.data.top
                        });
                        self.proxy._outerWidth(e.data.width);
                        self.proxy._outerHeight(e.data.height);
                        return false;
                    },
                    onStopResize: function (e) {
                        self._doResize();
                        self.pmask.remove();
                        self.pmask = null;
                        self.proxy.remove();
                        self.proxy = null;
                    }
                });
            }
        },

        _needGallery: function () {
            return this.THEME.config4tabPane.region === 'south';
        },

        _initHeader: function (config) {
            var self = this;
            FR.applyFunc(this, config.onBeforeInit, [], false);
            this.$header = $('#fs-frame-header');
            this.$naviBar = $('#fs-frame-navi');
            // 
            this.$banner = $('#fs-frame-banner');
            if (FS.config.bannerType > 1) {
                // ʾͼ
                var logo = FS.config.logoImageID4FS;
                logo = FR.servletURL + (logo ?
                    '?op=fr_attach&cmd=ah_image&id=' + logo + '&isAdjust=false' :
                    '?op=resource&resource=/com/fr/fs/resources/images/logo.png');
                $('<img class="fs-banner-logo"/>')
                    .attr('src', logo)
                    .appendTo(this.$banner);
            }
            if (FS.config.bannerType < 3) {
                // ʾ
                $('<span class="fs-banner-title"/>').text(FS.config.company)
                    .appendTo(this.$banner);
            }
            //
            this.$navFavorite = $('#fs-navi-favorite').data('NAV', this.NAV.FAVORITE);
            this.$navMsg = $('#fs-navi-message').data('NAV', this.NAV.MESSAGE).find('span').text('0');
            this.$navAdmin = $('#fs-navi-admin').data('NAV', this.NAV.ACCOUNT).find('span').text(FS.config.username);
            //ʼϵͳϢ
            FS.MsgBox = {};
            if(!FS.isAdmin() && FS.config.supportModules.indexOf("reportprocess") != -1){
                FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmsg.js', 'js');
                FR.$defaultImport('/com/fr/fs/web/css/manager/fs_sysmsg.css', 'css');
                FS.SYSMSG.sendSysMsgConn(60000);
            }
            this._bindNaviBarEvts();
            //ģ
            var $wrapper = $('#fs-frame-search');
            var $results = $wrapper.find('.search-result-wrapper')
                .click(function (e) {
                    var $target = $(e.target).closest('a');
                    if ($target && $target.length > 0) {
                        var entry = $target.data('ENTRY');
                        self.loadContentByEntry(entry);
                    }
                    self.$searchBar.val('');
                    $(this).hide();
                }).hide();
            this.$searchBar = $wrapper.find('input').attr('placeholder', FR.i18nText("FS-Frame-Enter_Entry_Name"))
                .focus(function () {
                    $wrapper.addClass('focus');
                }).blur(function () {
                    $wrapper.removeClass();
                }).keyup(function () {
                    var keyword = this.value;
                    $results.empty().hide();
                    if (FR.isEmpty(keyword)) {
                        return;
                    }
                    var results = [];
                    self._filterReportlets(FS.Cache.entries, keyword, results);
                    var len = results.length;
                    if (len > 0) {
                        $.each(results, function (index, $item) {
                            $item.appendTo($results);
                        });
                        $results.css({
                            'z-Index': FR.widget.opts.zIndex++
                        }).show();
                        $(document).bind('mousedown.search', function (e) {
                            var $target = $(e.target);
                            if (!$target.isChildAndSelfOf('#fs-frame-search')) {
                                $results.hide();
                                $(document).unbind('mousedown.search');
                            }
                        });
                    }
                }).appendTo($wrapper);
            // δעʾϢ
            if (FS.config.isRegiste !== true) {
                $('<div id="fs-frame-reg"/>').data('NAV', this.NAV.UNREG)
                    .text(FR.i18nText("FS-Reg-Simple_Unregistered"))
                    .click(function () {
                        if (FS.config.hasRegistePrivilege === "true") {
                            // עҳ
                            var entry = {
                                'id': 8,
                                'text': FR.i18nText("FS-Module-Simple_Register"),
                                'isModule': true
                            };
                            self.tabPane.addItem(entry);
                        }
                    }).appendTo(this.$header);
            }
            FR.applyFunc(this, config.onAfterInit, [], false);
        },

        _filterReportlets: function (roots, keyword, results) {
            if (!roots) {
                return;
            }
            var self = this;
            $.each(roots, function (index, node) {
                if (node.isModule) {
                    return;
                }
                if (node.hasChildren) {
                    self._filterReportlets(node.ChildNodes, keyword, results);
                } else {
                    var index = node.text.indexOf(keyword);
                    if (index > -1) {
                        var $item = $('<a href="#" class="search-res-item"/>').data('ENTRY', node);
                        var kLen = keyword.length, text = node.text, tLen = text.length;
                        var res = '<span>'
                            + node.text.substr(0, index)
                            + '<span class="search-match">' + node.text.substr(index, kLen) + '</span>'
                            + node.text.substr(index + kLen, tLen - (index + kLen))
                            + '</span>';
                        $(res).appendTo($item);
                        results.push($item);
                    }
                }
            })
        },

        _bindNaviBarEvts: function () {
            var NAV = this.NAV, self = this;
            this.$naviBar.unbind();
            var doProxy = function (event) {
                var target = event.target;
                var $obj = $(target).closest('li');
                if ($obj && $obj.length > 0) {
                    var type = event.type;
                    var navitype = $obj.data('NAV');
                    if (type === 'mouseover') {
                        $(target).closest('a').addClass('fui-bsb');
                        $obj.addClass('fui-seb');
                    } else if (type === 'mouseout') {
                        $(target).closest('a').removeClass('fui-bsb');
                        $obj.removeClass('fui-seb');
                    } else if (type === 'click') {
                        if ($obj.hasClass('fui-bsc')) {
                            return;
                        } else {
                            $('.fs-navibar-item', self.$naviBar).removeClass('fui-bsc');
                            $obj.addClass('fui-bsc');
                        }
                        switch (navitype) {
                            case NAV.MESSAGE:
                                //ϵͳϢ
                                self._showMsgCombo($obj, 'fast');
                                break;
                            case NAV.ACCOUNT:
                                //û
                                self._showAdminCombo($obj, 'fast');
                                break;
                            case NAV.FAVORITE:
                                //ղؼ
                                self._showFavoriteCombo($obj, 'fast');
                                break;
                            default:
                                break;
                        }
                        $(document).bind('mouseover.navi', function (e) {
                            var target = e.target;
                            if (!$(target).isChildAndSelfOf($obj)) {
                                var $combo = $obj.data('COMBO');
                                $combo && $combo.slideUp('fast', function () {
                                    $obj.removeClass('fui-bsc');
                                    $obj.children('span').removeClass('fui-bsd');
                                });
                                $(document).unbind('mouseover.navi');
                            }
                        })
                    }
                }
            };
            this.$naviBar.bind('mouseover', doProxy)
                .bind('mouseout', doProxy)
                .bind('click', doProxy);
        },

        _showMsgCombo: function ($obj, speed) {
            var self = this;
            var $wrapper = $obj.data('COMBO');
            if (!$wrapper) {
                $wrapper = $('<div class="fs-message-combo"/>')
                    .hide().appendTo($obj);
                $obj.data('COMBO', $wrapper);
            }
            $wrapper.empty().css({
                'z-Index': FR.widget.opts.zIndex++
            });
            if(this.MsgBox.msgs && this.MsgBox.msgs.length > 0){
                FR.applyFunc(this, this.MsgBox.onMsgShow, [$wrapper], false);
            }else{
                $('<div class="fs-message-combo-title"/>').text(FR.i18nText("FS-Msg-No_Message")).appendTo($wrapper);
            }
            $obj.children('span').addClass('fui-bsd');
            $wrapper.slideDown(speed);
        },

        _showFavoriteCombo: function ($obj, speed) {
            var self = this;
            var $wrapper = $obj.data('COMBO');
            if (!$wrapper) {
                $wrapper = $('<div class="fs-favorite-combo"/>')
                    .hide().appendTo($obj);
                $obj.data('COMBO', $wrapper);
            }
            var head = FS.THEME.config4frame.north.visible ? 60 : 0;
            var foot = FS.THEME.config4frame.south.visible ? 30 : 0;
            $wrapper.empty().css({
                height: document.body.clientHeight - head - foot,
                'z-Index': FR.widget.opts.zIndex++
            });
            $('<div class="fs-favorite-combo-title"/>')
                .text(FR.i18nText("FS-Generic-Simple_Favorite")).appendTo($wrapper);
            var $list = $('<div class="fs-favorite-combo-list"/>').appendTo($wrapper);
            // ղؼ
            var nodes = this.Control.getFavoriteNodes();
            if (nodes && nodes.length > 0) {
                $.each(nodes, function (index, node) {
                    var $node = $('<a href="#"/>').attr('title', node.entry.text).data('FAVORITE', node).appendTo($list);
                    $('<span/>').text(node.entry.text).appendTo($node);
                    var $del = $('<i class="icon-remove-favorite"/>').hide().appendTo($node);
                    $node.hover(function () {
                        $del.show();
                    }, function () {
                        $del.hide();
                    })
                });
                $wrapper.click(function (e) {
                    var $target = $(e.target);
                    var $entry = $target.closest('a');
                    var node = $entry.data('FAVORITE');
                    if ($entry && $entry.length > 0) {
                        if ($target.hasClass('icon-remove-favorite')) {
                            //ɾղ
                            self.Control.removeFavoriteNode(node.id, function () {
                                $entry.remove();
                            });
                        } else {
                            //ղ
                            $wrapper.hide();
                            self.loadContentByEntry(node.entry);
                        }
                    }
                });
            }
            $list.slimscroll({
                position: 'relative',
                width: '260px',
                height: (document.body.clientHeight - 122) + 'px'
            });
            $wrapper.slideDown(speed);
        },

        _showAdminCombo: function ($obj, speed) {
            var $combo = $obj.data('COMBO');
            if ($combo && $combo.length > 0) {
                $combo.slideDown(speed);
            } else {
                var self = this;
                $combo = $('<div class="fs-admin-combo"/>').css({
                    width: 130,
                    'z-Index': FR.widget.opts.zIndex++
                });
                $obj.data('COMBO', $combo);
                //˺
                if (FS.canModifyPassword()) {
                    $('<a href="#"/>').text(FR.i18nText("FS-Admin-Account_Setting"))
                        .appendTo($combo)
                        .click(function () {
                            //޸
                            var $container = $("<div/>").addClass('fs_design_container');
                            $combo.hide();
                            self.loadContentByEntry({
                                text: FS.isAdmin() ? FR.i18nText("FS-Admin-Simple_Account") : FR.i18nText('FS-Admin-Account_Setting'),
                                contentEl: $container,
                                isModule: true,
                                id: 999
                            });
                        });
                }
                //˳
                $('<a href="#"/>').text(FR.i18nText("FS-Admin-Simple_Exit"))
                    .appendTo($combo)
                    .click(function () {
                        self.signOut();
                    });
                //ά
                FR.ajax({
                    url: FR.servletURL + "?op=fs_mobile_main&cmd=initdata",
                    type: "POST",
                    complete: function (res, status) {
                        var data = FR.jsonDecode(res.responseText);
                        if (data && data.qrcodeid) {
                            var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + data.qrcodeid + '&isAdjust=false');
                            $("<img/>").attr('src', url).prependTo($combo);
                        }
                        $combo.hide().appendTo($obj).slideDown(speed);
                    }
                });
            }
        },

        _initTabPane: function (config) {
            var render;
            // ѡ
            if (this._needGallery()) {
                var position = this.$footer.position();
                render = $('<div/>').appendTo('body').css({
                    position: 'absolute',
                    top: position.top,
                    left: position.left
                });
            } else {
                if (FR.isEmpty(config.region)) {
                    return;
                }
                render = $('<div/>').appendTo(FS.CONSTS.Regions[config.region]);
            }
            config.renderEl = render;
            // Tab
            this.tabPane = new FS.QuickTab(config);
        },

        _initMenuTree: function (config) {
            if (FR.isEmpty(config.region)) {
                return;
            }
            var self = this, $parent = FS.CONSTS.Regions[config.region];
            var $scroll = $('<div class="fs-frame-scroll"/>').appendTo($parent);
            $scroll.slimscroll({
                position: 'relative',
                width: '100%',
                height: '100%'
            });
            if(FS.isPlatForm()){
                var modules = FS.config.roots.modules;
                if (modules && modules.length > 0) {
                    var moduleRootId = modules[0].id;
                    FS.Async.getModuleTreeById(moduleRootId, function(res, status){
                        var node = {
                            text: FR.i18nText("FS-Generic-Manager_System"),
                            id: moduleRootId,
                            isModule: true,
                            hasChildren: true,
                            ChildNodes: [],
                            isexpand: true
                        };
                        var modules = FR.jsonDecode(res.responseText).ChildNodes;
                        $.each(modules, function(index, item){
                            item.isModule = true;
                            item.nodeicon = FS.CONSTS.ModuleIcons[item.id];
                            node.ChildNodes.push(item);
                        });
                        config.renderEl = $('<div/>').appendTo($scroll);
                        config.nodes = [node];
                        new FS.MenuTree(config);
                    });
                }
            }else{
                var hasGallery = this._needGallery();
                if (hasGallery) {
                    var $home = $('<a class="fs-menu-home fs-menu-item select fui-seb fui-fht"/>')
                        .click(function () {
                            $('.fs-menu-item.select', $parent).removeClass('select fui-seb fui-fht');
                            $(this).addClass('select fui-seb fui-fht');
                            self._hideContentWrapper();
                            self.$home && self.$home.show();
                        }).hover(function(){
                            $(this).addClass('fui-seb fui-fht');
                        }, function(){
                            if(!$(this).hasClass('select')){
                                $(this).removeClass('fui-seb fui-fht');
                            }
                        }).appendTo($scroll);
                    this.createIconFont("icon-menu-home-a", "icon-menu-home-b").appendTo($home);
                    $('<span/>').text(FR.i18nText("FS-Setting-Home_Page")).appendTo($home);
                    $('<div class="fs-frame-split"/>').appendTo($scroll);
                }
                FS.Async.getReportTreeById(-1, function (res, status) {
                    self.Cache.entries = FR.jsonDecode(res.responseText) || [];
                    var nodes = self.Cache.entries || [];
                    //ϵͳڵ
                    var modules = FS.config.roots.modules;
                    if (modules && modules.length > 0) {
                        nodes.push({
                            text: FR.i18nText("FS-Generic-Manager_System"),
                            id: modules[0].id,
                            isModule: true,
                            hasChildren: true
                        });
                    }
                    config.renderEl = $('<div/>').appendTo($scroll);
                    config.nodes = nodes;
                    new FS.MenuTree(config);
                });
            }
        },

        refreshMsgBox: function(msgs, onMsgShow){
            var num = 0;
            if(msgs){
                num = msgs.length;
            }
            $('.fs-navi-msgnum').text(num);
            this.MsgBox = {
                msgs: msgs,
                onMsgShow: function($wrapper){
                    if(onMsgShow){
                        onMsgShow($wrapper);
                    }
                }
            };
        },

        doDisplayChildNodes: function (nodes) {
            if (!this._needGallery()) {
                return;
            }
            this.$home && this.$home.hide();
            this._showContentWrapper();
            if (nodes == null) {
                return;
            }
            var $wrapper = this.$wrapper, self = this;
            var $reports = $('<div class="fs-group-content"/>').appendTo($wrapper);
            $.each(nodes, function (index, node) {
                if (node.hasChildren) {
                    if (!node.ChildNodes) {
                        return;
                    }
                    var $title = $('<div class="fs-group-title fui-fbt"/>').appendTo($wrapper);
                    $('<span class="fs-group-title-d fui-bsd"/>').appendTo($title);
                    $('<span/>').text(node.text).appendTo($title);
                    var $group = $('<div class="fs-group-content"/>').appendTo($wrapper);
                    self._collectAllChildNodes(node, $group);
                } else {
                    var $card;
                    if (node.isModule) {
                        $card = self._createModuleNodeCard(node);
                    } else {
                        $card = self._createCoverNodeCard(node);
                    }
                    $card.appendTo($reports);
                }
            });
        },

        _collectAllChildNodes: function (node, $group) {
            var self = this;
            $.each(node.ChildNodes, function (index, child) {
                if (child.hasChildren) {
                    self._collectAllChildNodes(child, $group);
                } else {
                    var $card = self._createCoverNodeCard(child);
                    $card.appendTo($group);
                }
            });
        },

        _createCoverNodeCard: function (node) {
            var $card = $('<div class="fs-content-card"/>').data('ENTRY', node);
            var coverId = node.mobileCoverId ? node.mobileCoverId : 'a';
            var url = FR.servletURL + (coverId.length < 2 ?
                "?op=resource&resource=/com/fr/fs/resources/images/mobile/cover/" + coverId + ".png" :
                "?op=fs_mobile_main&cmd=get_report_cover&id=" + coverId);
            $('<img/>').attr("src", url).appendTo($card);
            $('<div/>').attr('title', node.text).text(node.text).appendTo($card);
            return $card;
        },

        _createModuleNodeCard: function (node) {
            node.isModule = true;
            var $card = $('<div class="fs-content-card"/>').data('ENTRY', node);
            $('<img/>').attr("src", FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/frame/fsmodule" + node.id + ".png").appendTo($card);
            $('<div/>').attr('title', node.text).text(node.text).appendTo($card);
            return $card;
        },

        createIconFont: function (acls, bcls) {
            var $icon = $('<span/>').addClass("fs-menu-icon");
            $('<i/>').addClass(acls).addClass('icon-menu-a').appendTo($icon);
            $('<i/>').addClass(bcls).addClass('icon-menu-b fui-fhc').appendTo($icon);
            return $icon;
        },

        _initGallery: function (config) {
            if (FR.isEmpty(config.region)) {
                return;
            }
            var self = this, $el = FS.CONSTS.Regions[config.region];
            if (this._needGallery() && !FS.isPlatForm()) {
                var url = this.config.homePageUrl;
                if (url) {
                    this.$home = $('<iframe id="fs-frame-home"/>')
                        .attr({src: encodeURI(FS.Trans._dealWithSrc(url))})
                        .appendTo($el);
                }
            }
            this.$wrapper = $('<div id="fs-frame-wrapper"/>').hide().appendTo($el);
            this.$wrapper.click(function (event) {
                var target = event.target;
                var $obj = $(target).closest('.fs-content-card');
                if ($obj && $obj.length > 0) {
                    var entry = $obj.data('ENTRY');
                    self.loadContentByEntry(entry);
                }
            });
            this.$wrapper.slimscroll({
                height: '100%'
            });
            this._hideContentWrapper();
            this._bindContentEvents();
        },

        _bindContentEvents: function ($el) {
            var self = this;
            var doProxy = function (event) {
                var type = event.type;
                if (self.$wrapper) {
                    if (type === 'mouseover') {
                        self.$wrapper.addClass('scroll-content-hover');
                    } else if (type === 'mouseout') {
                        self.$wrapper.removeClass('scroll-content-hover');
                    }
                }

            };
            this.$wrapper.bind('mouseover', doProxy)
                .bind('mouseout', doProxy)
                .bind('click', doProxy)
        },

        _hideContentWrapper: function () {
            this.$wrapper.hide();
            if (this.$wrapper.parent().hasClass('slimScrollDiv')) {
                this.$wrapper.parent().hide();
            }
        },

        _showContentWrapper: function () {
            if (this.$wrapper.parent().hasClass('slimScrollDiv')) {
                this.$wrapper.parent().show();
            }
            this.$wrapper.empty().show();
        },

        loadContentByEntry: function (entry) {
            this.tabPane.addItem(entry);
        },

        _doResize: function () {
            var head = FS.THEME.config4frame.north.visible ? 60 : 0;
            var foot = FS.THEME.config4frame.south.visible ? 30 : 0;
            var clientWidth = document.body.clientWidth;
            var clientHeight = document.body.clientHeight;
            this.$body.css({
                height: clientHeight - head - foot,
                top: head
            });
            var w = this.$menu.width();
            this.$content.css({
                left: w,
                width: clientWidth - w
            });
            this.$footer.css({
                top: clientHeight - foot
            });
            if (this.tabPane) {
                var top = this.tabPane.element.height() - foot;
                if (this.tabPane.isExpanded()) {
                    top = 0;
                }
                this.tabPane.element.css('top', top);
                this.tabPane.doResize();
            }
        },

        _initBackGroundImg: function (isBgImg, imgId, bgColor) {
            var $body = $('body');
            if (isBgImg === false) {
                $body.addClass('fs-style-pure').css({'background': bgColor});
            } else {
                var url = FR.servletURL
                    + ((imgId && imgId != 'null') ? ('?op=fr_attach&cmd=ah_image&id=' + imgId + '&isAdjust=false') : '?op=resource&resource=/com/fr/fs/resources/images/fsbg.jpg');
                $body.css({'background-image': 'url("' + url + '")'});
            }
        },

        signOut: function () {
            FR.ajax({
                url: FR.servletURL + "?op=fs_load&cmd=logout",
                type: 'POST',
                success: function (res, status) {
                    window.location.href = res;
                }
            });
        },

        Control: {
            /**
             * ղؽڵ
             * @param entry ڵ
             * @param callback ӲɺĻص
             */
            addFavoriteNode: function (entry, callback) {
                var self = this;
                var completeFn = function (res, status) {
                    if (status === "success") {
                        var result = FR.jsonDecode(res.responseText);
                        self.getFavoriteNodes().push({
                            "id": result.id,
                            "entry": entry
                        });
                        FR.applyFunc(self, callback, [], false);
                    }
                };
                FS.Async.addFavorite(entry.id, completeFn);
            },

            /**
             * ȡղ
             * @param id ղؽڵID
             * @param callback ɾִɺĻص
             */
            removeFavoriteNode: function (id, callback) {
                var completeFn = function (res, status) {
                    if (status === "success") {
                        var index = null;
                        $.each(FS.Control.getFavoriteNodes(), function (i, node) {
                            if (node.id === id) {
                                index = i;
                                return false;
                            }
                        });
                        if (index !== null) {
                            FS.Control.getFavoriteNodes().splice(index, 1);
                        }
                        FR.applyFunc(self, callback, [], false);
                    }
                };
                FS.Async.removeFavorite(id, completeFn);
            },

            /**
             * ȡеղؽڵ
             * @returns {*}
             */
            getFavoriteNodes: function () {
                if (FS.Cache.favorites === null) {
                    FS.Cache.initFavoriteCache();
                }
                return FS.Cache.favorites;
            }
        },

        Cache: {
            entries: [],

            /**
             * ղؽڵбδʼʱΪnull磺
             * [{id:1, entry:{....}}]
             */
            favorites: null,

            /**
             * ʼղػ
             */
            initFavoriteCache: function () {
                this.favorites = FS.Sync.getFavorite();
            }
        }
    });
})(jQuery);

