if (window.FS == null) {
    window.FS = {};
}

/**
 * FSؼؼͨextendķʽ̳֮
 * @param {JSON} config ؼԡ
 */
FS.Widget = function (config) {
    this.init(config);
};

$.extend(FS.Widget.prototype, {
    init: function () {
    },

    resize: function (config) {
        if (config) {
            this.element.width(config.width).height(config.height);
        } else {
            var p = this.element.parent();
            this.element.width(p.width()).height(p.height());
        }
    }
});

FS.extend = function (ui, newui) {
    var fn = function () {
        ui.apply(this, arguments);
    };
    $.extend(fn.prototype, ui.prototype, newui);
    return fn;
};

$.extend(FS, {
    importThemeStyle: function (style) {
        var styleHtml = '.fui-seb{background-color: ' + style.background + ';}' +
            '.fui-fbc{color: ' + style.font + ';}' +
            '.fui-fbt{text-shadow: 0 0 1px ' + style.font + ';}' +
            '.fui-fhc{color: ' + style.highlight + ';}' +
            '.fui-fht{text-shadow: 0 0 3px ' + style.highlight + ';}' +
            '.fui-bsb{background-color: ' + style.tint + ';}' +
            '.fui-bsc{color: ' + style.tint + ';}' +
            '.fui-bsd{border-color: ' + style.tint + ';}';
        var $style = $('style[name="theme"]');
        if ($style && $style.length > 0) {
            $style.remove();
        }
        $('<style name="theme" type="text/css">' + styleHtml + '</style>').appendTo("head");
    },

    isPlatForm: function () {
        return this.config.isPlatForm === "true";
    },

    /**
     * FSò
     * @param config FSò
     */
    setConfig: function (config) {
        this.config = config;
        this.configured = true;
    },

    /**
     * FSòǷѾ
     * @returns {boolean} òǷ
     */
    isConfigured: function () {
        return this.configured === true;
    },

    /**
     * ģضӦģҳ棬ڼɶҳ
     * @param render ҳ
     * @param moduleName ģ
     */
    loadModule: function (render, moduleName) {
        if (!FS.isConfigured()) {
            var config = null;
            FR.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=get_config_param",
                type: 'POST',
                async: false,
                complete: function (res, status) {
                    if (status === "success") {
                        config = FR.jsonDecode(res.responseText);
                    }
                }
            });
            if (config && config.embModuleSuccess) {
                this.setConfig(config);
            } else {
                window.console && console.error("FS not configured");
            }
        }
        switch (moduleName) {
            case "report":
                //
                FS.Design.reportManager(render);
                break;
            case "user":
                //û
                FS.Design.userManager(render);
                break;
            case "privilege":
                //Ȩ޹
                FS.Design.showPrivilegeManager(render);
                break;
            case "schedule":
                //ʱ
                FS.Design.showScheduleSetting(render);
                break;
            case "sysmgr":
                //ϵͳ
                FS.Design.systemManager(render);
                break;
            case "lookandfeel":
                //ƽ̨
                FS.Design.lookAndFeelSetting(render);
                break;
            case "register":
                //עϢ
                FS.Design.registerManager(render);
                break;
            case "monitor":
                //ϵͳ
                FS.Design.monitorManager(render);
                break;
            case "mobile":
                //ƶƽ̨
                FS.Design.showMobileDevSetting(render);
                break;
            default:
                break;
        }
    },

    /**
     * Ա˻ģ
     * @returns {JSON} Ϣ
     */
    adminPwdModule: function () {
        var items = [
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Username")}},
                {el: {type: 'text', widgetName: 'usernameText', allowBlank: false, value: FS.config.username}},
                null,
                {
                    el: {
                        type: 'llabel',
                        widgetName: 'usernameError',
                        levelStyle: 0,
                        fontfamily: 'SimSun',
                        invisible: true,
                        color: '#EB000B',
                        fontsize: '13px',
                        value: FR.i18nText("FS-User-Username_Can_Not_Be_Null")
                    }
                }
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-Admin-Old_Password")}},
                {el: {type: 'password', widgetName: 'oldPwdText'}},
                null,
                {
                    el: {
                        type: 'llabel', widgetName: 'oldPwdError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                        color: '#EB000B', fontsize: '13px', value: FR.i18nText("FS-Admin-Old_Password_Error")
                    }
                }
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-Admin-Enter_New_Password")}},
                {el: {type: 'password', widgetName: 'newPwdText'}},
                null,
                {
                    el: {
                        type: 'llabel',
                        widgetName: 'enterNewPwdError',
                        levelStyle: 0,
                        fontfamily: 'SimSun',
                        invisible: true,
                        color: '#EB000B',
                        fontsize: '13px',
                        value: FR.i18nText("FS-Admin-Please_Enter_Newpwd")
                    }
                }
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-Admin-Verify_New_Password")}},
                {el: {type: 'password', widgetName: 'verifyPwdText'}},
                null,
                {
                    el: {
                        type: 'llabel',
                        widgetName: 'pwdNotMatchError',
                        levelStyle: 0,
                        fontfamily: 'SimSun',
                        invisible: true,
                        color: '#EB000B',
                        fontsize: '13px',
                        value: FR.i18nText("FS-Admin-Passwords_Not_Match")
                    }
                }
            ]
        ];
        var adminPwd = {
            title: FR.i18nText("FS-Admin-Simple_Account"),
            content: {
                type: 'confirm',
                doSize: true,
                text4OK: FR.i18nText("FS-Generic-Simple_Save"),
                text4Cancel: null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                firstBtnMargin: 0,
                //޸ģȷϰťĵ¼
                onOK: function () {
                    //޸ĹԱ˻û
                    //ȡԱϢ
                    var usernameText = this.getWidgetByName('usernameText'),
                        oldPwdText = this.getWidgetByName('oldPwdText'),
                        verifyPwdText = this.getWidgetByName('verifyPwdText'),
                        newPwdText = this.getWidgetByName('newPwdText'),
                    //Ϣ
                        usernameError = this.getWidgetByName('usernameError'),
                        oldPwdError = this.getWidgetByName('oldPwdError'),
                        enterNewPwdError = this.getWidgetByName('enterNewPwdError'),
                        pwdNotMatchError = this.getWidgetByName('pwdNotMatchError');
                    //ձϢ
                    usernameError.setVisible(false);
                    oldPwdError.setVisible(false);
                    enterNewPwdError.setVisible(false);
                    pwdNotMatchError.setVisible(false);
                    var oldp = oldPwdText.getValue(),
                        np = newPwdText.getValue(),
                        username = usernameText.getValue(),
                        info = {};
                    //жûǷΪ
                    if (!usernameText.checkValid()) {
                        usernameError.setVisible(true);
                        return false;
                    }
                    if (username != FS.config.username) {
                        info.username = username
                    }
                    //벻ΪձʾҪ޸
                    if (!FR.isEmpty(oldp)) {
                        //жǷΪ
                        if (FR.isEmpty(np)) {
                            enterNewPwdError.setVisible(true);
                            return false;
                        }
                        //жǷһ
                        if (np != verifyPwdText.getValue()) {
                            pwdNotMatchError.setVisible(true);
                            return false;
                        }
                        info.oldp = encodeURIComponent(oldp);
                        info.np = encodeURIComponent(np);
                    }
                    //ύû޸,жǷ޸ĳɹ
                    var submitPwd = FS.Trans.changePW(info);
                    if (submitPwd.success) {
                        FS.signOut();
                    } else {
                        oldPwdError.setVisible(true);
                        return false;
                    }
                    return true;
                },
                onCancel: function () {
                },
                width: 500,
                height: 206,
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'userInfoTablelayout',
                    columnSize: [131, 122, 6, 'fill'],
                    rowSize: [21, 21, 21, 21],
                    vgap: 19,
                    items: items
                }
            }
        };
        return adminPwd;
    },
    isAdmin: function () {
        return FS.config.isAdmin === true;
    },
    /**
     * Ƿ޸롣ֻйԱ¼߷ͬݼû¼²ſ޸롣
     * @returns {boolean} Ƿ޸롣
     */
    canModifyPassword: function () {
        return FS.config.isTableDataUser != "true" || FS.isAdmin();
    },
    isGradeAuthorityOpen: function () {
        return this.config.gradeAuthority == "true";
    },

    hasGradeAuthority: function () {
        return this.config.hasGradeAuthority == 'true';
    },

    isEditReportAuthorityOpen: function () {
        return this.config.editReportAuthority == "true";
    },

    setEditReportAuthority: function (editReportAuthority) {
        this.config.editReportAuthority = editReportAuthority;
    },

    setGradeAuthorityOpen: function (gradeAuthority) {
        this.config.gradeAuthority = gradeAuthority;
    },

    setTemplatePrivilegeType: function (type) {
        this.config.templatePrivilegeType = type;
    },

    isDataConnectionAuthorityOpen: function () {
        return this.config.dataConnectionAuthority == "true";
    },

    setDataConnectionAuthorityOpen: function (dataConnectionAuthority) {
        this.config.dataConnectionAuthority = dataConnectionAuthority;
    },

    /**
     * ַɺʡԴ...ַ
     * daniel:FF֧text-overflow:ecllpiscɶjs...ַ
     * @param {String} showText ԭʼ
     * @param {Number} maxlength 
     * @param {Number} fontsize С
     * @param {String} fontfamily 
     * @return 
     */
    getShowText: function (showText, maxlength, fontsize, fontfamily) {
        var t = $('<span style="font-size: ' + fontsize + 'px;font-family:' + fontfamily + '"></span>').appendTo('body');
        t.html(showText);
        var isTooLong = false;
        while (showText.length > 0 && t[0].offsetWidth > maxlength) {
            showText = showText.substr(0, showText.length - 1);
            t.html(showText);
            isTooLong = true;
        }
        if (isTooLong) {
            showText += "...";
        }
        t.remove();
        return showText;
    },

    Design: {

        op : {
            initialled : false
        },

        initOP: function () {
            // richie:óʼˣͲڼʼ
            if (this.op.initialled) {
                return;
            }
            $.extend(this.op, {

                initialled : true,

                //
                2: function (designContainer) {
                    return this.reportManager(designContainer);
                },
                //û
                3: function (designContainer) {
                    return this.userManager(designContainer);
                },
                //Ȩ޹
                18: function (designContainer) {
                    return this.showPrivilegeManager(designContainer);
                },
                //ʱ
                16: function (designContainer) {
                    return this.showScheduleSetting(designContainer);
                },
                //ϵͳ
                5: function (designContainer) {
                    return this.systemManager(designContainer);
                },
                //ƽ̨
                14: function (designContainer) {
                    return this.lookAndFeelSetting(designContainer);
                },
                //עϢ
                8: function (designContainer) {
                    return this.registerManager(designContainer);
                },
                //ϵͳ
                9: function (designContainer) {
                    return this.monitorManager(designContainer);
                },
                //ƶƽ̨
                17: function (designContainer) {
                    return this.showMobileDevSetting(designContainer);
                },

                15: function (designContainer) {
                    //BI
                    return this.showBIDataSettings(designContainer);
                },
                999: function (designContainer) {
                    return this.accountSetting(designContainer);
                }
            });
        },

        /**
         * ʾָǩģ
         * @param {Object} module ģϢ
         */
        showDesign: function (module) {
            FS.tabPane.addItem(module);
        },

        resize: function () {
        },

        //˺
        accountSetting: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_password.js', 'js');
            FS.PASSWORD.init(designContainer);
        },
        //
        reportManager: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_reportmgr.js', 'js');
            FS.REPORTMGR.init(designContainer);
        },
        //û
        userManager: function (designContainer) {
            if (FS.isPlatForm()) {
                FR.$defaultImport('/com/fr/fs/web/js/manager/pf_usermgr.js', 'js');
            } else {
                FR.$defaultImport('/com/fr/fs/web/js/manager/fs_usermgr.js', 'js');
            }
            FS.USERMGR.init(designContainer);
        },
        //Ȩ޹
        showPrivilegeManager: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_privilegemanager.js', 'js');
            return FS.PRIVILEGEMANAGER.init(designContainer);
        },
        //ʱ
        showScheduleSetting: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_schedule.js', 'js');
            return FS.SCHEDULEMANAGER.init(designContainer);
        },
        //ϵͳ
        systemManager: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmgr.js', 'js');
            FS.SYSMGR.init(designContainer);
        },
        //ƽ̨
        lookAndFeelSetting: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_configsetting.js', 'js');
            FS.CONFIGSETTING.init(designContainer);
        },
        //עϢ
        registerManager: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_register.js', 'js');
            FS.REGISTER.init(designContainer);
        },
        //ϵͳ
        monitorManager: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_sysmonitor.js', 'js');
            FS.SYSMONITOR.init(designContainer);
        },
        //ƶƽ̨
        showMobileDevSetting: function (designContainer) {
            FR.$defaultImport('/com/fr/fs/web/js/manager/fs_mobileplate.js', 'js');
            return FS.MOBILEPLATE.init(designContainer);
        },

        showBIDataSettings: function (designContainer) {
            var src = FR.servletURL + '?op=fr_bi_configure&cmd=init_configure_pane';
            $('<iframe/>').css({height: '100%', width: '100%'})
                .attr({frameborder: 0, src: src}).appendTo(designContainer);
        }
    },

    Trans: {

        /**
         * ͬajax
         * @return Ľjson/string
         */
        ajax: function (config) {
            var self = this, returnData;
            FR.ajax({
                url: config.url,
                async: false,
                data: config.data,
                type: config.type ? config.type : 'POST',
                beforeSend: config.beforeSend,
                error: config.error,
                complete: function (res, status) {
                    try {
                        returnData = config.returnString ? res.responseText : FR.jsonDecode(res.responseText);
                    } catch (Error) {
                        FR.Msg.toast("AnalysisData Error!");
                    }
                }
            });
            return returnData;
        },

        /**
         * urlķhttp://
         * @param {String} address ԭʼַ
         * @private
         */
        _dealWithSrc: function (address) {
            var temp = '';
            var url1 = /[a-zA-z]+:\/\/[^\s]*/;
            var url2 = /\/[^\s]*/;
            if (address.startWith("&fr_check_url") || address.startWith("about:blank")) {
                temp = "";
            } else if (address.match(url1) || address.match(url2)) {
                temp = address;
            } else {
                temp = "http://" + address;
            }
            return temp;
        },
        savePrivileges: function (privileges) {
            return this.ajax({
                returnString: true,
                url: FR.servletURL + "?op=fs_set&cmd=auth_save",
                data: privileges
            });
        },

        getCompanyRoleAuth: function (departmentId, postId) {
            var data = {};
            if (departmentId) {
                data.departmentId = departmentId;
            }
            if (postId) {
                data.postId = postId;
            }
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_getjroleauth"
            });
        },

        getCustomRoleAuth: function (role) {
            return this.ajax({
                data: role,
                url: FR.servletURL + "?op=fs_set&cmd=auth_getsroleauth"
            });
        },

        removeRole: function (role) {
            var url = FR.servletURL + "?op=fs_set&cmd=";
            if (role.postid != null || role.departmentid != null) {
                url += "auth_removejrole"
            } else {
                url += "auth_removesrole"
            }
            FR.ajax({
                data: {id: role.id},
                url: url,
                complete: function () {
                    role.id = -1;
                }
            });
        },

        updateRoleUsers: function (data) {
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_updatesroleusers"
            });
        },

        addDepart: function (depart) {
            return this.ajax({
                data: {depart: depart},
                url: FR.servletURL + "?op=fs_set&cmd=auth_adddepart"
            });
        },

        removeDepart: function (id) {
            this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_set&cmd=auth_removedepart"
            });
        },

        addPost: function (post) {
            return this.ajax({
                returnString: true,
                data: {post: post},
                url: FR.servletURL + "?op=fs_set&cmd=auth_addpost"
            });
        },

        addEmployee: function (employee) {
            return this.ajax({
                returnString: true,
                data: {employee: employee},
                url: FR.servletURL + "?op=fs_set&cmd=auth_addemployee"
            });
        },

        removeEmployee: function (data) {
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_removeemployee"
            });
        },

        addUser: function (user) {
            var encodeUser = {};
            $.each(user, function (key, item) {
                encodeUser[encodeURIComponent(key)] = encodeURIComponent(item);
            });
            return this.ajax({
                data: {user: encodeUser},
                url: FR.servletURL + "?op=fs_set&cmd=auth_adduser"
            });
        },

        removeUser: function (id) {
            this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_set&cmd=auth_removeuser"
            });
        },

        getEntryRoles: function (entryId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getEntryRoles",
                data: {
                    entryId: entryId
                }
            });
        },

        getUserAuths: function (userId) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getUserAuth",
                data: {
                    userId: userId
                }
            });
        },

        getPrivilegeSetting: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getTemplatePrivilege"
            });
        },

        savePrivilegeSetting: function (settings) {
            return this.ajax({
                returnString: true,
                url: FR.servletURL + "?op=fs_set&cmd=auth_saveTemplatePrivilege",
                data: settings
            });
        },

        addPostsToDepart: function (data) {
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_addjrole_post"
            });
        },

        removePostsFromDepart: function (data) {
            return this.ajax({
                data: data,
                url: FR.servletURL + "?op=fs_set&cmd=auth_removejrole_post"
            });
        },

        /**
         * ޸ĵ¼ûԼû(޹Ա)
         * @param {JSON} info ûϢ
         * @return {*} Ƿɹ"true"/"false"
         */
        changePW: function (info) {
            return this.ajax({
                data: info,
                url: FR.servletURL + "?op=fs_main&cmd=user_changepw"
            });
        },

        /**
         * رͬݼ
         */
        closeTableDataSync: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=closeTableDataSync"
            })
        },

        /**
         * Ƿͬݼ
         * @returns {Ľ} jsonresult.type,1:0:û
         */
        getTableDataSyncState: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=getTableData_sync_state"
            })
        },

        /**
         * ͬݼ
         * @param data Ϣ
         * @returns {*} jsonresult.successʾǷ񱣴ɹ
         */
        saveTableDataSync: function (data) {
            return this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=editTabledataSync",
                data: {
                    res: data
                }
            });
        },
        /**
         * ȡLDAP
         * @returns {*} Ľ
         */
        getLdapAttrs: function () {
            return FS.Trans.ajax({
                url: FR.servletURL + "?op=fs_load&cmd=loginLdapAttrs",
                returnString: true
            });
        }
    },

    /**
     * 첽
     * @since 8.0
     */
    Async: {
        /**
         * 첽ajax
         * @config 첽
         * @return Ľjson/string
         */
        ajax: function (config, completeFn) {
            FR.ajax({
                url: config.url,
                data: config.data,
                type: config.type ? config.type : 'POST',
                beforeSend: config.beforeSend,
                error: config.error,
                success: config.success,
                complete: completeFn
            });
        },

        /**
         * ղ
         * @param id ڵid
         * @param completeFn ɺִеĲ
         */
        addFavorite: function (id, completeFn) {
            this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_addfavorite"
            }, completeFn);
        },

        /**
         * ȡղ
         * @param id ڵid
         * @param completeFn ɺִеĲ
         */
        removeFavorite: function (id, completeFn) {
            this.ajax({
                data: {ids: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_removefavorite"
            }, completeFn);
        },

        /**
         * һĿ¼idȡݹȡĿ¼
         * @param id {Number} Ŀ¼id
         * @returns {string|json} Ŀ¼
         */
        getReportTreeById: function (id, completeFn) {
            this.ajax({
                data: {id: id},
                url: FR.servletURL + "?op=fs_main&cmd=module_getrootreports"
            }, completeFn);
        },

        getModuleTreeById: function (id, completeFn) {
            this.ajax({
                url: FR.servletURL + "?op=fs_main&cmd=getmoduleitems",
                data: {id: id}
            }, completeFn);
        },

        setTheme: function (theme, completeFn) {
            this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=settheme",
                data: theme
            }, completeFn)
        },

        saveTheme: function (newTheme, completeFn) {
            this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=save_theme",
                data: newTheme
            }, completeFn)
        },

        getCustomThemeList: function (completeFn) {
            this.ajax({
                url: FR.servletURL + "?op=fs_manager&cmd=gettheme"
            }, completeFn)
        }
    },

    /**
     * ͬ
     * @since 8.0
     */
    Sync: {
        /**
         * ͬajax
         * @config ͬ
         * @return string/json Ľ
         */
        ajax: function (config) {
            var returnData = "";
            FR.ajax({
                url: config.url,
                async: false,
                data: config.data,
                type: config.type ? config.type : 'POST',
                beforeSend: config.beforeSend,
                error: config.error,
                complete: function (res, status) {
                    try {
                        // ̨JSONʽ
                        returnData = FR.jsonDecode(res.responseText);
                    } catch (Error) {
                        FR.Msg.toast("AnalysisData Error!");
                    }
                }
            });
            return returnData;
        },

        /**
         * ȡղؼ
         * @return {*} ղݵ
         */
        getFavorite: function () {
            return this.ajax({
                url: FR.servletURL + "?op=fs_main&cmd=module_getfavorite"
            });
        }
    }
});
