/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;

public class FileRepository
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "FileRepository";
    private String path = null;
    private static FRLogger log = FRLogger.getLogger();

    public FileRepository() {
        if (FRContext.getCurrentEnv() != null) {
            this.setPath(FRContext.getCurrentEnv().getPath() + File.separator + "schedule");
        }
    }

    public FileRepository(String string) {
        this.path = string;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("path", (Object)this.getPath());
        return jSONObject;
    }

    public static FileRepository analyzeJSON(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("path");
            return new FileRepository(string);
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public File getTaskDirFile(String string) {
        return new File(this.getPath(), string);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("path", null)) != null) {
            this.setPath(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("path", this.path).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileRepository)) {
            return false;
        }
        FileRepository fileRepository = (FileRepository)object;
        return ComparatorUtils.equals((Object)fileRepository.getPath(), (Object)this.getPath());
    }

    public Object clone() throws CloneNotSupportedException {
        FileRepository fileRepository = (FileRepository)super.clone();
        return fileRepository;
    }
}

