/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.TemplateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.cell.CellElementValueConverter;
import com.fr.report.core.SimpleColumnRowNameSpace;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.ResultReport;
import com.fr.schedule.output.OutputFileAction;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;

public abstract class AbstractOutputFileAction
implements OutputFileAction {
    private static final long serialVersionUID = 1L;
    private Map parameterMap = null;
    private ResultWorkBook book;

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public File getPdfFromOutputFile(File[] fileArray) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].getName().endsWith(".pdf")) continue;
            return fileArray[i];
        }
        return null;
    }

    public File getWordFromOutputFile(File[] fileArray) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].getName().endsWith(".docx")) continue;
            return fileArray[i];
        }
        return null;
    }

    public File getExcelFromOutputFile(File[] fileArray) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].getName().endsWith(".xls") && !fileArray[i].getName().endsWith(".xlsx")) continue;
            return fileArray[i];
        }
        return null;
    }

    public File getCprFromOutputFile(File[] fileArray) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].getName().endsWith(".cpr")) continue;
            return fileArray[i];
        }
        return null;
    }

    public File getPngFromOutputFile(File[] fileArray) {
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].getName().endsWith(".png")) continue;
            return fileArray[i];
        }
        return null;
    }

    public String dealWithParameter(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = ParameterProvider.PARAMETERPATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            matcher.appendReplacement(stringBuffer, this.analysisSingleParameter(string2));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String analysisSingleParameter(String string) throws Exception {
        ResultReport resultReport;
        Iterator iterator;
        String string2 = TemplateUtils.render((String)string, (Map)this.parameterMap, (Calculator)Calculator.createCalculator());
        if (StringUtils.isNotEmpty((String)string2)) {
            return string2;
        }
        ColumnRow columnRow = ColumnRow.valueOf((String)string.substring(2, string.length() - 1));
        if (columnRow.getColumn() >= 0 && columnRow.getRow() >= 0 && this.book != null && (iterator = (resultReport = this.book.getResultReport(0)).iteratorOfElementCase()).hasNext()) {
            ElementCase elementCase = (ElementCase)iterator.next();
            Object object = SimpleColumnRowNameSpace.resolveColumnRowRange((ColumnRowRange)ColumnRowRange.columnRow2Range((ColumnRow)columnRow), (ElementCase)elementCase);
            return String.valueOf(CellElementValueConverter.cellElement2CellValue((Object)object));
        }
        return string;
    }

    public void setParameters(Map map) {
        this.parameterMap = map;
    }

    public ResultWorkBook getBook() {
        return this.book;
    }

    public void setBook(ResultWorkBook resultWorkBook) {
        this.book = resultWorkBook;
    }

    public abstract File[] getFilesToDealWith(File[] var1);

    public abstract void doFileAction(File[] var1) throws Exception;

    public abstract JSONObject createJSONConfig() throws JSONException;

    public Object clone() throws CloneNotSupportedException {
        return (AbstractOutputFileAction)super.clone();
    }

    public abstract String getJsonTag();

    public abstract OutputFileAction analyzeJSON(JSONObject var1);
}

