/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.dao.DAOManagerFactory;
import com.fr.data.dao.DataAccessObjectOperator;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.JDBCDataAccessObjectProperties;
import com.fr.fs.dao.properties.ScheduleDAOProperties;
import com.fr.general.FRLogger;
import com.fr.schedule.tables.ScheduleTables;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.platform.tables.QuartzTables;
import java.sql.Connection;

public class SearchDAOManager {
    private static DataAccessObjectOperator manager = null;
    private static FRLogger log = FRLogger.getLogger();

    public static DataAccessObjectSession createSession() {
        return SearchDAOManager.getJDBCDAOManager().startSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataAccessObjectOperator getJDBCDAOManager() {
        if (manager == null) {
            ScheduleDAOProperties scheduleDAOProperties = ScheduleDAOProperties.getInstance();
            manager = DAOManagerFactory.createJDBCDAOManager((JDBCDataAccessObjectProperties)scheduleDAOProperties);
            try {
                manager.checkTables();
                Connection connection = PlatformDB.getDB().createConnection();
                try {
                    QuartzTables quartzTables = new QuartzTables();
                    ScheduleTables scheduleTables = new ScheduleTables();
                    quartzTables.generatorModuleTables(connection);
                    scheduleTables.generatorModuleTables(connection);
                }
                finally {
                    DBUtils.closeConnection((Connection)connection);
                }
            }
            catch (Exception exception) {
                ScheduleLogUtils.error(exception);
            }
        }
        return manager;
    }
}

