/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.AbstractParameterTableData;
import com.fr.data.VersionInfoTableData;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FUNC;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigGetRegisterInfoAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "sc_get_registerinfo";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 8L)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        VersionInfoTableData versionInfoTableData = new VersionInfoTableData();
        DataModel dataModel = versionInfoTableData.createDataModel(Calculator.createCalculator());
        JSONObject jSONObject2 = new JSONObject();
        int n = dataModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            jSONObject2.put(String.valueOf(dataModel.getValueAt(i, 0)), dataModel.getValueAt(i, 1));
        }
        JSONArray jSONArray = new JSONArray();
        FunctionListTableData functionListTableData = new FunctionListTableData();
        DataModel dataModel2 = functionListTableData.createDataModel(Calculator.createCalculator());
        int n2 = dataModel2.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (!((Boolean)dataModel2.getValueAt(i, 1)).booleanValue()) continue;
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("name", dataModel2.getValueAt(i, 0));
            jSONArray.put((Object)jSONObject3);
        }
        JSONObject jSONObject4 = new JSONObject();
        jSONObject4.put("appinfo", (Object)jSONObject2);
        jSONObject4.put("functionlist", (Object)jSONArray);
        printWriter.print(jSONObject4);
        printWriter.flush();
        printWriter.close();
    }

    public static class FunctionListTableData
    extends AbstractParameterTableData
    implements DataModel {
        private FunctionAndSupport[] datas;
        private String[] names = new String[]{"name", "support", "value"};

        private static FunctionAndSupport as(FUNC fUNC) {
            FunctionAndSupport functionAndSupport = new FunctionAndSupport();
            functionAndSupport.name = fUNC.toString();
            functionAndSupport.support = fUNC.support();
            functionAndSupport.v = BigInteger.ONE.shiftLeft(fUNC.marker());
            return functionAndSupport;
        }

        public FunctionListTableData() {
            ArrayList<FunctionAndSupport> arrayList = new ArrayList<FunctionAndSupport>();
            Iterator iterator = FUNC.getAllFunctionIterator();
            while (iterator.hasNext()) {
                arrayList.add(FunctionListTableData.as((FUNC)iterator.next()));
            }
            this.datas = arrayList.toArray(new FunctionAndSupport[arrayList.size()]);
        }

        public DataModel createDataModel(Calculator calculator) {
            return this;
        }

        public int getColumnCount() throws TableDataException {
            return this.names.length;
        }

        public String getColumnName(int n) throws TableDataException {
            return this.names[n];
        }

        public int getRowCount() throws TableDataException {
            return this.datas.length;
        }

        public Object getValueAt(int n, int n2) throws TableDataException {
            FunctionAndSupport functionAndSupport = this.datas[n];
            if (n2 == 0) {
                return functionAndSupport.name;
            }
            if (n2 == 1) {
                return functionAndSupport.support;
            }
            return functionAndSupport.v;
        }

        public boolean hasRow(int n) throws TableDataException {
            return this.datas.length > n && n >= 0;
        }

        public void release() throws Exception {
        }

        private static final class FunctionAndSupport {
            String name;
            boolean support;
            BigInteger v;

            private FunctionAndSupport() {
            }
        }
    }
}

