/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ConfigManager;
import com.fr.base.ParameterMapNameSpace;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FRLevel;
import com.fr.general.LogConfig;
import com.fr.general.data.DataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.report.log.ErrorLogDetailTableData;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.script.NameSpace;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigGetLogInfoAction
extends ActionNoSessionCMD {
    private static final int TIMESPLITLENGTH = 19;
    private static final int OMISSIONLENGTH = 35;

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 9L)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        LogConfig logConfig = ConfigManager.getInstance().getLogConfig();
        boolean bl = logConfig.isRecordErr();
        jSONObject.put("iserrorrecord", bl);
        String string = String.valueOf(FRLevel.getByLevel((Level)ConfigManager.getInstance().getServerLogLevel()));
        jSONObject.put("loglevel", (Object)string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("START_TIME", WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startTime"));
        hashMap.put("END_TIME", WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"endTime"));
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace((NameSpace)parameterMapNameSpace);
        ErrorLogDetailTableData errorLogDetailTableData = new ErrorLogDetailTableData();
        DataModel dataModel = errorLogDetailTableData.createDataModel(calculator);
        JSONArray jSONArray = new JSONArray();
        int n = dataModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("reportname", dataModel.getValueAt(i, 0));
            String string2 = String.valueOf(dataModel.getValueAt(i, 1));
            string2 = string2.length() > 19 ? string2.substring(0, 19) : string2;
            jSONObject2.put("logtime", (Object)string2);
            String string3 = String.valueOf(dataModel.getValueAt(i, 2));
            String string4 = null;
            if (StringUtils.isNotEmpty((String)string3) && string3.length() > 35) {
                string4 = string3.substring(0, 35);
                string4 = string4 + "...";
            } else {
                string4 = string3;
            }
            jSONObject2.put("detailError", (Object)string3);
            jSONObject2.put("error", (Object)string4);
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("loginfo", (Object)jSONArray);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "sc_get_loginfo";
    }
}

