/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetEntryUsersAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"entryId");
        JSONArray jSONArray = new JSONArray();
        if (!StringUtils.isBlank((String)string)) {
            this.addUserFromCompanyRole(jSONArray, string);
            this.addUserFromCustomRole(jSONArray, string);
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getEntryUsers";
    }

    private void addUserFromCompanyRole(JSONArray jSONArray, String string) throws Exception {
        int n = Integer.parseInt(string.substring(0, 1));
        long l = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            List<EntryTypeAndID> list2 = CompanyRoleControl.getInstance().getAllEntryPrivileges(companyRole.getId());
            HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCompanyUser(companyRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        }
    }

    private void addUserFromCustomRole(JSONArray jSONArray, String string) throws Exception {
        int n = Integer.parseInt(string.substring(0, 1));
        long l = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            List<EntryTypeAndID> list2 = CustomRoleControl.getInstance().getAllEntryPrivileges(customRole.getId());
            HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCustomUser(customRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        }
    }

    private void addCompanyUser(CompanyRole companyRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CompanyRoleControl.getInstance().getUsersID(companyRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private void addCustomUser(CustomRole customRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CustomRoleControl.getInstance().getUsersID(customRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private void addUser(User user, JSONArray jSONArray, EntryTypeAndID entryTypeAndID) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.getLong("id") != user.getId()) continue;
            long l = jSONObject.getLong("view");
            long l2 = this.getView(entryTypeAndID.getView());
            if (l == 0L && l2 == 1L) {
                jSONObject.put("view", 1);
            }
            long l3 = jSONObject.getLong("design");
            long l4 = this.getDesignAndEdit(entryTypeAndID.getAuthorized());
            if (l3 == 0L && l4 == 1L) {
                jSONObject.put("design", 1);
            }
            long l5 = jSONObject.getLong("edit");
            long l6 = this.getDesignAndEdit(entryTypeAndID.getEdit());
            if (l5 == 0L && l6 == 1L) {
                jSONObject.put("edit", 1);
            }
            return;
        }
        JSONObject jSONObject = user.createUnEditInfoJSONConfig();
        jSONObject.put("view", this.getView(entryTypeAndID.getView()));
        jSONObject.put("design", this.getDesignAndEdit(entryTypeAndID.getAuthorized()));
        jSONObject.put("edit", this.getDesignAndEdit(entryTypeAndID.getEdit()));
        jSONObject.put("id", user.getId());
        jSONArray.put((Object)jSONObject);
    }

    private long getView(long l) {
        if (l == 2L) {
            l = 1L;
        }
        return l;
    }

    private long getDesignAndEdit(long l) {
        if (l == 2L) {
            l = 0L;
        }
        return l;
    }
}

