/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.DAOBean;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetEntryRolesAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"entryId");
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = UserControl.getInstance().getAllDepAndCRoleInfo(l);
        this.addCompanyRole(jSONArray, string, jSONArray2);
        this.addCustomRole(jSONArray, string, jSONArray2);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getEntryRoles";
    }

    private void addCompanyRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            if (!this.hasDepOrCRolePrivilege(companyRole, jSONArray2)) continue;
            List<EntryTypeAndID> list2 = CompanyRoleControl.getInstance().getAllEntryPrivileges(companyRole.getId());
            for (EntryTypeAndID entryTypeAndID : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)(entryTypeAndID.getType() + "" + entryTypeAndID.getId()))) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", entryTypeAndID.getView());
                jSONObject.put("design", entryTypeAndID.getAuthorized());
                jSONObject.put("edit", entryTypeAndID.getEdit());
                jSONObject.put("departmentId", companyRole.getDepartmentId());
                jSONObject.put("postId", companyRole.getPostId());
                jSONObject.put("id", (Object)("10086" + companyRole.getPostId()));
                jSONArray.put((Object)jSONObject);
            }
        }
    }

    private void addCustomRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!this.hasDepOrCRolePrivilege(customRole, jSONArray2)) continue;
            List<EntryTypeAndID> list2 = CustomRoleControl.getInstance().getAllEntryPrivileges(customRole.getId());
            for (EntryTypeAndID entryTypeAndID : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)(entryTypeAndID.getType() + "" + entryTypeAndID.getId()))) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", entryTypeAndID.getView());
                jSONObject.put("design", entryTypeAndID.getAuthorized());
                jSONObject.put("edit", entryTypeAndID.getEdit());
                jSONObject.put("id", customRole.getId());
                jSONArray.put((Object)jSONObject);
            }
        }
    }

    private boolean hasDepOrCRolePrivilege(DAOBean dAOBean, JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            String string;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (!jSONObject.has("id")) continue;
            if (jSONObject.has("departmentid")) {
                long l = jSONObject.getLong("departmentid");
                if (!(dAOBean instanceof CompanyRole) || l != ((CompanyRole)dAOBean).getDepartmentId()) continue;
                return true;
            }
            String string2 = string = jSONObject.has("text") ? jSONObject.getString("text") : "";
            if (!(dAOBean instanceof CustomRole) || !ComparatorUtils.equals((Object)string, (Object)((CustomRole)dAOBean).getRolename())) continue;
            return true;
        }
        return false;
    }
}

