/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetAllLoginUsersAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (l != UserControl.getInstance().getSuperManagerID()) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"dataFilter");
        if (string == null) {
            string = "";
        } else {
            int n = Math.max(string.lastIndexOf(","), string.lastIndexOf("\uff0c"));
            string = string.substring(n + 1);
        }
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"type");
        List<LoginUser> list = ComparatorUtils.equalsIgnoreCase((String)string2, (String)"fs") ? LoginUserControl.getFSLoginUserList() : LoginUserControl.getMobileLoginUserList();
        JSONArray jSONArray = new JSONArray();
        for (LoginUser loginUser : list) {
            JSONObject jSONObject = loginUser.createJSONConfig();
            User user = UserControl.getInstance().getByUserName(loginUser.getUsername());
            if (user != null) {
                jSONObject.put("realname", (Object)user.getRealname());
                if (!this.isKeywordInUserInfo(user, string)) continue;
                jSONArray.put((Object)jSONObject);
                continue;
            }
            jSONArray.put((Object)jSONObject);
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    private boolean isKeywordInUserInfo(User user, String string) {
        return this.containsNoCase(user.getUsername(), string) || this.containsNoCase(user.getRealname(), string);
    }

    private boolean containsNoCase(String string, String string2) {
        return string.toLowerCase().contains(string2.toLowerCase());
    }

    public String getCMD() {
        return "auth_getall_loginusers";
    }
}

