/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetAllCustomRoleAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        JSONArray jSONArray = new JSONArray();
        LinkedList<CustomRole> linkedList = new LinkedList<CustomRole>();
        if (FSConfig.getInstance().getAuthorizeAttr().isGradeAuthority()) {
            object = UserControl.getInstance().getAllDepAndCRoleInfo(l);
            int n = object.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = object.getJSONObject(i);
                if (jSONObject.has("departmentid")) continue;
                long l2 = jSONObject.getLong("id");
                CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l2);
                this.addCustomRoleToList(linkedList, customRole);
            }
        } else {
            object = CustomRoleControl.getInstance().getAllCustomRole();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CustomRole customRole = (CustomRole)((Object)iterator.next());
                this.addCustomRoleToList(linkedList, customRole);
            }
        }
        for (CustomRole customRole : linkedList) {
            jSONArray.put((Object)customRole.createJSONConfig());
        }
        object = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        ((PrintWriter)object).print(jSONArray);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private void addCustomRoleToList(LinkedList<CustomRole> linkedList, CustomRole customRole) {
        if (customRole.getId() > -1000L) {
            linkedList.addFirst(customRole);
        } else {
            linkedList.addLast(customRole);
        }
    }

    public String getCMD() {
        return "auth_getcustomrole";
    }
}

