/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.FSTheme;
import com.fr.fs.basic.Theme;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.stable.StringUtils;
import com.fr.web.utils.WebUtils;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSOpenEntryService
extends AbstractFSAuthService {
    private int expires = -10;

    public String actionOP() {
        return "fs";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        FSContext.initData();
        this.syncUserID(httpServletRequest);
        httpServletRequest.getSession(true).removeAttribute("originalURL");
        PrivilegeVote privilegeVote = this.getFSVote(httpServletRequest, httpServletResponse);
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess((HttpServletRequest)httpServletRequest);
        if (!(privilegeVote.isPermitted() || authentication != null && authentication.isRoot())) {
            privilegeVote.action(httpServletRequest, httpServletResponse);
            return;
        }
        this.init(httpServletRequest, httpServletResponse);
    }

    protected void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", (long)this.expires);
        String string = FSOpenEntryService.getUserShowName(httpServletRequest);
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        Map<String, Object> map = FSConfig.getInstance().getFSParaMap(string, l);
        map.put("homePageUrl", UserControl.getInstance().getHomePageURL(l, false, this.getCheckTimestamp(httpServletRequest)));
        map.put("ThemeSrc", this.loadFSTheme(httpServletRequest));
        map.put("isPlatForm", !FSRegisterForBI.isSupportFS());
        WebUtils.writeOutTemplate((String)this.searchTemplatePath(httpServletRequest), (HttpServletResponse)httpServletResponse, map);
    }

    private String loadFSTheme(HttpServletRequest httpServletRequest) {
        String string = "";
        Theme theme = FSConfig.getInstance().getTheme();
        if (theme.isCustom()) {
            FSTheme.getInstance().loadThemeByName(theme);
            String string2 = theme.getJavaScriptPath();
            String string3 = theme.getStylePath();
            String string4 = WebUtils.createServletURL((HttpServletRequest)httpServletRequest);
            if (StringUtils.isNotEmpty((String)string2)) {
                string = string + "<script type=\"text/javascript\" src=\"" + string4 + "?op=resource&resource=" + string2 + "\"></script>";
            }
            if (StringUtils.isNotEmpty((String)string3)) {
                string = string + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string4 + "?op=resource&resource=" + string3 + "\"/>";
            }
        }
        return string;
    }

    protected String searchTemplatePath(HttpServletRequest httpServletRequest) {
        if ("true".equals(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"debug"))) {
            return "/com/fr/fs/web/frame/fs_debug.html";
        }
        return "/com/fr/fs/web/frame/fs.html";
    }

    protected String getCheckTimestamp(HttpServletRequest httpServletRequest) {
        String string = Calendar.getInstance().getTime().toString();
        boolean bl = Boolean.valueOf(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"notchecked"));
        if (bl) {
            string = "";
        }
        return string;
    }
}

