/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.service.FSEntryInfoAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryRemoveReportAction
extends FSEntryInfoAction {
    public String getCMD() {
        return "removereport";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 2L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"entryIds");
        try {
            this.delEntrys(string, l);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            printWriter.write(this.noPrivilegeExceptionOutput());
            printWriter.flush();
            printWriter.close();
        }
    }

    private void delEntrys(String string, long l) throws Exception {
        String[] stringArray = string.split(",");
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i].substring(0, 1));
            int n2 = Integer.parseInt(stringArray[i].substring(1));
            this.deleteEntry(set, n, n2);
        }
    }

    private void deleteEntry(Set set, int n, int n2) throws Exception {
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        Entry entry = EntryControl.getInstance().getEntry(n, n2);
        if (!FSConfig.getInstance().getAuthorizeAttr().isEditReportAuthority() && !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(n, entry.getParentId()))) {
            throw new NoPrivilegeException();
        }
        EntryControl.getInstance().deleteEntry(n, n2);
    }
}

