/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryRemoveFolderAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "removefolder";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 2L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"folderId");
        try {
            this.deleteFolderById(string, l);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            printWriter.write("-1");
            printWriter.flush();
            printWriter.close();
        }
    }

    private void deleteFolderById(String string, long l) throws Exception {
        long l2 = Long.parseLong(string);
        if (!UserControl.getInstance().hasEntryPrivilege(l, 0, l2)) {
            throw new NoPrivilegeException();
        }
        FSPrivilegeTools fSPrivilegeTools = FSPrivilegeTools.getInstance();
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        if (FSConfig.getInstance().getAuthorizeAttr().isEditReportAuthority() && l != UserControl.getInstance().getSuperManagerID() && !fSPrivilegeTools.hasFolderEditPrivilege(set, EntryTypeAndID.getInstance(0, l2))) {
            throw new NoPrivilegeException();
        }
        EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(l2);
        this.recursiveDeleteFolderByID(entryTreeFolderNode);
    }

    private void recursiveDeleteFolderByID(EntryTreeFolderNode entryTreeFolderNode) throws Exception {
        Entry[] entryArray = entryTreeFolderNode.getNodes();
        Object[] objectArray = entryArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry = objectArray[i];
            EntryControl.getInstance().deleteEntry(entry);
        }
        for (Object object : objectArray = entryTreeFolderNode.getFolderNodes()) {
            this.recursiveDeleteFolderByID((EntryTreeFolderNode)object);
        }
        EntryControl.getInstance().deleteEntry(entryTreeFolderNode.getFolder());
    }
}

