/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.general.DeclareRecordType;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.CSVExporter;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.HTMLExporter;
import com.fr.io.exporter.ImageExporter;
import com.fr.io.exporter.PDFExporter;
import com.fr.io.exporter.SVGExporter;
import com.fr.io.exporter.TextExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.log.LogUtils;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractEmailActionTools {
    protected String fileName = "report";
    protected PrintWriter writer;
    protected ReportSessionIDInfor sessionIDInfor = null;
    protected File attachFile = null;

    protected void getPrintWriterWhileSendFailed() {
        if (this.writer == null) {
            return;
        }
        this.writer.println("{\"status\":\"error\"}");
    }

    protected void getPrintWriterSuccessful() {
        if (this.writer == null) {
            return;
        }
        this.writer.println("{\"status\":\"success\"}");
    }

    protected void closePrintWriter() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
    }

    protected AppExporter getExporterFormat(String string) {
        if (string.equalsIgnoreCase("PDF")) {
            return new PDFExporter();
        }
        if (string.equalsIgnoreCase("Excel")) {
            return new ExcelExporter(null);
        }
        if (string.equalsIgnoreCase("SVG")) {
            return new SVGExporter();
        }
        if (string.equalsIgnoreCase("CSV")) {
            return new CSVExporter();
        }
        if (string.equalsIgnoreCase("Text")) {
            return new TextExporter();
        }
        if (string.equalsIgnoreCase("Word")) {
            return new WordExporter();
        }
        if (string.equalsIgnoreCase("Html")) {
            return new HTMLExporter();
        }
        return null;
    }

    protected DeclareRecordType getExporterType(String string) {
        if (string.equalsIgnoreCase("PDF")) {
            return DeclareRecordType.EXPORT_TYPE_PDF;
        }
        if (string.equalsIgnoreCase("Excel")) {
            return DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL;
        }
        if (string.equalsIgnoreCase("SVG")) {
            return DeclareRecordType.EXPORT_TYPE_SVG;
        }
        if (string.equalsIgnoreCase("CSV")) {
            return DeclareRecordType.EXPORT_TYPE_CSV;
        }
        if (string.equalsIgnoreCase("Text")) {
            return DeclareRecordType.EXPORT_TYPE_TEXT;
        }
        if (string.equalsIgnoreCase("Word")) {
            return DeclareRecordType.EXPORT_TYPE_WORD;
        }
        if (string.equalsIgnoreCase("Html")) {
            return DeclareRecordType.EXPORT_TYPE_HTML;
        }
        return null;
    }

    protected String getAttachFileName(HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__filename__");
        if (StringUtils.isEmpty((String)string)) {
            string = this.sessionIDInfor.getWebTitle().replaceAll("\\s", "_");
            string = string.replaceAll(",", "_");
        }
        return string;
    }

    protected String getAttachFileFormat(String string) {
        if (string.equalsIgnoreCase("PDF")) {
            return "pdf";
        }
        if (string.equalsIgnoreCase("Excel")) {
            ResultWorkBook resultWorkBook = this.sessionIDInfor.getWorkBook2Show();
            boolean bl = false;
            for (int i = 0; i < resultWorkBook.getReportCount(); ++i) {
                if (!(resultWorkBook.getResultReport(i) instanceof A) && !(resultWorkBook.getResultReport(i) instanceof C)) continue;
                bl = true;
                break;
            }
            return bl ? "zip" : (ExcelUtils.checkPOIJarExist() ? "xlsx" : "xls");
        }
        if (string.equalsIgnoreCase("SVG")) {
            return "svg";
        }
        if (string.equalsIgnoreCase("HTML")) {
            return "zip";
        }
        if (string.equalsIgnoreCase("CSV")) {
            return "csv";
        }
        if (string.equalsIgnoreCase("Text")) {
            return "txt";
        }
        if (string.equalsIgnoreCase("Word")) {
            return "doc";
        }
        if (string.equalsIgnoreCase("Html")) {
            return "html";
        }
        return null;
    }

    protected File exportTemplateAsImage(HttpServletRequest httpServletRequest) throws Exception {
        String string = "png";
        File file = new File(CacheManager.getInstance().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + this.fileName + "." + string);
        StableUtils.mkdirs((File)file.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ImageExporter imageExporter = new ImageExporter(string);
        try {
            LogUtils.exportAndLogRecord((AppExporter)imageExporter, (OutputStream)fileOutputStream, (ReportRepositoryDeal)new ReportRepositoryDeal(httpServletRequest, this.sessionIDInfor), (DeclareRecordType)DeclareRecordType.EXPORT_TYPE_IMAGE_PNG);
            file.deleteOnExit();
            file.getParentFile().deleteOnExit();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        return file;
    }
}

