/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.platform.entry;

import com.fr.data.dao.DAOBean;
import com.fr.fs.web.ShowType;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class BaseEntry
extends DAOBean
implements Entry {
    public static final String ID = "id";
    public static final String PARENTID = "parent";
    public static final String DISPLAYNAME = "name";
    public static final String DESCRIPTION = "description";
    public static final int IDTYPE = 4;
    public static final int PARENTIDTYPE = 4;
    public static final int DISPLAYNAMETYPE = 12;
    public static final int DESCRIPTIONTYPE = 12;
    public static final String SORTINDEX = "sortindex";
    public static final int SORTINDEXTYPE = -5;
    private long parentId;
    private String displayName;
    private String description;
    protected long sortindex;

    public BaseEntry() {
    }

    public BaseEntry(String string) {
        this.displayName = string;
    }

    public BaseEntry(String string, String string2) {
        this(string);
        this.description = string2;
    }

    public JSONObject createShowJSONConfig() throws JSONException {
        return this.createJSONConfig();
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(ID, (Object)(this.getTypePrefix() + this.getId()));
        jSONObject.put("type", (Object)this.getTypePrefix());
        jSONObject.put("parentId", (Object)("0" + this.getParentId()));
        jSONObject.put("text", (Object)this.getRealDisplayName());
        jSONObject.put("value", (Object)(this.getTypePrefix() + this.getId()));
        jSONObject.put(DESCRIPTION, (Object)this.getDescription());
        jSONObject.put(SORTINDEX, this.sortindex);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        this.setDisplayName(jSONObject.getString("text"));
        this.setDescription(jSONObject.getString(DESCRIPTION));
        this.setParentId(jSONObject.getLong("parentId"));
        if (jSONObject.has(SORTINDEX)) {
            this.setSortindex(jSONObject.getLong(SORTINDEX));
        }
        if (jSONObject.has(ID) && StringUtils.isNotBlank((String)jSONObject.getString(ID))) {
            this.setId(jSONObject.getLong(ID));
        }
    }

    public abstract String getTypePrefix();

    public long getSortindex() {
        return this.sortindex;
    }

    public void setSortindex(long l) {
        this.sortindex = l;
    }

    public void setParentId(long l) {
        this.parentId = l;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected String getRealDisplayName() {
        return this.displayName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public ShowType getShowType() {
        return ShowType.NONE;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    protected int hashCode4Properties() {
        int n = 1;
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.displayName == null ? 0 : this.displayName.hashCode());
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (int)(this.parentId ^ this.parentId >>> 32);
        return n;
    }

    public boolean equals4Properties(Object object) {
        if (!(object instanceof BaseEntry)) {
            return false;
        }
        BaseEntry baseEntry = (BaseEntry)object;
        return baseEntry.id == this.id && baseEntry.parentId == this.parentId && ComparatorUtils.equals((Object)baseEntry.displayName, (Object)this.displayName) && ComparatorUtils.equals((Object)baseEntry.description, (Object)this.description);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseEntry baseEntry = (BaseEntry)super.clone();
        return baseEntry;
    }
}

