/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.third.org.quartz.CronTrigger;
import com.fr.third.org.quartz.Trigger;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class CronExpressionITrigger
extends ITrigger {
    public static final String TABLE_NAME = "fr_cronexpression_itrigger";
    public static final int TYPE = 4;
    public static final String NAME = "cronexpression";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(CronExpressionITrigger.class, new Table("fr_cronexpression_itrigger"), (FieldColumnMapper[])ArrayUtils.addAll((Object[])ITrigger.ITRIGGER_FIELDMAPPER, (Object[])new FieldColumnMapper[]{ITrigger.EndTimeFieldMapper, new CommonFieldColumnMapper("cronExpression", 12, "cron_expression", new ColumnSize(255), true)}));
    private String cronExpression = "";
    private static final long serialVersionUID = 1L;

    public Trigger createTrigger() {
        CronTrigger cronTrigger = new CronTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                cronTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("When build the cronExpression, The statemenet is illegal:" + this.cronExpression);
            }
        }
        if (this.getEndTime() != null) {
            cronTrigger.setEndTime(this.getEndTime());
        }
        try {
            cronTrigger.setCronExpression(this.cronExpression);
        }
        catch (ParseException parseException) {
            FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
        }
        cronTrigger.setTimeZone(TimeZone.getTimeZone(this.getTimeZoneID()));
        cronTrigger.setMisfireInstruction(2);
        return cronTrigger;
    }

    public int getITriggerIdPrefix() {
        return 4;
    }

    public String getCroExpression() {
        return this.cronExpression;
    }

    public void setCroExpression(String string) {
        this.cronExpression = string;
    }

    public ITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            CronExpressionITrigger cronExpressionITrigger = null;
            long l = jSONObject.getLong("startType");
            Date date = null;
            if (l == 2L) {
                String string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
                }
            }
            cronExpressionITrigger = new CronExpressionITrigger();
            cronExpressionITrigger.setStartType(l);
            cronExpressionITrigger.setStartTime(date);
            if (jSONObject.has("id")) {
                cronExpressionITrigger.setId(jSONObject.getLong("id"));
            }
            if (jSONObject.has("cronExpression")) {
                cronExpressionITrigger.setCroExpression(jSONObject.getString("cronExpression"));
            }
            return cronExpressionITrigger;
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            return null;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("recurrenceType", (Object)NAME);
        if (this.getEndTime() != null) {
            Date date = this.getEndTime();
            String string = DateUtils.DATETIMEFORMAT2.format(date);
            jSONObject.put("endTime", (Object)string);
        }
        jSONObject.put("cronExpression", (Object)this.cronExpression);
        return jSONObject;
    }
}

