/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.base.CustomConfigManager;
import com.fr.data.NetworkHelper;
import com.fr.fs.privilege.auth.BasePrivilegeFilter;
import com.fr.general.FRLogger;
import com.fr.general.http.HttpClient;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.PrivilegeFilterManager;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.privilege.filter.core.RSAUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DigitalSignPrivilegeFilter
extends BasePrivilegeFilter {
    private static final long serialVersionUID = 1L;
    private static final String XML_TAG = "PFKEYURL";
    private static final String[] CHECK_NAMES = new String[]{"reportlet", "reportlets", "chartlet", "formlet", "resultlet"};
    private static final int SUCCESS = 1;
    private static final int TIMEOUT = 0;
    private static final int ERROR = -1;
    public static int TIME_OUT = 2000;
    private static PublicKey publicKey = null;
    private static int toGetKeyCount = 0;
    private String keyURL = null;

    public DigitalSignPrivilegeFilter() {
    }

    public DigitalSignPrivilegeFilter(String string) {
        this.keyURL = string;
    }

    public String getKeyURL() {
        return this.keyURL;
    }

    public void setKeyURL(String string) {
        this.keyURL = string;
    }

    public void init4Server() {
        DigitalSignPrivilegeFilter.toGetPublicKey(false);
    }

    private static synchronized void toGetPublicKey(boolean bl) {
        ++toGetKeyCount;
        if (bl) {
            try {
                DigitalSignPrivilegeFilter.getPublicKey();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        if (!(PrivilegeManager.getInstance().getPrivilegeFilter() instanceof DigitalSignPrivilegeFilter)) {
            return;
        }
        if (publicKey == null) {
            PrivilegeFilterManager.PRIVILEGE_FILTER_TIMER = new Timer();
            PrivilegeFilterManager.PRIVILEGE_FILTER_TIMER.schedule(new TimerTask(){

                public void run() {
                    DigitalSignPrivilegeFilter.toGetPublicKey(true);
                }
            }, toGetKeyCount * toGetKeyCount * TIME_OUT);
        }
    }

    public static synchronized void getPublicKey() throws Exception {
        if (publicKey != null) {
            return;
        }
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        PrivilegeFilter privilegeFilter = privilegeManager.getPrivilegeFilter();
        if (!(privilegeFilter instanceof DigitalSignPrivilegeFilter)) {
            throw new Exception("No DigitalSign Settings Info exists!");
        }
        String string = ((DigitalSignPrivilegeFilter)privilegeFilter).getKeyURL();
        if (StringUtils.isBlank((String)string)) {
            throw new Exception("Get PublicKey Url is blank");
        }
        HttpClient httpClient = new HttpClient(string);
        int n = httpClient.getResponseCode();
        if (n != 200) {
            throw new Exception("Get PublicKey method failed, status is : " + n);
        }
        DigitalSignPrivilegeFilter.generateKey(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateKey(HttpClient httpClient) throws Exception {
        try {
            String string = httpClient.getResponseText();
            if (StringUtils.isBlank((String)string)) {
                throw new Exception("Get PublicKey failed, response is " + string);
            }
            String[] stringArray = string.split("&");
            if (stringArray == null || stringArray.length != 2) {
                throw new Exception("Get PublicKey failed, response style is wrong");
            }
            BigInteger bigInteger = null;
            BigInteger bigInteger2 = null;
            try {
                bigInteger = new BigInteger(stringArray[0]);
                bigInteger2 = new BigInteger(stringArray[1]);
            }
            catch (Exception exception) {
                throw new Exception("Generate PublicKey failed, response style is wrong, modulus str is " + stringArray[0] + ", exponent str is " + stringArray[1]);
            }
            publicKey = RSAUtils.generateRSAPublicKey((BigInteger)bigInteger, (BigInteger)bigInteger2);
            if (publicKey != null) {
                FRLogger.getLogger().infoWithServerLevel("Get PF KEY Successfully!");
            }
        }
        finally {
            httpClient.release();
        }
    }

    public static boolean verify(byte[] byArray, byte[] byArray2) {
        if (publicKey == null) {
            try {
                DigitalSignPrivilegeFilter.getPublicKey();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                return false;
            }
        }
        if (publicKey == null) {
            FRLogger.getLogger().error("No publicKey exists, verify failed.");
            return false;
        }
        try {
            return RSAUtils.verify((byte[])byArray, (byte[])byArray2, (PublicKey)publicKey);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Privilege Filter Verify Failed " + exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public PrivilegeVote filter(HttpServletRequest httpServletRequest) {
        int n = this.doFilter(httpServletRequest);
        if (n == 1) {
            return PrivilegeVoteImpls.SUCCESS;
        }
        if (n == 0) {
            return PrivilegeVoteImpls.MP_AUTH_TIMEOUT;
        }
        return super.isHyperLinkNoCheck(httpServletRequest);
    }

    private int doFilter(HttpServletRequest httpServletRequest) {
        byte[] byArray;
        String string = null;
        for (int i = 0; i < CHECK_NAMES.length && !StringUtils.isNotBlank((String)(string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)CHECK_NAMES[i]))); ++i) {
        }
        if (StringUtils.isBlank(string)) {
            return 1;
        }
        String string2 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_dsigninfo");
        if (StringUtils.isBlank((String)string2)) {
            return -1;
        }
        String string3 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_dscurrenttime");
        if (StringUtils.isBlank((String)string3)) {
            return -1;
        }
        try {
            long l = Long.parseLong(string3);
            if (System.currentTimeMillis() - l > this.getTimeout()) {
                return 0;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            return -1;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string4 = null;
        if (httpSession != null) {
            string4 = (String)httpSession.getAttribute("fr_username");
        }
        String string5 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"op");
        String string6 = string + (string5 != null ? "&" + string5 : "") + "&" + string3 + (string4 != null ? "&" + string4 : "");
        try {
            byArray = string6.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            return -1;
        }
        if (DigitalSignPrivilegeFilter.verify(byArray, RSAUtils.hexStringToBytes((String)string2))) {
            return 1;
        }
        return -1;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && XML_TAG.equals(xMLableReader.getTagName())) {
            this.keyURL = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.keyURL != null) {
            xMLPrintWriter.startTAG(XML_TAG).textNode(this.keyURL).end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DigitalSignPrivilegeFilter digitalSignPrivilegeFilter = (DigitalSignPrivilegeFilter)super.clone();
        digitalSignPrivilegeFilter.keyURL = this.keyURL;
        return digitalSignPrivilegeFilter;
    }

    public int getID() {
        return 2;
    }

    protected long getTimeout() {
        return CustomConfigManager.getInstance().getDigitalPrivilegeTimeout();
    }
}

