/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import java.util.List;

public class PostControl {
    private static PostControl pc;

    public static PostControl getInstance() {
        if (pc == null) {
            pc = new PostControl();
        }
        return pc;
    }

    public Post getPost(long l) throws Exception {
        return FSConfig.getInstance().getControl().getPostDAO().findByID(l);
    }

    public Post getPostByName(String string) throws Exception {
        return FSConfig.getInstance().getControl().getPostDAO().findByPostName(string);
    }

    public String getPostName(long l) throws Exception {
        Post post = FSConfig.getInstance().getControl().getPostDAO().findByID(l);
        if (post != null) {
            return post.getPostname();
        }
        return null;
    }

    public List getAllPost(boolean bl) throws Exception {
        List list = FSConfig.getInstance().getControl().getPostDAO().findAll();
        if (!bl && list != null) {
            list.remove((Object)new Post(CompanyRoleControl.getInstance().getPostAllID()));
        }
        return list;
    }

    public JSONArray getAllPostInfo(boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getAllPost(bl);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Post post = (Post)((Object)list.get(i));
                JSONObject jSONObject = post.createJSONConfig();
                jSONObject.put("value", (Object)post.createJSONConfig());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public boolean addPost(Post post) throws Exception {
        if (post == null) {
            return false;
        }
        post.setId(-1L);
        FSConfig.getInstance().getControl().getPostDAO().save(post);
        return post.getId() >= 0L;
    }

    public boolean deletePost(long l) throws Exception {
        boolean bl = FSConfig.getInstance().getControl().getPostDAO().deleteByID(l);
        if (bl) {
            try {
                UserCache.refreshAfterDelPost(l);
            }
            catch (Exception exception) {
                UserCache.removeAllCache();
            }
        }
        return bl;
    }
}

