/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.cache.LoginUserCache;
import com.fr.fs.dao.properties.LoginUserDAO;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginUserControl {
    public static boolean hasLoginUser(String string) {
        return LoginUserCache.containCache(string);
    }

    public static boolean hasFSLoginUser(String string) {
        return LoginUserControl.hasLoginUserByType(string, 1);
    }

    public static boolean hasMobileLoginUser(String string) {
        return LoginUserControl.hasLoginUserByType(string, 2);
    }

    private static boolean hasLoginUserByType(String string, int n) {
        if (LoginUserControl.hasLoginUser(string)) {
            LoginUser loginUser = LoginUserCache.getLoginUser(string);
            return (loginUser.getLoginType() & n) > 0;
        }
        return false;
    }

    public static LoginUser getLoginUser(String string) {
        return LoginUserCache.getLoginUser(string);
    }

    public static List<LoginUser> getFSLoginUserList() {
        return LoginUserControl.getLoginUserListByType(1);
    }

    public static List<LoginUser> getMobileLoginUserList() {
        return LoginUserControl.getLoginUserListByType(2);
    }

    private static List<LoginUser> getLoginUserListByType(int n) {
        List<LoginUser> list = LoginUserCache.getAllLoginUserListSorted();
        ArrayList<LoginUser> arrayList = new ArrayList<LoginUser>();
        if (list != null) {
            for (LoginUser loginUser : list) {
                if ((loginUser.getLoginType() & n) <= 0) continue;
                arrayList.add(loginUser);
            }
        }
        return arrayList;
    }

    public static boolean addLoginUser(LoginUser loginUser) throws Exception {
        if (loginUser == null || StringUtils.isEmpty((String)loginUser.getUsername())) {
            return false;
        }
        LoginUserDAO.getInstance().save(loginUser);
        if (loginUser.getId() < 0L) {
            return false;
        }
        try {
            LoginUserCache.cache(loginUser);
        }
        catch (Exception exception) {
            LoginUserCache.reInit();
        }
        return true;
    }

    public static boolean saveOrUpdateLoginUser(LoginUser loginUser) throws Exception {
        if (loginUser == null) {
            return false;
        }
        boolean bl = LoginUserDAO.getInstance().saveOrUpdate(loginUser);
        if (bl) {
            try {
                LoginUserCache.cache(loginUser);
            }
            catch (Exception exception) {
                LoginUserCache.reInit();
            }
            return true;
        }
        return false;
    }

    public static boolean deleteLoginUser(LoginUser loginUser) throws Exception {
        if (loginUser == null) {
            return false;
        }
        boolean bl = LoginUserDAO.getInstance().delete(loginUser);
        if (bl) {
            try {
                LoginUserCache.removeCache(loginUser.getUsername());
            }
            catch (Exception exception) {
                LoginUserCache.reInit();
            }
            return true;
        }
        return false;
    }
}

