/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.base.entity.HomePage;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.cache.HomePageCache;
import com.fr.fs.dao.HomePageDAO;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePageControl {
    private static HomePageControl hpc;
    private final Object SORT_LOCK = new Object();

    public static HomePageControl getInstance() {
        if (hpc == null) {
            hpc = new HomePageControl();
        }
        return hpc;
    }

    public HomePage getHomePage(long l) {
        return HomePageCache.getHomePage(l);
    }

    public JSONArray getAllHomePageInfo() throws JSONException {
        return HomePageCache.getAllHomePageInfo();
    }

    public JSONArray getAllHomePageSortedInfo() throws JSONException {
        HomePage[] homePageArray;
        JSONArray jSONArray = new JSONArray();
        for (HomePage homePage : homePageArray = HomePageCache.getAllHomePagesSorted()) {
            jSONArray.put((Object)homePage.createJSONConfig());
        }
        return jSONArray;
    }

    public List<RoleHomePagePrivilege> getAllRoleHomePagePrivilege() {
        List<HomePage> list = HomePageCache.getAllHomePages();
        ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
        if (list != null) {
            for (HomePage homePage : list) {
                RoleHomePagePrivilege roleHomePagePrivilege = new RoleHomePagePrivilege(homePage.getId(), 1L);
                try {
                    arrayList.add(roleHomePagePrivilege);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        }
        return arrayList;
    }

    public boolean addHomePage(HomePage homePage) throws Exception {
        if (homePage == null) {
            return false;
        }
        HomePageDAO.getInstance().save(homePage);
        if (homePage.getId() < 0L) {
            return false;
        }
        try {
            HomePageCache.cache(homePage);
        }
        catch (Exception exception) {
            HomePageCache.reInit();
        }
        return true;
    }

    public boolean saveOrUpdateHomePage(HomePage homePage) throws Exception {
        if (homePage == null) {
            return false;
        }
        boolean bl = HomePageDAO.getInstance().saveOrUpdate(homePage);
        if (bl) {
            try {
                HomePageCache.cache(homePage);
            }
            catch (Exception exception) {
                HomePageCache.reInit();
            }
            return true;
        }
        return false;
    }

    public void sortHomePage(long l, int n) throws Exception {
        HomePage homePage;
        if (l > 0L && n >= 0 && (homePage = HomePageControl.getInstance().getHomePage(l)) != null) {
            this.sortHomePageOrder(homePage, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortHomePageOrder(HomePage homePage, int n) throws Exception {
        Object object = this.SORT_LOCK;
        synchronized (object) {
            HomePage[] homePageArray = HomePageCache.getAllHomePagesSorted();
            int n2 = homePageArray.length;
            n = n2 - Math.min(n, n2);
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (homePageArray[i].getId() != homePage.getId()) continue;
                for (n3 = i; n3 < n2 - 1; ++n3) {
                    homePageArray[n3] = homePageArray[n3 + 1];
                }
                for (n3 = n2 - 1; n3 > n; --n3) {
                    homePageArray[n3] = homePageArray[n3 - 1];
                }
                homePageArray[n] = homePage;
                for (n3 = 0; n3 < n2; ++n3) {
                    homePageArray[n3].setSortindex(n2 - n3);
                    if (!HomePageDAO.getInstance().saveOrUpdate(homePageArray[n3])) continue;
                    HomePageCache.cache(homePageArray[n3]);
                }
            }
        }
    }

    public boolean deleteHomePage(HomePage homePage) throws Exception {
        if (homePage == null) {
            return false;
        }
        boolean bl = HomePageDAO.getInstance().delete(homePage);
        if (bl) {
            try {
                this.sortHomePageOrder(homePage, HomePageCache.getHomePageCount());
                HomePageCache.removeCache(homePage.getId());
            }
            catch (Exception exception) {
                HomePageCache.reInit();
            }
            return true;
        }
        return false;
    }
}

